<?php
$ip = isset($_POST['manual_ip']) ? $_POST['manual_ip'] : $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'];
$browserLanguage = isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'Non détecté';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MyFind - Service Gouvernemental de Géolocalisation</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.apple-mapkit.com/mk/5.x.x/mapkit.js"></script>
    <style>
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        .loading-pulse {animation: pulse 2s infinite;}
        .fade-in {animation: fadeIn 1s ease-in;}
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
    </style>
</head>
<body class="bg-gray-50">
    <div id="loader" class="fixed inset-0 bg-white z-50 flex items-center justify-center">
        <div class="text-center">
            <div class="loading-pulse">
                <h2 class="text-2xl font-semibold text-gray-800">MyFind</h2>
                <p class="text-gray-600">Chargement en cours...</p>
            </div>
        </div>
    </div>

    <header class="bg-blue-800 text-white py-6 shadow-lg">
        <div class="container mx-auto px-4">
            <div class="flex items-center justify-between">
                <h1 class="text-3xl font-bold">MyFind</h1>
                <p class="text-sm">Service Gouvernemental de Géolocalisation</p>
            </div>
        </div>
    </header>

    <main class="container mx-auto px-4 py-8">
        <div class="mb-8 bg-white p-6 rounded-lg shadow-md">
            <form method="POST" class="flex gap-4">
                <input type="text" name="manual_ip" placeholder="Entrez une adresse IP" class="flex-1 px-4 py-2 border rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-md hover:bg-blue-700 transition">Rechercher</button>
            </form>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <div class="bg-white p-6 rounded-lg shadow-md">
                <h2 class="text-xl font-semibold mb-4">Carte en temps réel</h2>
                <div id="map" class="h-96 rounded-lg"></div>
            </div>

            <div class="bg-white p-6 rounded-lg shadow-md">
                <h2 class="text-xl font-semibold mb-4">Informations détaillées</h2>
                <div class="space-y-4">
                    <div class="p-4 bg-gray-50 rounded-md">
                        <h3 class="font-medium text-gray-700">Localisation</h3>
                        <p id="location-info" class="text-gray-600">Chargement...</p>
                    </div>
                    <div class="p-4 bg-gray-50 rounded-md">
                        <h3 class="font-medium text-gray-700">Informations sur l'appareil</h3>
                        <ul class="text-gray-600">
                            <li>Navigateur: <span id="browser-info"><?php echo $userAgent; ?></span></li>
                            <li>Langue: <span id="language-info"><?php echo $browserLanguage; ?></span></li>
                            <li>IP actuelle: <span id="ip-info"><?php echo $ip; ?></span></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <script>
    mapkit.init({
        authorizationCallback: function(done) {
            done('eyJraWQiOiJMVThDNFFaVVMzIiwidHlwIjoiSldUIiwiYWxnIjoiRVMyNTYifQ.eyJpc3MiOiJQUDg0RkQ3VUJOIiwiaWF0IjoxNzI4NTc5MjAwLCJvcmlnaW4iOiJpbWF0b3JzLnN5c3RlbXMiLCJleHAiOjE3NDQxMzEyMDB9.EXORWSifGxW9uUQFAJk31JMvqGtmvtmtD7j9GutJg7HOa8_3-E_ele4OAC_jGjjQQzUJ__7P9XUqnUNAW-qHJg');
        }
    });

    function updateLocation() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function(position) {
                const latitude = position.coords.latitude;
                const longitude = position.coords.longitude;
                const coordinate = new mapkit.Coordinate(latitude, longitude);
                map.setCenter(coordinate);
                const annotation = new mapkit.MarkerAnnotation(coordinate, {
                    title: "Votre position",
                    animates: true
                });
                map.removeAnnotations(map.annotations);
                map.addAnnotation(annotation);
                
                document.getElementById('location-info').innerHTML = `
                    Latitude: ${latitude}<br>
                    Longitude: ${longitude}
                `;
            });
        }
    }

    const map = new mapkit.Map('map', {
        showsUserLocation: true,
        showsScale: true,
        showsCompass: true
    });

    window.addEventListener('load', function() {
        setTimeout(function() {
            document.getElementById('loader').style.display = 'none';
        }, 2000);
        updateLocation();
        setInterval(updateLocation, 1000);
    });
    </script>
</body>
</html>