<?php
require_once('vendor/autoload.php');
require_once('config.php');

session_start();

\Stripe\Stripe::setApiKey(STRIPE_SECRET_KEY);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    
    try {
        $session = \Stripe\Checkout\Session::create([
            'payment_method_types' => ['card'],
            'line_items' => [[
                'price_data' => [
                    'currency' => 'eur',
                    'unit_amount' => $data['amount'] * 100,
                    'product_data' => [
                        'name' => $data['projectType'] . ' Development',
                        'description' => 'Complexity: ' . $data['complexity'] . ', Duration: ' . $data['duration'] . ' months'
                    ],
                ],
                'quantity' => 1,
            ]],
            'mode' => 'payment',
            'customer_email' => $data['email'],
            'success_url' => SITE_URL . '/success.php',
            'cancel_url' => SITE_URL . '/cancel.php',
            'metadata' => [
                'name' => $data['name'],
                'email' => $data['email'],
                'phone' => $data['phone'],
                'project_type' => $data['projectType'],
                'complexity' => $data['complexity'],
                'duration' => $data['duration'],
                'features' => implode(', ', $data['features'])
            ]
        ]);

        $_SESSION['project_data'] = $data;
        
        echo json_encode([
            'success' => true,
            'url' => $session->url
        ]);

    } catch (\Stripe\Exception\ApiErrorException $e) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'error' => $e->getMessage()
        ]);
    }
}