<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'db.php';

$slug = $_GET['slug'] ?? '';

if (empty($slug)) {
    http_response_code(400);
    echo json_encode(['error' => 'App slug is required']);
    exit;
}

try {
    $stmt = $pdo->prepare("
        SELECT 
            a.*,
            d.name as developer_name,
            d.website as developer_website,
            d.verified as developer_verified
        FROM apps a 
        LEFT JOIN developers d ON a.developer_id = d.id
        WHERE a.slug = ? AND a.status = 'active'
    ");
    
    $stmt->execute([$slug]);
    $app = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$app) {
        http_response_code(404);
        echo json_encode(['error' => 'App not found']);
        exit;
    }
    
    // Convert boolean fields to proper format
    $app['featured'] = (bool)$app['featured'];
    $app['has_in_app_purchases'] = (bool)$app['has_in_app_purchases'];
    $app['developer_verified'] = (bool)$app['developer_verified'];
    
    if (!$app) {
        http_response_code(404);
        echo json_encode(['error' => 'App not found']);
        exit;
    }
    
    $tagsStmt = $pdo->prepare("SELECT tag FROM app_tags WHERE app_id = ?");
    $tagsStmt->execute([$app['id']]);
    $app['tags'] = $tagsStmt->fetchAll(PDO::FETCH_COLUMN);
    
    if ($app['screenshots']) {
        $app['screenshots'] = json_decode($app['screenshots'], true);
    }
    
    if ($app['changelog']) {
        $app['changelog'] = json_decode($app['changelog'], true);
    }
    
    echo json_encode($app);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}