<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

$userId = intval($_GET['userId']);

$sql = "SELECT u.id, u.first_name, u.last_name, u.profile_image,
        (SELECT CONCAT(title, ' - ', DATE_FORMAT(created_at, '%d/%m/%Y')) 
         FROM sessions WHERE user_id = u.id ORDER BY created_at DESC LIMIT 1) as last_session
        FROM users u
        INNER JOIN friends f ON (f.friend_id = u.id AND f.user_id = $userId) OR (f.user_id = u.id AND f.friend_id = $userId)
        WHERE u.id != $userId
        ORDER BY u.first_name";

$result = $conn->query($sql);

$friends = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $friends[] = [
            'id' => intval($row['id']),
            'firstName' => $row['first_name'],
            'lastName' => $row['last_name'],
            'profileImage' => $row['profile_image'],
            'lastSession' => $row['last_session'] ?? 'Aucune session'
        ];
    }
}

echo json_encode(['friends' => $friends]);

$conn->close();
?>