<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MANIA - Expérience Audio</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Alfa+Slab+One&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Alfa Slab One', serif;
        }
        .bg-gradient-mania {
            background: linear-gradient(45deg, #dc2626, #000000, #dc2626, #000000);
            background-size: 400% 400%;
            animation: gradientShift 3s ease infinite;
        }
        @keyframes gradientShift {
            0%, 100% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
        }
        .text-dynamic {
            transition: color 0.3s ease;
        }
        .bg-gradient-mania .text-dynamic {
            color: #000000;
            text-shadow: 0 0 5px rgba(255,255,255,0.5);
        }
        .swiper-slide img {
            width: 100%;
            height: 200px;
            object-fit: cover;
        }
    </style>
</head>
<body class="bg-black text-red-600 min-h-screen overflow-x-hidden">
    <audio id="backgroundAudio" preload="auto">
        <source src="slovakia.mp3" type="audio/mp3">
    </audio>

    <div id="modal" class="fixed inset-0 bg-black bg-opacity-90 z-50 flex items-center justify-center p-4">
        <div class="bg-black border-2 border-red-600 p-8 rounded-lg max-w-md text-center">
            <h2 class="text-2xl mb-4">PRÉPARE-TOI</h2>
            <p class="mb-6 text-sm">Active le son de ton téléphone et désactive la sourdine pour une expérience optimale</p>
            <button id="startBtn" class="bg-red-600 text-black px-6 py-3 rounded hover:bg-red-700 transition-colors font-bold">
                LANCER L'EXPÉRIENCE
            </button>
        </div>
    </div>

    <div id="mainContent" class="relative min-h-screen">
        <div id="titleSection" class="flex items-center justify-center min-h-screen opacity-0">
            <h1 id="maniaTitle" class="text-6xl sm:text-8xl md:text-9xl lg:text-[12rem] font-bold text-center leading-none transform scale-0 text-dynamic">
                MANIA
            </h1>
        </div>

        <div id="infoLabel" class="fixed bottom-6 left-1/2 transform -translate-x-1/2 opacity-0 z-40">
            <button id="reactBtn" class="bg-white text-black px-4 py-2 rounded-full flex items-center space-x-2 hover:bg-gray-200 transition-colors">
                <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                </svg>
                <span class="font-bold">Réagir à la menace</span>
            </button>
        </div>
    </div>

    <div id="newContent" class="relative min-h-screen transform translate-y-full opacity-0">
        <div class="container mx-auto px-4 py-16">
            <section class="mb-16">
                <h2 class="text-4xl sm:text-6xl mb-8 text-center text-dynamic">L'ALBUM</h2>
                <div class="max-w-4xl mx-auto">
                    <p class="text-lg sm:text-xl mb-6 text-center text-dynamic">
                        MANIA représente l'essence pure de la créativité débridée. Un voyage sonore qui explore les recoins les plus sombres de l'âme humaine.
                    </p>
                    <p class="text-lg sm:text-xl mb-6 text-center text-dynamic">
                        Chaque piste est une explosion d'émotions brutes, mélangée à des sonorités industrielles et des mélodies obsédantes qui ne quittent jamais l'esprit.
                    </p>
                    <p class="text-lg sm:text-xl text-center text-dynamic">
                        L'expérience MANIA n'est pas seulement un album, c'est une révélation artistique qui redéfinit les limites de la musique contemporaine.
                    </p>
                </div>
            </section>

            <section class="mb-16">
                <h3 class="text-3xl sm:text-5xl mb-8 text-center text-dynamic">GALERIE</h3>
                <div class="swiper max-w-4xl mx-auto">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <img src="https://picsum.photos/400/200?random=1" alt="MANIA 1" class="rounded-lg">
                        </div>
                        <div class="swiper-slide">
                            <img src="https://picsum.photos/400/200?random=2" alt="MANIA 2" class="rounded-lg">
                        </div>
                        <div class="swiper-slide">
                            <img src="https://picsum.photos/400/200?random=3" alt="MANIA 3" class="rounded-lg">
                        </div>
                        <div class="swiper-slide">
                            <img src="https://picsum.photos/400/200?random=4" alt="MANIA 4" class="rounded-lg">
                        </div>
                        <div class="swiper-slide">
                            <img src="https://picsum.photos/400/200?random=5" alt="MANIA 5" class="rounded-lg">
                        </div>
                    </div>
                    <div class="swiper-pagination"></div>
                    <div class="swiper-button-next text-red-600"></div>
                    <div class="swiper-button-prev text-red-600"></div>
                </div>
            </section>
        </div>

        <footer class="bg-black border-t-2 border-red-600 py-8">
            <div class="container mx-auto px-4 text-center">
                <p class="mb-4 text-xl text-dynamic">MANIA - Une expérience au-delà du réel</p>
                <button id="reloadBtn" class="bg-red-600 text-black px-6 py-3 rounded hover:bg-red-700 transition-colors font-bold">
                    RECHARGER
                </button>
            </div>
        </footer>
    </div>

    <script>
        let audio = document.getElementById('backgroundAudio');
        let hasStarted = false;

        document.getElementById('startBtn').addEventListener('click', function() {
            if (!hasStarted) {
                hasStarted = true;
                gsap.to('#modal', { opacity: 0, duration: 0.5, onComplete: () => {
                    document.getElementById('modal').style.display = 'none';
                }});
                
                setTimeout(() => {
                    audio.currentTime = 0.12;
                    audio.volume = 0;
                    audio.play();
                    gsap.to(audio, { volume: 1, duration: 2 });
                }, 100);

                setTimeout(() => {
                    document.body.classList.add('bg-gradient-mania');
                    document.body.classList.remove('bg-black');
                    
                    gsap.to('#titleSection', { opacity: 1, duration: 1 });
                    gsap.to('#maniaTitle', { 
                        scale: 1, 
                        duration: 1.2, 
                        ease: "back.out(1.7)",
                        onComplete: () => {
                            gsap.to('#infoLabel', { opacity: 1, duration: 0.5 });
                        }
                    });
                }, 14700);
            }
        });

        document.getElementById('reactBtn').addEventListener('click', function() {
            gsap.to('#mainContent', {
                y: '-100vh',
                duration: 1.5,
                ease: "power2.inOut",
                onComplete: () => {
                    gsap.to('#newContent', {
                        y: 0,
                        opacity: 1,
                        duration: 1.5,
                        ease: "power2.out"
                    });
                }
            });
        });

        document.getElementById('reloadBtn').addEventListener('click', function() {
            location.reload();
        });

        const swiper = new Swiper('.swiper', {
            loop: true,
            autoplay: {
                delay: 3000,
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            breakpoints: {
                640: {
                    slidesPerView: 1,
                },
                768: {
                    slidesPerView: 2,
                },
                1024: {
                    slidesPerView: 3,
                }
            }
        });
    </script>
</body>
</html>