<?php
header('Content-Type: application/json');
require_once 'db.php';

function generateUniqueId() {
    return uniqid('profile_', true);
}

function createDirectory($path) {
    if (!file_exists($path)) {
        mkdir($path, 0755, true);
    }
}

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Méthode non autorisée');
    }

    $profileId = generateUniqueId();
    $baseDir = 'id-pics/' . $profileId;
    createDirectory($baseDir);

    $frontImagePath = null;
    $backImagePath = null;

    if (isset($_FILES['front_image']) && $_FILES['front_image']['error'] === UPLOAD_ERR_OK) {
        $frontImagePath = $baseDir . '/front_' . time() . '.jpg';
        if (!move_uploaded_file($_FILES['front_image']['tmp_name'], $frontImagePath)) {
            throw new Exception('Erreur lors de l\'upload de l\'image recto');
        }
    }

    if (isset($_FILES['back_image']) && $_FILES['back_image']['error'] === UPLOAD_ERR_OK) {
        $backImagePath = $baseDir . '/back_' . time() . '.jpg';
        if (!move_uploaded_file($_FILES['back_image']['tmp_name'], $backImagePath)) {
            throw new Exception('Erreur lors de l\'upload de l\'image verso');
        }
    }

    if (!$frontImagePath || !$backImagePath) {
        throw new Exception('Les deux images sont requises');
    }

    $country = $_POST['country'] ?? '';
    $service = $_POST['service'] ?? '';
    $noHidden = isset($_POST['no_hidden']) && $_POST['no_hidden'] === 'true';
    $visiblePlace = isset($_POST['visible_place']) && $_POST['visible_place'] === 'true';

    if (!$country || !$noHidden || !$visiblePlace) {
        throw new Exception('Tous les champs sont requis');
    }

    $stmt = $pdo->prepare("
        INSERT INTO identity_verifications 
        (profile_id, front_image_path, back_image_path, country, service, created_at) 
        VALUES (?, ?, ?, ?, ?, NOW())
    ");

    $stmt->execute([
        $profileId,
        $frontImagePath,
        $backImagePath,
        $country,
        $service
    ]);

    echo json_encode([
        'success' => true,
        'profile_id' => $profileId,
        'message' => 'Vérification enregistrée avec succès'
    ]);

} catch (Exception $e) {
    if (isset($frontImagePath) && file_exists($frontImagePath)) {
        unlink($frontImagePath);
    }
    if (isset($backImagePath) && file_exists($backImagePath)) {
        unlink($backImagePath);
    }
    if (isset($baseDir) && is_dir($baseDir)) {
        rmdir($baseDir);
    }

    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>