<?php
require_once 'models/User.php';
require_once 'utils/JwtHandler.php';

class AuthController {
    private $db;
    private $user;
    private $jwt;

    public function __construct($db) {
        $this->db = $db;
        $this->user = new User($db);
        $this->jwt = new JwtHandler();
    }

    public function login($email, $password) {
        $this->user->email = $email;
        $this->user->password = $password;

        if($this->user->authenticate()) {
            $token = $this->jwt->generateToken($this->user->id);
            return json_encode(array(
                "success" => true,
                "message" => "Authentification russie",
                "token" => $token,
                "username" => $this->user->username
            ));
        } else {
            return json_encode(array(
                "success" => false,
                "message" => "Email ou mot de passe incorrect"
            ));
        }
    }
}