<div id="cookie-consent" class="fixed bottom-0 left-0 right-0 bg-black bg-opacity-80 backdrop-blur-md z-50 transform translate-y-full transition-transform duration-500">
    <div class="max-w-7xl mx-auto p-4 lg:p-6">
        <div class="flex flex-col lg:flex-row items-start lg:items-center justify-between gap-4">
            <div class="flex-1 text-white">
                <h3 class="text-lg font-semibold mb-2">We value your privacy</h3>
                <p class="text-sm text-gray-300">
                    We use cookies to enhance your browsing experience, serve personalized content, and analyze our traffic. By clicking "Accept all", you consent to our use of cookies. 
                    <a href="/privacy" class="text-sky-400 hover:text-sky-300 underline">Read our Cookie Policy</a>
                </p>
            </div>
            <div class="flex flex-col sm:flex-row gap-3 w-full lg:w-auto">
                <button onclick="showCookieSettings()" class="px-6 py-2.5 bg-transparent text-sky-400 border border-sky-400 rounded-full hover:bg-sky-400 hover:text-black transition-all text-sm font-medium whitespace-nowrap">
                    Cookie Settings
                </button>
                <button onclick="acceptAllCookies()" class="px-6 py-2.5 bg-white text-black rounded-full hover:bg-gray-100 transition-all text-sm font-medium whitespace-nowrap">
                    Accept All
                </button>
            </div>
        </div>
    </div>
</div>

<div id="cookie-settings" class="fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm z-50 hidden">
    <div class="fixed bottom-0 left-0 right-0 bg-black p-6 transform translate-y-full transition-transform duration-500">
        <div class="max-w-7xl mx-auto">
            <div class="flex justify-between items-center mb-6">
                <h3 class="text-xl font-semibold text-white">Cookie Settings</h3>
                <button onclick="closeCookieSettings()" class="text-gray-400 hover:text-white">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                </button>
            </div>
            
            <div class="space-y-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h4 class="text-white font-medium">Essential Cookies</h4>
                        <p class="text-sm text-gray-400">Required for the website to function properly</p>
                    </div>
                    <div class="bg-gray-700 rounded-full p-1">
                        <div class="w-12 h-6 bg-sky-400 rounded-full relative">
                            <div class="w-5 h-5 bg-white rounded-full absolute right-1 top-0.5"></div>
                        </div>
                    </div>
                </div>

                <div class="flex items-center justify-between">
                    <div>
                        <h4 class="text-white font-medium">Analytics Cookies</h4>
                        <p class="text-sm text-gray-400">Help us improve our website by collecting usage information</p>
                    </div>
                    <label class="relative inline-flex items-center cursor-pointer">
                        <input type="checkbox" class="sr-only peer" id="analytics-cookies">
                        <div class="w-12 h-6 bg-gray-700 peer-focus:outline-none rounded-full peer-checked:after:translate-x-6 peer-checked:bg-sky-400 after:content-[''] after:absolute after:top-0.5 after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all"></div>
                    </label>
                </div>

                <div class="flex items-center justify-between">
                    <div>
                        <h4 class="text-white font-medium">Marketing Cookies</h4>
                        <p class="text-sm text-gray-400">Used to deliver personalized advertisements</p>
                    </div>
                    <label class="relative inline-flex items-center cursor-pointer">
                        <input type="checkbox" class="sr-only peer" id="marketing-cookies">
                        <div class="w-12 h-6 bg-gray-700 peer-focus:outline-none rounded-full peer-checked:after:translate-x-6 peer-checked:bg-sky-400 after:content-[''] after:absolute after:top-0.5 after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all"></div>
                    </label>
                </div>
            </div>

            <div class="flex justify-end gap-3 mt-8">
                <button onclick="saveCookieSettings()" class="px-6 py-2.5 bg-white text-black rounded-full hover:bg-gray-100 transition-all text-sm font-medium">
                    Save Settings
                </button>
            </div>
        </div>
    </div>
</div>

<button id="cookie-settings-toggle" onclick="showCookieSettings()" class="fixed bottom-4 right-4 z-40 bg-black bg-opacity-80 backdrop-blur-md text-white rounded-full p-3 group hover:bg-opacity-100 transition-all duration-300 shadow-lg flex items-center gap-2 opacity-0">
    <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <path d="M12 2a10 10 0 1 0 10 10 4 4 0 0 1-5-5 4 4 0 0 1-5-5"/>
        <path d="M8.5 8.5v.01"/>
        <path d="M16 15.5v.01"/>
        <path d="M12 12v.01"/>
    </svg>
    <span class="max-w-0 overflow-hidden whitespace-nowrap group-hover:max-w-xs transition-all duration-300 ease-in-out text-sm">
        Cookie Settings
    </span>
</button>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const savedConsent = localStorage.getItem('cookieConsent');
    
    if (!savedConsent) {
        setTimeout(() => {
            document.getElementById('cookie-consent').style.transform = 'translateY(0)';
        }, 1000);
        document.getElementById('cookie-settings-toggle').style.opacity = '0';
    } else {
        document.getElementById('cookie-settings-toggle').style.opacity = '1';
        const consent = JSON.parse(savedConsent);
        document.getElementById('analytics-cookies').checked = consent.analytics;
        document.getElementById('marketing-cookies').checked = consent.marketing;
    }
});

function showCookieSettings() {
    const settings = document.getElementById('cookie-settings');
    settings.classList.remove('hidden');
    setTimeout(() => {
        settings.querySelector('.bg-black').style.transform = 'translateY(0)';
    }, 10);
}

function closeCookieSettings() {
    const settings = document.getElementById('cookie-settings');
    settings.querySelector('.bg-black').style.transform = 'translateY(100%)';
    setTimeout(() => {
        settings.classList.add('hidden');
    }, 500);
}

function acceptAllCookies() {
    const consent = {
        essential: true,
        analytics: true,
        marketing: true,
        timestamp: new Date().toISOString()
    };
    localStorage.setItem('cookieConsent', JSON.stringify(consent));
    document.getElementById('cookie-consent').style.transform = 'translateY(100%)';
    document.getElementById('cookie-settings-toggle').style.opacity = '1';
}

function saveCookieSettings() {
    const consent = {
        essential: true,
        analytics: document.getElementById('analytics-cookies').checked,
        marketing: document.getElementById('marketing-cookies').checked,
        timestamp: new Date().toISOString()
    };
    localStorage.setItem('cookieConsent', JSON.stringify(consent));
    
    closeCookieSettings();
    document.getElementById('cookie-consent').style.transform = 'translateY(100%)';
    document.getElementById('cookie-settings-toggle').style.opacity = '1';
}
</script>