<?php
$lang = $_GET['lang'] ?? 'en';
if (!in_array($lang, ['en', 'fr', 'ar', 'nl', 'de'])) {
    $lang = 'en';
}

$translations = json_decode(file_get_contents('translations.json'), true)[$lang];
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Comm Access - Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
        }
        
        header {
            background-color: rgba(0, 0, 0, 0.8);
        }
        
        .product-header {
            background-size: cover;
            background-position: center;
            min-height: 400px;
            position: relative;
        }

        .product-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(180deg, rgba(0,0,0,0.7) 0%, rgba(0,0,0,0.9) 100%);
        }

        .product-header-content {
            position: relative;
            z-index: 10;
        }

        .feature-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
        }

        .feature-card {
            background: rgba(255, 255, 255, 0.02);
            border: 1px solid rgba(255, 255, 255, 0.1);
            padding: 2rem;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .feature-card:hover {
            background: rgba(255, 255, 255, 0.05);
            border-color: rgba(255, 255, 255, 0.2);
            transform: translateY(-5px);
        }

        .feature-icon {
            font-size: 2.5rem;
            margin-bottom: 1.5rem;
            color: #FFFFFF;
        }

        .section-title {
            font-size: 2.5rem;
            font-weight: 300;
            margin-bottom: 3rem;
        }

        .cta-box {
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            padding: 3rem;
            border-radius: 8px;
            text-align: center;
        }

        .btn-primary {
            display: inline-block;
            padding: 1rem 2rem;
            background: #FFFFFF;
            color: #000000;
            border-radius: 4px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            background: #E0E0E0;
            transform: translateY(-2px);
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 2rem;
            text-align: center;
        }

        .stat-number {
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .stat-label {
            color: #CCCCCC;
            font-size: 1.1rem;
        }
    </style>
</head>
<body>
    <?php include 'src/header.php'; ?>

    <div class="product-header" style="background-image: url('banner_color.png');">
        <div class="container mx-auto px-4 py-24 product-header-content">
            <h1 class="text-5xl mt-12 md:text-6xl font-light mb-6">Comm Access</h1>
            <p class="text-xl md:text-2xl text-gray-300 max-w-3xl">
                Real-time analysis of purchasing and consumption trends at scale
            </p>
        </div>
    </div>

    <div class="container mx-auto px-4 py-16">
        <div class="max-w-4xl mx-auto mb-16">
            <h2 class="text-3xl font-light mb-6">Transform data into strategic insights</h2>
            <p class="text-lg text-gray-400 leading-relaxed">
                Comm Access is a revolutionary online software that enables businesses to examine and analyze 
                purchasing trends at scale. Understand not only your own data, but also 
                your neighborhood's patterns to make informed decisions.
            </p>
        </div>

        <div class="mb-20">
            <h2 class="section-title text-center">Key Features</h2>
            <div class="feature-grid">
                <div class="feature-card">
                    <i class="fas fa-chart-line feature-icon"></i>
                    <h3 class="text-2xl font-light mb-3">Local trends analysis</h3>
                    <p class="text-gray-400">
                        Access aggregated data from your neighborhood to identify market opportunities 
                        and adapt your offering in real time.
                    </p>
                </div>

                <div class="feature-card">
                    <i class="fas fa-database feature-icon"></i>
                    <h3 class="text-2xl font-light mb-3">Centralized data network</h3>
                    <p class="text-gray-400">
                        A unified system that collects and structures consumption information for 
                        powerful comparative analysis.
                    </p>
                </div>

                <div class="feature-card">
                    <i class="fas fa-store feature-icon"></i>
                    <h3 class="text-2xl font-light mb-3">Store statistics</h3>
                    <p class="text-gray-400">
                        Examine your own performance with detailed dashboards and customizable 
                        key performance indicators.
                    </p>
                </div>

                <div class="feature-card">
                    <i class="fas fa-map-marked-alt feature-icon"></i>
                    <h3 class="text-2xl font-light mb-3">Territorial vision</h3>
                    <p class="text-gray-400">
                        Compare your results with those of the neighborhood and identify areas for improvement 
                        or strategic expansion.
                    </p>
                </div>
            </div>
        </div>

        <div class="mb-20">
            <h2 class="section-title text-center">Why Comm Access</h2>
            <div class="stats-grid">
                <div>
                    <div class="stat-number">100%</div>
                    <div class="stat-label">Real time</div>
                </div>
                <div>
                    <div class="stat-number">360</div>
                    <div class="stat-label">Complete vision</div>
                </div>
                <div>
                    <div class="stat-number">24/7</div>
                    <div class="stat-label">Availability</div>
                </div>
            </div>
        </div>

        <div class="max-w-4xl mx-auto">
            <div class="cta-box">
                <h2 class="text-3xl font-light mb-4">Ready to get started?</h2>
                <p class="text-gray-400 mb-8 text-lg">
                    Join Comm Access and benefit from a strategic vision of your market.
                </p>
                <a href="https://imators.systems/comm-access" class="btn-primary">More information</a>
            </div>
        </div>
    </div>

    <footer class="bg-black text-white">
        <div class="max-w-6xl mx-auto px-4 py-6 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-4">
                <h5 class="text-xs uppercase font-medium mb-4"><?php echo $translations['need_help']; ?></h5>
                <a href="/support" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    <?php echo $translations['support']; ?>
                </a>
                <a href="/contact-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    <?php echo $translations['contact_us']; ?>
                </a>
            </div>
            <div class="w-full md:w-1/3 p-4">
                <h5 class="text-xs uppercase font-medium mb-4"><?php echo $translations['discover']; ?></h5>
                <a href="/privacy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    <?php echo $translations['privacy_policy']; ?>
                </a>
                <a href="/terms-of-use" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    <?php echo $translations['terms_of_use']; ?>
                </a>
                <a href="/refund-policy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    <?php echo $translations['refund_policy']; ?>
                </a>
                <a href="/legal-notice" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    <?php echo $translations['legal_notice']; ?>
                </a>
                <a href="/" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    <?php echo $translations['home']; ?>
                </a>
                <a href="/about-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    <?php echo $translations['about_us']; ?>
                </a>
            </div>
            <div class="w-full md:w-1/3 p-4">

                <p class="text-sm">
                    <?php echo $translations['all_images']; ?>
                </p>
            </div>
        </div>

        <div class="text-center py-3 border-t border-gray-800">
            <p class="text-sm">
                &copy; <?php echo date("Y"); ?> <?php echo $translations['copyright']; ?>
            </p>
            <p class="text-xs mt-2">
                <a href="https://aktascorp.com"><?php echo $translations['imators_aktascorp']; ?></a>
            </p>
            <p class="text-xs">
                <?php echo $translations['registered_llc']; ?>
            </p>
        </div>
    </footer>

    <script>
        document.getElementById('mobile-menu-button')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.remove('hidden');
        });
        
        document.getElementById('mobile-menu-close')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.add('hidden');
        });

        gsap.registerPlugin(ScrollTrigger);

        gsap.utils.toArray('.feature-card').forEach((card, index) => {
            gsap.from(card, {
                opacity: 0,
                y: 50,
                duration: 0.6,
                delay: index * 0.1,
                scrollTrigger: {
                    trigger: card,
                    start: 'top 85%',
                    toggleActions: 'play none none reverse'
                }
            });
        });

        gsap.from('.stats-grid > div', {
            opacity: 0,
            scale: 0.8,
            duration: 0.6,
            stagger: 0.15,
            scrollTrigger: {
                trigger: '.stats-grid',
                start: 'top 80%',
                toggleActions: 'play none none reverse'
            }
        });

        gsap.from('.cta-box', {
            opacity: 0,
            y: 40,
            duration: 0.8,
            scrollTrigger: {
                trigger: '.cta-box',
                start: 'top 85%',
                toggleActions: 'play none none reverse'
            }
        });
    </script>
</body>
</html>