/*
 * Decompiled with CFR 0.152.
 */
package com.imators.discordautobot;

import com.imators.discordautobot.MinecraftAPI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DiscordAutoBot
extends JavaPlugin {
    private Process nodeProcess;
    private Path botDir;
    private MinecraftAPI api;

    public void onEnable() {
        this.botDir = this.getDataFolder().toPath().resolve("bot");
        try {
            this.api = new MinecraftAPI();
            this.api.start(8080);
            this.getLogger().info("API Minecraft d\u00e9marr\u00e9e sur le port 8080");
        }
        catch (Exception e) {
            this.getLogger().severe("Erreur d\u00e9marrage API: " + e.getMessage());
        }
        new BukkitRunnable(){

            public void run() {
                DiscordAutoBot.this.setupBot();
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    public void onDisable() {
        if (this.nodeProcess != null && this.nodeProcess.isAlive()) {
            this.nodeProcess.destroyForcibly();
            this.getLogger().info("Bot Discord arr\u00eat\u00e9");
        }
        if (this.api != null) {
            this.api.stop();
            this.getLogger().info("API Minecraft arr\u00eat\u00e9e");
        }
    }

    private void setupBot() {
        try {
            Files.createDirectories(this.botDir, new FileAttribute[0]);
            this.copyExistingBot();
            this.addMinecraftIntegration();
            if (this.tryDownloadNode()) {
                this.createNodeScript();
            } else {
                this.createFallbackScript();
            }
            this.startBot();
        }
        catch (Exception e) {
            this.getLogger().severe("Erreur setup bot: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void copyExistingBot() throws Exception {
        final Path sourceBotDir = Paths.get("peerkinton-bot", new String[0]);
        if (!Files.exists(sourceBotDir, new LinkOption[0])) {
            this.getLogger().warning("Dossier peerkinton-bot introuvable, cr\u00e9ation d'un bot basique");
            this.createBasicBot();
            return;
        }
        if (Files.exists(this.botDir, new LinkOption[0]) && Files.list(this.botDir).findAny().isPresent()) {
            this.getLogger().info("Bot d\u00e9j\u00e0 install\u00e9, pas de copie - Configuration pr\u00e9serv\u00e9e");
            return;
        }
        this.getLogger().info("Premi\u00e8re installation - Copie du bot depuis peerkinton-bot...");
        Files.walkFileTree(sourceBotDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){
            final /* synthetic */ DiscordAutoBot this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String dirName = dir.getFileName().toString();
                if (dirName.startsWith(".")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path targetDir = this.this$0.botDir.resolve(sourceBotDir.relativize(dir));
                Files.createDirectories(targetDir, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String fileName = file.getFileName().toString();
                if (fileName.startsWith(".")) {
                    return FileVisitResult.CONTINUE;
                }
                Path targetFile = this.this$0.botDir.resolve(sourceBotDir.relativize(file));
                Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
        this.getLogger().info("Bot copi\u00e9 avec succ\u00e8s");
    }

    private void addMinecraftIntegration() throws Exception {
        Path mainBotFile = this.findMainBotFile();
        if (mainBotFile == null) {
            this.getLogger().warning("Fichier principal introuvable");
            return;
        }
        Object botContent = Files.readString(mainBotFile);
        if (((String)botContent).contains("!status") || ((String)botContent).contains("axios")) {
            this.getLogger().info("Commandes Minecraft d\u00e9j\u00e0 int\u00e9gr\u00e9es");
            return;
        }
        this.getLogger().info("Ajout des commandes Minecraft");
        String commands = "\ntry {\n    const axios = require('axios');\n\n    client.on('messageCreate', message => {\n        if (message.author.bot) return;\n\n        if (message.content.startsWith('!status')) {\n            axios.get('http://localhost:8080/players')\n                .then(response => {\n                    const { EmbedBuilder } = require('discord.js');\n                    const embed = new EmbedBuilder()\n                        .setTitle('\ud83d\udcca Status Serveur Imators')\n                        .addFields(\n                            { name: 'Joueurs en ligne', value: response.data.online.toString(), inline: true },\n                            { name: 'Joueurs max', value: response.data.max.toString(), inline: true }\n                        )\n                        .setColor(0x0099ff);\n\n                    message.reply({ embeds: [embed] });\n                })\n                .catch(() => {\n                    message.reply('\u274c Serveur hors ligne');\n                });\n        }\n\n        if (message.content.startsWith('!players')) {\n            axios.get('http://localhost:8080/players/list')\n                .then(response => {\n                    const { EmbedBuilder } = require('discord.js');\n                    const players = response.data.players.join('\\n') || 'Aucun joueur';\n\n                    const embed = new EmbedBuilder()\n                        .setTitle('\ud83d\udc65 Joueurs connect\u00e9s')\n                        .setDescription(players)\n                        .setColor(0x00ff00);\n\n                    message.reply({ embeds: [embed] });\n                })\n                .catch(() => {\n                    message.reply('\u274c Impossible de r\u00e9cup\u00e9rer la liste');\n                });\n        }\n    });\n} catch (error) {\n    console.log('Axios non disponible, commandes Minecraft d\u00e9sactiv\u00e9es');\n}\n";
        botContent = (String)botContent + commands;
        Files.writeString(mainBotFile, (CharSequence)botContent, new OpenOption[0]);
        this.ensureAxios();
    }

    private Path findMainBotFile() throws Exception {
        String[] names;
        String main;
        Path mainFile;
        String content;
        Path packageJson = this.botDir.resolve("package.json");
        if (Files.exists(packageJson, new LinkOption[0]) && (content = Files.readString(packageJson)).contains("\"main\"") && Files.exists(mainFile = this.botDir.resolve(main = content.split("\"main\":\\s*\"")[1].split("\"")[0]), new LinkOption[0])) {
            return mainFile;
        }
        for (String name : names = new String[]{"index.js", "bot.js", "app.js", "main.js"}) {
            Path file = this.botDir.resolve(name);
            if (!Files.exists(file, new LinkOption[0])) continue;
            return file;
        }
        return null;
    }

    private void ensureAxios() throws Exception {
        Path packageJson = this.botDir.resolve("package.json");
        if (!Files.exists(packageJson, new LinkOption[0])) {
            return;
        }
        String content = Files.readString(packageJson);
        if (!content.contains("axios")) {
            content = content.replaceFirst("\"dependencies\":\\s*\\{", "\"dependencies\": {\n    \"axios\": \"^1.5.0\",");
            Files.writeString(packageJson, (CharSequence)content, new OpenOption[0]);
            this.getLogger().info("Axios ajout\u00e9 au package.json");
        }
    }

    private void createBasicBot() throws Exception {
        String packageJson = "{\n    \"name\": \"imators-bot\",\n    \"version\": \"1.0.0\",\n    \"main\": \"index.js\",\n    \"dependencies\": {\n        \"discord.js\": \"^14.13.0\",\n        \"axios\": \"^1.5.0\"\n    }\n}\n";
        String botScript = "const { Client, GatewayIntentBits, EmbedBuilder } = require('discord.js');\n\nconst client = new Client({\n    intents: [\n        GatewayIntentBits.Guilds,\n        GatewayIntentBits.GuildMessages,\n        GatewayIntentBits.MessageContent\n    ]\n});\n\nclient.once('ready', () => {\n    console.log('Bot Imators connect\u00e9!');\n});\n\ntry {\n    const axios = require('axios');\n\n    client.on('messageCreate', message => {\n        if (message.author.bot) return;\n\n        if (message.content.startsWith('!status')) {\n            axios.get('http://localhost:8080/players')\n                .then(response => {\n                    const embed = new EmbedBuilder()\n                        .setTitle('\ud83d\udcca Status Serveur')\n                        .addFields(\n                            { name: 'En ligne', value: response.data.online.toString(), inline: true },\n                            { name: 'Max', value: response.data.max.toString(), inline: true }\n                        )\n                        .setColor(0x0099ff);\n\n                    message.reply({ embeds: [embed] });\n                })\n                .catch(() => {\n                    message.reply('\u274c Serveur hors ligne');\n                });\n        }\n    });\n} catch (error) {\n    console.log('Axios non disponible');\n}\n\nclient.login('TON_TOKEN_ICI');\n";
        Files.writeString(this.botDir.resolve("package.json"), (CharSequence)packageJson, new OpenOption[0]);
        Files.writeString(this.botDir.resolve("index.js"), (CharSequence)botScript, new OpenOption[0]);
        this.getLogger().info("Bot basique cr\u00e9\u00e9");
    }

    private boolean tryDownloadNode() {
        try {
            this.getLogger().info("T\u00e9l\u00e9chargement Node.js...");
            Path nodeDir = this.botDir.resolve("node");
            Files.createDirectories(nodeDir, new FileAttribute[0]);
            URL nodeUrl = new URL("https://nodejs.org/dist/v18.17.0/node-v18.17.0-linux-x64.tar.gz");
            Path archive = nodeDir.resolve("node.tar.gz");
            try (InputStream in = nodeUrl.openStream();){
                Files.copy(in, archive, StandardCopyOption.REPLACE_EXISTING);
            }
            ProcessBuilder pb = new ProcessBuilder("tar", "-xzf", archive.toString(), "-C", nodeDir.toString(), "--strip-components=1");
            Process process = pb.start();
            int code = process.waitFor();
            Files.deleteIfExists(archive);
            if (code == 0 && Files.exists(nodeDir.resolve("bin/node"), new LinkOption[0])) {
                this.getLogger().info("Node.js install\u00e9");
                return true;
            }
        }
        catch (Exception e) {
            this.getLogger().warning("\u00c9chec t\u00e9l\u00e9chargement Node.js: " + e.getMessage());
        }
        return false;
    }

    private void createNodeScript() throws Exception {
        String script = "#!/bin/bash\ncd \"$(dirname \"$0\")\"\n\nif [ -f \"./node/bin/node\" ]; then\n    ./node/bin/node index.js\nelif command -v node >/dev/null 2>&1; then\n    node index.js\nelse\n    echo \"Node.js introuvable\"\n    exit 1\nfi\n";
        Path scriptPath = this.botDir.resolve("start.sh");
        Files.writeString(scriptPath, (CharSequence)script, new OpenOption[0]);
        try {
            ProcessBuilder pb = new ProcessBuilder("chmod", "+x", scriptPath.toString());
            pb.start().waitFor();
        }
        catch (Exception e) {
            this.getLogger().warning("Chmod \u00e9chou\u00e9: " + e.getMessage());
        }
    }

    private void createFallbackScript() throws Exception {
        this.getLogger().warning("Node.js non disponible, cr\u00e9ation du fallback");
        String script = "#!/bin/bash\necho \"Node.js non trouv\u00e9 sur ce serveur Pterodactyl\"\necho \"L'API Minecraft fonctionne sur le port 8080\"\necho \"Pour installer Node.js, contactez l'administrateur\"\necho \"Test API: curl http://localhost:8080/players\"\n\nsleep 10\n";
        Path scriptPath = this.botDir.resolve("start.sh");
        Files.writeString(scriptPath, (CharSequence)script, new OpenOption[0]);
        try {
            ProcessBuilder pb = new ProcessBuilder("chmod", "+x", scriptPath.toString());
            pb.start().waitFor();
        }
        catch (Exception e) {
            this.getLogger().warning("Chmod \u00e9chou\u00e9: " + e.getMessage());
        }
    }

    private void startBot() throws Exception {
        this.getLogger().info("D\u00e9marrage du bot...");
        ProcessBuilder pb = new ProcessBuilder("/bin/bash", "start.sh");
        pb.directory(this.botDir.toFile());
        pb.redirectErrorStream(true);
        this.nodeProcess = pb.start();
        new BukkitRunnable(){

            public void run() {
                block8: {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(DiscordAutoBot.this.nodeProcess.getInputStream()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            DiscordAutoBot.this.getLogger().info("[Bot] " + line);
                        }
                    }
                    catch (Exception e) {
                        if (!DiscordAutoBot.this.nodeProcess.isAlive()) break block8;
                        DiscordAutoBot.this.getLogger().warning("Erreur logs: " + e.getMessage());
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)this);
        this.getLogger().info("Bot d\u00e9marr\u00e9");
    }
}

