<?php
if ($_POST['action'] == 'virement' && isset($_POST['id_destinataire']) && isset($_POST['montant']) && isset($_POST['motif'])) {
    $id_destinataire = trim($_POST['id_destinataire']);
    $montant = floatval($_POST['montant']);
    $motif = trim($_POST['motif']);
    
    if ($montant <= 0) {
        $virement_message = "Le montant doit être supérieur à 0";
        $virement_success = false;
    } elseif ($montant > $solde) {
        $virement_message = "Solde insuffisant pour effectuer ce virement";
        $virement_success = false;
    } else {
        $sql = "SELECT u.id, i.nom, i.prenom FROM users u
                 LEFT JOIN identites i ON u.id = i.user_id
                 WHERE i.code_transfert = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $id_destinataire);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if($result->num_rows > 0) {
            $destinataire = $result->fetch_assoc();
            $destinataire_id = $destinataire['id'];
            $destinataire_nom = $destinataire['nom'] . ' ' . $destinataire['prenom'];
            $is_entreprise = false;
            
            if($destinataire_id == $user_id) {
                $virement_message = "Vous ne pouvez pas effectuer un virement à vous-même";
                $virement_success = false;
            } else {
                $conn->begin_transaction();
                
                try {
                    $sql = "UPDATE comptes_bancaires SET solde = solde - ? WHERE user_id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("di", $montant, $user_id);
                    $stmt->execute();
                    
                    $sql = "UPDATE comptes_bancaires SET solde = solde + ? WHERE user_id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("di", $montant, $destinataire_id);
                    $stmt->execute();
                    
                    $emetteur_nom = $identite['nom'] . ' ' . $identite['prenom'];
                    
                    $sql = "INSERT INTO transactions (user_id, destinataire_id, montant, motif, emetteur_nom, destinataire_nom)
                             VALUES (?, ?, ?, ?, ?, ?)";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("iidsss", $user_id, $destinataire_id, $montant, $motif, $emetteur_nom, $destinataire_nom);
                    $stmt->execute();
                    
                    $conn->commit();
                    
                    $solde -= $montant;
                    
                    $virement_message = "Virement de " . number_format($montant, 2, ',', ' ') . " € effectué avec succès vers " . $destinataire_nom;
                    $virement_success = true;
                } catch (Exception $e) {
                    $conn->rollback();
                    $virement_message = "Une erreur est survenue lors du virement";
                    $virement_success = false;
                }
            }
        } else {
            $sql = "SELECT e.id, e.nom, cbe.id as compte_id FROM entreprises e
                    LEFT JOIN comptes_bancaires_entreprises cbe ON e.id = cbe.entreprise_id
                    WHERE e.id_bancaire_entreprise = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("s", $id_destinataire);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if($result->num_rows > 0) {
                $entreprise = $result->fetch_assoc();
                $destinataire_id = $entreprise['id'];
                $destinataire_nom = $entreprise['nom'];
                $compte_entreprise_id = $entreprise['compte_id'];
                $is_entreprise = true;
                
                $conn->begin_transaction();
                
                try {
                    $sql = "UPDATE comptes_bancaires SET solde = solde - ? WHERE user_id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("di", $montant, $user_id);
                    $stmt->execute();
                    
                    $sql = "UPDATE comptes_bancaires_entreprises SET solde = solde + ? WHERE entreprise_id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("di", $montant, $destinataire_id);
                    $stmt->execute();
                    
                    $emetteur_nom = $identite['nom'] . ' ' . $identite['prenom'];
                    
                    $sql = "INSERT INTO transactions (user_id, destinataire_id, montant, motif, emetteur_nom, destinataire_nom)
                             VALUES (?, ?, ?, ?, ?, ?)";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("iidsss", $user_id, $destinataire_id, $montant, $motif, $emetteur_nom, $destinataire_nom);
                    $stmt->execute();
                    
                    $conn->commit();
                    
                    $solde -= $montant;
                    
                    $virement_message = "Virement de " . number_format($montant, 2, ',', ' ') . " F& effectué avec succès vers " . $destinataire_nom;
                    $virement_success = true;
                } catch (Exception $e) {
                    $conn->rollback();
                    $virement_message = "Une erreur est survenue lors du virement";
                    $virement_success = false;
                }
            } else {
                $virement_message = "Destinataire introuvable. Vérifiez l'ID de transfert";
                $virement_success = false;
            }
        }
    }
}
?>