<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@forchange</title>
    <meta name="imators-verification" content="verified">
    <link rel="icon" type="image/x-icon" href="profile_picture.png">
    <link href="https://fonts.googleapis.com/css2?family=Caveat:wght@400;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Pacifico&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Bowlby+One&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Anton&display=swap" rel="stylesheet">

    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/ScrollTrigger.min.js"></script>
    <script>
    window.location.href = "https://izhak.me";
    </script>

    <style>
        .hero-glow {
            position: absolute;
            width: 80vw;
            height: 80vw;
            background: radial-gradient(circle, rgba(74, 222, 128, 0.15) 0%, rgba(0, 0, 0, 0) 70%);
            z-index: 0;
        }

        .gradient-text {
            background: linear-gradient(90deg, #fff, #4ade80);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .gradient-border {
            background: linear-gradient(90deg, rgba(74, 222, 128, 0.1), transparent);
            border: 1px solid rgba(74, 222, 128, 0.2);
        }

        .marquee-wrap {
            overflow: hidden;
            width: 100%;
            white-space: nowrap;
        }

        .marquee-content {
            display: inline-block;
            animation: marquee 20s linear infinite;
            white-space: nowrap;
        }

        @keyframes marquee {
            0% { transform: translateX(0); }
            100% { transform: translateX(-50%); }
        }
    </style>
</head>
<body class="bg-black text-white">
    <div class="relative min-h-screen overflow-hidden">
        <div class="hero-glow fixed left-1/2 top-1/2 -translate-x-1/2 -translate-y-1/2 opacity-0"></div>

        <div class="marquee-wrap py-4 bg-black/50 backdrop-blur-sm fixed w-full z-50 opacity-0">
            <div class="marquee-content">
                <span class="text-2xl md:text-4xl font-light tracking-wider inline-block">
                    @FORCHANGE THE WORLD TONIGHT &nbsp;&nbsp;&nbsp; @FORCHANGE THE WORLD TONIGHT &nbsp;&nbsp;&nbsp; @FORCHANGE THE WORLD TONIGHT &nbsp;&nbsp;&nbsp; @FORCHANGE THE WORLD TONIGHT &nbsp;&nbsp;&nbsp; @FORCHANGE THE WORLD TONIGHT &nbsp;&nbsp;&nbsp; @FORCHANGE THE WORLD TONIGHT &nbsp;&nbsp;&nbsp;
                </span>
            </div>
        </div>

        <main class="relative z-10">
            <section class="min-h-[100dvh] flex items-center justify-center px-4 py-20">
                <div class="container mx-auto max-w-3xl text-center">
                    <div class="space-y-8">
                        <h1 class="text-5xl md:text-6xl hover:italic font-light gradient-text leading-none opacity-0">@forchange</h1>
                        
                        <div class="gradient-border rounded-xl inline-block px-6 py-3 opacity-0">
                            <div class="flex items-center gap-3 justify-center">
                                <span>+</span>
                                <span id="counter" class="text-3xl gradient-text font-light">0</span>
                                <span class="text-sm text-white/60">satisfied customers</span>
                            </div>
                        </div>
                        
                        <p class="text-xl md:text-2xl leading-relaxed text-white/80 opacity-0">
                            Web developer since 2 years and CEO of the Imators company. 
                            I have professional skills and a minimalist rendering for my requests.
                        </p>

                        <div class="flex items-center gap-4 justify-center opacity-0">
                            <div class="flex gap-4 items-center gradient-border rounded-full px-6 py-3">
                                <span class="block w-2 h-2 bg-green-400 rounded-full animate-pulse"></span>
                                <span class="text-white/80">Currently in my home</span>
                            </div>
                        </div>
                        


                        <div class="flex flex-wrap gap-4 justify-center opacity-0">
                            <a href="mailto:izhak@imators.com" class="gradient-border rounded-full px-6 py-3 flex items-center gap-3 hover:bg-white/5 transition-colors">
                                <svg class="w-5 h-5 text-green-400" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                </svg>
                                <span>Contact</span>
                            </a>
                            <a href="https://discord.com/users/866001325657292801" class="gradient-border rounded-full px-6 py-3 flex items-center gap-3 hover:bg-white/5 transition-colors">
                                <svg class="w-5 h-5 text-green-400" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M20.317 4.492c-1.53-.69-3.17-1.2-4.885-1.49a.075.075 0 0 0-.079.036c-.21.369-.444.85-.608 1.23a18.566 18.566 0 0 0-5.487 0 12.36 12.36 0 0 0-.617-1.23A.077.077 0 0 0 8.562 3c-1.714.29-3.354.8-4.885 1.491a.07.07 0 0 0-.032.027C.533 9.093-.32 13.555.099 17.961a.08.08 0 0 0 .031.055 20.03 20.03 0 0 0 5.993 2.98a.078.078 0 0 0 .084-.026 13.83 13.83 0 0 0 1.226-1.963.074.074 0 0 0-.041-.104 13.175 13.175 0 0 1-1.872-.878.075.075 0 0 1-.008-.125c.126-.093.252-.19.372-.287a.075.075 0 0 1 .078-.01c3.927 1.764 8.18 1.764 12.061 0a.075.075 0 0 1 .079.009c.12.098.245.195.372.288a.075.075 0 0 1-.006.125c-.598.344-1.22.635-1.873.877a.075.075 0 0 0-.041.105c.36.687.772 1.341 1.225 1.962a.077.077 0 0 0 .084.028 19.963 19.963 0 0 0 6.002-2.981.076.076 0 0 0 .032-.054c.5-5.094-.838-9.52-3.549-13.442a.06.06 0 0 0-.031-.028zM8.02 15.278c-1.182 0-2.157-1.069-2.157-2.38 0-1.312.956-2.38 2.157-2.38 1.21 0 2.176 1.077 2.157 2.38 0 1.312-.956 2.38-2.157 2.38zm7.975 0c-1.183 0-2.157-1.069-2.157-2.38 0-1.312.955-2.38 2.157-2.38 1.21 0 2.176 1.077 2.157 2.38 0 1.312-.946 2.38-2.157 2.38z"/>
                                </svg>
                                <span>Discord</span>
                            </a>
                        </div>
                    </div>
                </div>
            </section>

<script>
gsap.registerPlugin(ScrollTrigger);

// Animation du hero glow
gsap.to(".hero-glow", {
    opacity: 0.5,
    duration: 2,
    ease: "power2.out"
});

// Animation de la marquee
gsap.to(".marquee-wrap", {
    opacity: 1,
    duration: 1,
    delay: 0.2
});

// Animations de la première section
gsap.to("h1", {
    opacity: 1,
    duration: 1,
    y: 0
});

gsap.utils.toArray(".gradient-border, p, .flex.items-center, .flex.flex-wrap").forEach((el, i) => {
    gsap.to(el, {
        opacity: 1,
        duration: 0.8,
        delay: 0.3 * (i + 1),
        y: 0
    });
});

// Animation du compteur
gsap.to("#counter", {
    duration: 2,
    innerText: 567,
    snap: {
        innerText: 1
    },
    ease: "power1.out"
});
</script>

            <section class="py-32 px-4 md:px-8">
                <div class="max-w-6xl mx-auto">
                    <h2 class="skills-h2 text-3xl tracking-[.5em] uppercase mb-16 text-center gradient-text opacity-0 transform translate-y-10">Skills</h2>
                    <p class="skills-p text-white/60 text-sm text-center mb-12 opacity-0 transform translate-y-10">
                        *These percentages reflect a comparative assessment based on validated performance tests.
                    </p>
                    <div class="space-y-12">
                        <!-- HTML -->
                        <div class="skill-bar">
                            <div class="flex justify-between mb-2">
                                <span class="text-lg">HTML</span>
                                <span class="text-green-400">100%</span>
                            </div>
                            <div class="h-2 bg-white/10 rounded-full overflow-hidden">
                                <div class="h-full bg-gradient-to-r from-green-400 to-green-300 rounded-full w-0"></div>
                            </div>
                            <p class="text-white/70 text-sm mt-2">I can create a complete website!</p>
                        </div>

                        <!-- CSS -->
                        <div class="skill-bar">
                            <div class="flex justify-between mb-2">
                                <span class="text-lg">CSS</span>
                                <span class="text-green-400">100%</span>
                            </div>
                            <div class="h-2 bg-white/10 rounded-full overflow-hidden">
                                <div class="h-full bg-gradient-to-r from-green-400 to-green-300 rounded-full w-0"></div>
                            </div>
                            <p class="text-white/70 text-sm mt-2">I can design responsive and stylish layouts.</p>
                        </div>

                        <!-- JavaScript -->
                        <div class="skill-bar">
                            <div class="flex justify-between mb-2">
                                <span class="text-lg">JavaScript</span>
                                <span class="text-green-400">100%</span>
                            </div>
                            <div class="h-2 bg-white/10 rounded-full overflow-hidden">
                                <div class="h-full bg-gradient-to-r from-green-400 to-green-300 rounded-full w-0"></div>
                            </div>
                            <p class="text-white/70 text-sm mt-2">I can create dynamic and interactive web features.</p>
                        </div>

                        <!-- Java -->
                        <div class="skill-bar">
                            <div class="flex justify-between mb-2">
                                <span class="text-lg">Java</span>
                                <span class="text-green-400">85%</span>
                            </div>
                            <div class="h-2 bg-white/10 rounded-full overflow-hidden">
                                <div class="h-full bg-gradient-to-r from-green-400 to-green-300 rounded-full w-0"></div>
                            </div>
                            <p class="text-white/70 text-sm mt-2">I can create complete Plugins and Mods</p>
                        </div>

                        <!-- React -->
                        <div class="skill-bar">
                            <div class="flex justify-between mb-2">
                                <span class="text-lg">React</span>
                                <span class="text-green-400">92%</span>
                            </div>
                            <div class="h-2 bg-white/10 rounded-full overflow-hidden">
                                <div class="h-full bg-gradient-to-r from-green-400 to-green-300 rounded-full w-0"></div>
                            </div>
                            <p class="text-white/70 text-sm mt-2">I can build modern and efficient user interfaces.</p>
                        </div>

                        <!-- PHP -->
                        <div class="skill-bar">
                            <div class="flex justify-between mb-2">
                                <span class="text-lg">PHP</span>
                                <span class="text-green-400">76%</span>
                            </div>
                            <div class="h-2 bg-white/10 rounded-full overflow-hidden">
                                <div class="h-full bg-gradient-to-r from-green-400 to-green-300 rounded-full w-0"></div>
                            </div>
                            <p class="text-white/70 text-sm mt-2">I can create dynamic server-side applications.</p>
                        </div>
                    </div>
                </div>

<script>
// Animation des skills
gsap.to(".skills-h2", {
    scrollTrigger: {
        trigger: ".skills h2",
        start: "top 80%",
    },
    opacity: 1,
    y: 0,
    duration: 1
});

gsap.to(".skills-p", {
    scrollTrigger: {
        trigger: ".skills p",
        start: "top 80%",
    },
    opacity: 1,
    y: 0,
    duration: 1,
    delay: 0.2
});

// Animation des barres de compétences
gsap.utils.toArray(".skill-bar").forEach((bar, i) => {
    const progressBar = bar.querySelector(".h-full");
    const percentage = bar.querySelector(".text-green-400").textContent;
    
    gsap.from(bar, {
        scrollTrigger: {
            trigger: bar,
            start: "top 85%",
        },
        opacity: 0,
        x: -50,
        duration: 0.8,
        delay: i * 0.2
    });

    gsap.to(progressBar, {
        scrollTrigger: {
            trigger: bar,
            start: "top 85%",
        },
        width: percentage,
        duration: 1.5,
        delay: i * 0.2,
        ease: "power3.out"
    });
});
</script>
</section>

<section class="py-32 px-4 md:px-8 bg-black/50 backdrop-blur-sm">
    <div class="max-w-6xl mx-auto">
        <h2 class="projects-h2 text-3xl tracking-[.5em] uppercase mb-16 text-center gradient-text opacity-0 transform translate-y-10">Projects</h2>
        <div class="space-y-12">
            <!-- Imators -->
            <div class="project-card p-8 rounded-2xl bg-black border border-white/10 hover:border-green-400/30 transition-all duration-500 opacity-0 transform translate-y-10">
                <div class="flex flex-col md:flex-row items-start md:items-center justify-between gap-6">
                    <div class="space-y-4">
                        <h3 class="text-2xl mb-4 gradient-text">Imators</h3>
                        <p class="text-white/80 text-lg leading-relaxed">
                            This is my company. It operates in the technology sector and aims to develop technology that integrates into daily life without dehumanising or harming it
                        </p>
                        <div class="flex gap-3 pt-2">
                            <span class="px-3 py-1 rounded-full bg-white/5 text-white/60 text-xs">Web Development</span>
                            <span class="px-3 py-1 rounded-full bg-white/5 text-white/60 text-xs">World</span>
                            <span class="px-3 py-1 rounded-full bg-white/5 text-white/60 text-xs">Innovation</span>
                        </div>
                    </div>
                    <a href="https://imators.com" class="group flex items-center gap-2 text-green-400 hover:text-green-300 transition-colors">
                        <span>Discover</span>
                        <svg class="w-4 h-4 transform group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </a>
                </div>
            </div>

            <!-- Conquer Five -->
            <div class="project-card p-8 rounded-2xl bg-yellow-400 hover:bg-yellow-300 transition-all duration-500 opacity-0 transform translate-y-10">
                <div class="flex flex-col md:flex-row items-start md:items-center justify-between gap-6">
                    <div class="space-y-4">
                        <h3 class="text-black text-2xl mb-4">Conquer Five</h3>
                        <p class="text-black text-lg leading-relaxed">
                            The site of my old FiveM server. I was inspired by his story and a theme similar to the Tebex website, even if it doesn't look like it 😅
                        </p>
                        <div class="flex gap-3 pt-2">
                            <span class="px-3 py-1 rounded-full bg-black/5 text-black/60 text-xs">Gaming</span>
                            <span class="px-3 py-1 rounded-full bg-black/5 text-black/60 text-xs">Community</span>
                            <span class="px-3 py-1 rounded-full bg-black/5 text-black/60 text-xs">FiveM</span>
                        </div>
                    </div>
                    <a href="https://conquerfive.net" class="group flex items-center gap-2 text-black/70 hover:text-black transition-colors">
                        <span>Discover</span>
                        <svg class="w-4 h-4 transform group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </a>
                </div>
            </div>

            <!-- Gemance -->
            <div class="project-card p-8 rounded-2xl bg-white text-black transition-all duration-500 opacity-0 transform translate-y-10">
                <div class="flex flex-col md:flex-row items-start md:items-center justify-between gap-6">
                    <div class="space-y-4">
                        <h3 class="text-2xl mb-4">Gemance</h3>
                        <p class="text-black text-lg leading-relaxed">
                            For a brief moment in my life I was drawn to the passion of selling and wanted to create my own brand of stone. I found them in rare places where few people went and I wanted to sell them. The concept, which I find crazy in hindsight, was put aside but I keep it in my heart. 
                        </p>
                        <div class="flex gap-3 pt-2">
                            <span class="px-3 py-1 rounded-full bg-black text-white text-xs">Shop</span>
                            <span class="px-3 py-1 rounded-full bg-black text-white text-xs">Global</span>
                            <span class="px-3 py-1 rounded-full bg-black text-white text-xs">Collection</span>
                        </div>
                    </div>
                    <a href="https://gemance.com" class="group flex items-center gap-2 text-black italic hover:text-green-300 transition-colors">
                        <span>Discover</span>
                        <svg class="w-4 h-4 transform group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </a>
                </div>
            </div>
            
                        <!-- Peerkinton -->
            <div class="project-card p-8 rounded-2xl bg-white/5 hover:bg-white/10 transition-all duration-500 opacity-0 transform translate-y-10">
                <div class="flex flex-col md:flex-row items-start md:items-center justify-between gap-6">
                    <div class="space-y-4">
                        <h3 class="text-2xl mb-4 gradient-text">Peerkinton</h3>
                        <p class="text-white/80 text-lg leading-relaxed">
                            This site is for a pending project of my company. The aim of the project is to launch a web police force to combat cybercriminals, while remaining and acting in a way that is consistent with my company's mission. 
                        </p>
                        <div class="flex gap-3 pt-2">
                            <span class="px-3 py-1 rounded-full bg-white/5 text-white/60 text-xs">Web</span>
                            <span class="px-3 py-1 rounded-full bg-white/5 text-white/60 text-xs">Crime</span>
                            <span class="px-3 py-1 rounded-full bg-white/5 text-white/60 text-xs">Police</span>
                        </div>
                    </div>
                    <a href="https://peerkinton.com" class="group flex items-center gap-2 text-green-400 hover:text-green-300 transition-colors">
                        <span>Discover</span>
                        <svg class="w-4 h-4 transform group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>

<script>
// Animation du titre des projets
gsap.to(".projects-h2", {
    scrollTrigger: {
        trigger: ".projects h2",
        start: "top 80%",
    },
    opacity: 1,
    y: 0,
    duration: 1
});

// Animation des cartes de projet avec un délai entre chaque
gsap.utils.toArray(".project-card").forEach((card, i) => {
    gsap.to(card, {
        scrollTrigger: {
            trigger: card,
            start: "top 85%"
        },
        opacity: 1,
        y: 0,
        duration: 0.8,
        delay: i * 0.3,
        ease: "power3.out"
    });
});
</script>
</section>



</body>
</html>
