import * as framer_motion from 'framer-motion';
import { AccordionItemBaseProps, AccordionItemIndicatorProps } from './base/accordion-item-base.mjs';
import * as tailwind_variants from 'tailwind-variants';
import * as react from 'react';
import * as _heroui_system from '@heroui/system';
import { HTMLHeroUIProps, PropGetter } from '@heroui/system';
import { AccordionItemVariantProps } from '@heroui/theme';
import { ReactRef } from '@heroui/react-utils';
import { NodeWithProps } from '@heroui/aria-utils';
import { TreeState } from '@react-stately/tree';
import '@react-types/shared';

interface Props<T extends object> extends HTMLHeroUIProps<"div"> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLButtonElement | null>;
    /**
     * The item node.
     */
    item: NodeWithProps<T, AccordionItemBaseProps<T>>;
    /**
     * The accordion tree state.
     */
    state: TreeState<T>;
    /**
     * Current focused key.
     */
    focusedKey: React.Key | null;
    /**
     * Callback fired when the focus state changes.
     */
    onFocusChange?: (isFocused: boolean, key?: React.Key) => void;
}
type UseAccordionItemProps<T extends object = {}> = Props<T> & AccordionItemVariantProps & Omit<AccordionItemBaseProps, "onFocusChange">;
declare function useAccordionItem<T extends object = {}>(props: UseAccordionItemProps<T>): {
    Component: _heroui_system.As<any>;
    HeadingComponent: "symbol" | "object" | "base" | "title" | "a" | "abbr" | "address" | "area" | "article" | "aside" | "audio" | "b" | "bdi" | "bdo" | "big" | "blockquote" | "body" | "br" | "button" | "canvas" | "caption" | "center" | "cite" | "code" | "col" | "colgroup" | "data" | "datalist" | "dd" | "del" | "details" | "dfn" | "dialog" | "div" | "dl" | "dt" | "em" | "embed" | "fieldset" | "figcaption" | "figure" | "footer" | "form" | "h1" | "h2" | "h3" | "h4" | "h5" | "h6" | "head" | "header" | "hgroup" | "hr" | "html" | "i" | "iframe" | "img" | "input" | "ins" | "kbd" | "keygen" | "label" | "legend" | "li" | "link" | "main" | "map" | "mark" | "menu" | "menuitem" | "meta" | "meter" | "nav" | "noindex" | "noscript" | "ol" | "optgroup" | "option" | "output" | "p" | "param" | "picture" | "pre" | "progress" | "q" | "rp" | "rt" | "ruby" | "s" | "samp" | "slot" | "script" | "section" | "select" | "small" | "source" | "span" | "strong" | "style" | "sub" | "summary" | "sup" | "table" | "template" | "tbody" | "td" | "textarea" | "tfoot" | "th" | "thead" | "time" | "tr" | "track" | "u" | "ul" | "var" | "video" | "wbr" | "webview" | "svg" | "animate" | "animateMotion" | "animateTransform" | "circle" | "clipPath" | "defs" | "desc" | "ellipse" | "feBlend" | "feColorMatrix" | "feComponentTransfer" | "feComposite" | "feConvolveMatrix" | "feDiffuseLighting" | "feDisplacementMap" | "feDistantLight" | "feDropShadow" | "feFlood" | "feFuncA" | "feFuncB" | "feFuncG" | "feFuncR" | "feGaussianBlur" | "feImage" | "feMerge" | "feMergeNode" | "feMorphology" | "feOffset" | "fePointLight" | "feSpecularLighting" | "feSpotLight" | "feTile" | "feTurbulence" | "filter" | "foreignObject" | "g" | "image" | "line" | "linearGradient" | "marker" | "mask" | "metadata" | "mpath" | "path" | "pattern" | "polygon" | "polyline" | "radialGradient" | "rect" | "stop" | "switch" | "text" | "textPath" | "tspan" | "use" | "view" | react.ComponentClass<any, any> | react.FunctionComponent<any>;
    item: NodeWithProps<T, AccordionItemBaseProps<T>>;
    slots: {
        base: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        heading: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        trigger: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        startContent: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        indicator: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        titleWrapper: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        title: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        subtitle: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        heading: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        trigger: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        startContent: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        indicator: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        titleWrapper: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        title: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        subtitle: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            isDisabled?: boolean | undefined;
            hideIndicator?: boolean | undefined;
            disableIndicatorAnimation?: boolean | undefined;
            variant?: "splitted" | undefined;
            isCompact?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    classNames: {
        base?: string | false | 0 | tailwind_variants.ClassValue[] | null | undefined;
        heading?: string | false | 0 | tailwind_variants.ClassValue[] | null | undefined;
        startContent?: string | false | 0 | tailwind_variants.ClassValue[] | null | undefined;
        indicator?: string | false | 0 | tailwind_variants.ClassValue[] | null | undefined;
        titleWrapper?: string | false | 0 | tailwind_variants.ClassValue[] | null | undefined;
        title?: string | false | 0 | tailwind_variants.ClassValue[] | null | undefined;
        subtitle?: string | false | 0 | tailwind_variants.ClassValue[] | null | undefined;
        content?: string | false | 0 | tailwind_variants.ClassValue[] | null | undefined;
        trigger?: string | false | 0 | tailwind_variants.ClassValue[] | null | undefined;
    };
    domRef: react.RefObject<HTMLButtonElement>;
    indicator: react.ReactNode | ((props: AccordionItemIndicatorProps) => react.ReactNode);
    children: react.ReactNode;
    title: string | (string & react.ReactElement<any, string | react.JSXElementConstructor<any>>) | (string & react.ReactFragment) | (string & react.ReactPortal) | undefined;
    subtitle: react.ReactNode;
    startContent: react.ReactNode;
    isOpen: boolean;
    isDisabled: boolean;
    hideIndicator: boolean;
    keepContentMounted: boolean;
    disableAnimation: boolean;
    motionProps: framer_motion.HTMLMotionProps<"section"> | undefined;
    getBaseProps: PropGetter;
    getHeadingProps: PropGetter;
    getButtonProps: PropGetter;
    getContentProps: PropGetter;
    getIndicatorProps: PropGetter;
    getTitleProps: PropGetter;
    getSubtitleProps: PropGetter;
};
type UseAccordionItemReturn = ReturnType<typeof useAccordionItem>;

export { type Props, type UseAccordionItemProps, type UseAccordionItemReturn, useAccordionItem };
