import * as react from 'react';
import { ReactNode } from 'react';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { AvatarGroupVariantProps, SlotsToClasses, AvatarGroupSlots } from '@heroui/theme';
import { ReactRef } from '@heroui/react-utils';
import { AvatarProps } from './avatar.js';
import './use-avatar.js';
import 'tailwind-variants';

interface Props extends HTMLHeroUIProps<"div"> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLDivElement | null>;
    /**
     * Whether the avatars should be displayed in a grid
     */
    isGrid?: boolean;
    /**
     * The maximum number of visible avatars
     * @default 5
     */
    max?: number;
    /**
     * Control the number of avatar not visible
     */
    total?: number;
    /**
     * This allows you to render a custom count component.
     */
    renderCount?: (count: number) => ReactNode;
    /**
     * Classname or List of classes to change the classNames of the avatar group.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <AvatarGroup classNames={{
     *    base: "base-classes",
     *    count: "count-classes"
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<AvatarGroupSlots>;
}
type UseAvatarGroupProps = Props & Omit<AvatarGroupVariantProps, "children" | "isGrid"> & Partial<Pick<AvatarProps, "size" | "color" | "radius" | "isDisabled" | "isBordered">>;
type ContextType = {
    size?: AvatarProps["size"];
    color?: AvatarProps["color"];
    radius?: AvatarProps["radius"];
    isGrid?: boolean;
    isBordered?: AvatarProps["isBordered"];
    isDisabled?: AvatarProps["isDisabled"];
};
declare function useAvatarGroup(props?: UseAvatarGroupProps): {
    Component: _heroui_system.As<any>;
    context: ContextType;
    remainingCount: number;
    clones: react.ReactElement<any, string | react.JSXElementConstructor<any>>[];
    renderCount: ((count: number) => ReactNode) | undefined;
    getAvatarGroupProps: PropGetter;
    getAvatarGroupCountProps: () => AvatarProps;
};
type UseAvatarReturn = ReturnType<typeof useAvatarGroup>;

export { type ContextType, type UseAvatarGroupProps, type UseAvatarReturn, useAvatarGroup };
