import * as tailwind_variants from 'tailwind-variants';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { BadgeVariantProps, SlotsToClasses, BadgeSlots } from '@heroui/theme';
import { ReactNode } from 'react';
import { ReactRef } from '@heroui/react-utils';

interface Props extends HTMLHeroUIProps<"span", "content"> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLSpanElement | null>;
    /**
     * The children of the badge.
     */
    children: ReactNode;
    /**
     * The content of the badge. The badge will be rendered relative to its children.
     */
    content?: string | number | ReactNode;
    /**
     * Whether to disable the outline around the badge.
     * @deprecated use `showOutline` instead
     * @default false
     */
    disableOutline?: boolean;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <Badge classNames={{
     *    base:"base-classes", // wrapper
     *    badge: "badge-classes",
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<BadgeSlots>;
}
type UseBadgeProps = Props & BadgeVariantProps;
declare function useBadge(originalProps: UseBadgeProps): {
    Component: _heroui_system.As<any>;
    children: ReactNode;
    content: ReactNode;
    slots: {
        base: (slotProps?: ({
            variant?: "solid" | "flat" | "shadow" | "faded" | undefined;
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "md" | "sm" | "lg" | undefined;
            shape?: "rectangle" | "circle" | undefined;
            placement?: "top-right" | "top-left" | "bottom-right" | "bottom-left" | undefined;
            showOutline?: boolean | undefined;
            isInvisible?: boolean | undefined;
            isOneChar?: boolean | undefined;
            isDot?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        badge: (slotProps?: ({
            variant?: "solid" | "flat" | "shadow" | "faded" | undefined;
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "md" | "sm" | "lg" | undefined;
            shape?: "rectangle" | "circle" | undefined;
            placement?: "top-right" | "top-left" | "bottom-right" | "bottom-left" | undefined;
            showOutline?: boolean | undefined;
            isInvisible?: boolean | undefined;
            isOneChar?: boolean | undefined;
            isDot?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            variant?: "solid" | "flat" | "shadow" | "faded" | undefined;
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "md" | "sm" | "lg" | undefined;
            shape?: "rectangle" | "circle" | undefined;
            placement?: "top-right" | "top-left" | "bottom-right" | "bottom-left" | undefined;
            showOutline?: boolean | undefined;
            isInvisible?: boolean | undefined;
            isOneChar?: boolean | undefined;
            isDot?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        badge: (slotProps?: ({
            variant?: "solid" | "flat" | "shadow" | "faded" | undefined;
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "md" | "sm" | "lg" | undefined;
            shape?: "rectangle" | "circle" | undefined;
            placement?: "top-right" | "top-left" | "bottom-right" | "bottom-left" | undefined;
            showOutline?: boolean | undefined;
            isInvisible?: boolean | undefined;
            isOneChar?: boolean | undefined;
            isDot?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    classNames: SlotsToClasses<"base" | "badge"> | undefined;
    disableAnimation: boolean;
    isInvisible: boolean | undefined;
    getBadgeProps: PropGetter;
};
type UseBadgeReturn = ReturnType<typeof useBadge>;

export { type UseBadgeProps, type UseBadgeReturn, useBadge };
