import * as react from 'react';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { ButtonProps } from './button.mjs';
import { ButtonGroupVariantProps } from '@heroui/theme';
import { ReactRef } from '@heroui/react-utils';
import './use-button.mjs';
import '@heroui/use-aria-button';
import '@heroui/ripple';

interface Props extends HTMLHeroUIProps, ButtonGroupVariantProps {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLDivElement | null>;
    /**
     * Whether the buttons are disabled.
     * @default false
     */
    isDisabled?: ButtonProps["isDisabled"];
}
type ContextType = {
    size?: ButtonProps["size"];
    color?: ButtonProps["color"];
    variant?: ButtonProps["variant"];
    radius?: ButtonProps["radius"];
    isDisabled?: ButtonProps["isDisabled"];
    disableAnimation?: ButtonProps["disableAnimation"];
    disableRipple?: ButtonProps["disableRipple"];
    isIconOnly?: ButtonProps["isIconOnly"];
    fullWidth?: boolean;
};
type UseButtonGroupProps = Props & Partial<Pick<ButtonProps, "size" | "color" | "radius" | "variant" | "isIconOnly" | "disableAnimation" | "disableRipple">>;
declare function useButtonGroup(originalProps: UseButtonGroupProps): {
    Component: _heroui_system.As<any>;
    children: react.ReactNode;
    domRef: react.RefObject<HTMLDivElement>;
    context: ContextType;
    classNames: string;
    getButtonGroupProps: PropGetter;
};
type UseButtonGroupReturn = ReturnType<typeof useButtonGroup>;

export { type ContextType, type UseButtonGroupProps, type UseButtonGroupReturn, useButtonGroup };
