"use client";
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/calendar-header.tsx
var calendar_header_exports = {};
__export(calendar_header_exports, {
  CalendarHeader: () => CalendarHeader
});
module.exports = __toCommonJS(calendar_header_exports);
var import_i18n = require("@react-aria/i18n");
var import_framer_motion = require("framer-motion");
var import_button = require("@heroui/button");
var import_react = require("react");

// src/calendar-transitions.ts
var slideVariants = {
  enter: (direction) => ({
    x: `${direction * 100}%`
  }),
  center: {
    x: "0%"
  },
  exit: (direction) => ({
    x: `${direction * -100}%`
  })
};

// src/chevron-down.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var ChevronDownIcon = (props) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
  "svg",
  {
    "aria-hidden": "true",
    fill: "none",
    focusable: "false",
    height: "1em",
    role: "presentation",
    viewBox: "0 0 24 24",
    width: "1em",
    ...props,
    children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      "path",
      {
        d: "M19 9L12 15L5 9",
        stroke: "currentColor",
        strokeLinecap: "round",
        strokeLinejoin: "round",
        strokeWidth: "1.5"
      }
    )
  }
);

// src/calendar-context.ts
var import_react_utils = require("@heroui/react-utils");
var [CalendarProvider, useCalendarContext] = (0, import_react_utils.createContext)({
  name: "CalendarContext",
  strict: true,
  errorMessage: "useContext: `context` is undefined. Seems you forgot to wrap component within the CalendarProvider"
});

// src/calendar-header.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
function CalendarHeader(props) {
  const { direction, date, currentMonth, buttonPickerProps } = props;
  const {
    state,
    slots,
    headerRef,
    showMonthAndYearPickers,
    isHeaderExpanded,
    setIsHeaderExpanded,
    disableAnimation,
    classNames
  } = useCalendarContext();
  const monthAndYearDateFormatter = (0, import_i18n.useDateFormatter)({
    month: "long",
    era: currentMonth.calendar.identifier === "gregory" && currentMonth.era === "BC" ? "short" : void 0,
    calendar: currentMonth.calendar.identifier,
    timeZone: state.timeZone,
    year: "numeric"
  });
  const monthDateContent = monthAndYearDateFormatter.format(date.toDate(state.timeZone));
  const headerTitle = /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_jsx_runtime2.Fragment, { children: disableAnimation ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    "span",
    {
      "aria-hidden": true,
      className: slots == null ? void 0 : slots.title({ class: classNames == null ? void 0 : classNames.title }),
      "data-slot": "title",
      children: monthDateContent
    },
    currentMonth.month
  ) : /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    import_framer_motion.m.span,
    {
      animate: "center",
      "aria-hidden": true,
      className: slots == null ? void 0 : slots.title({ class: classNames == null ? void 0 : classNames.title }),
      custom: direction,
      "data-slot": "title",
      exit: "exit",
      initial: "enter",
      variants: isHeaderExpanded ? {} : slideVariants,
      children: monthDateContent
    },
    currentMonth.month
  ) });
  const headerProps = {
    ref: headerRef,
    className: slots == null ? void 0 : slots.header({ class: classNames == null ? void 0 : classNames.header }),
    "data-slot": "header"
  };
  const handleKeyDown = (0, import_react.useCallback)(
    (e) => {
      if (e.key === "Escape") {
        e.preventDefault();
        e.stopPropagation();
        setIsHeaderExpanded == null ? void 0 : setIsHeaderExpanded(false);
      }
    },
    [setIsHeaderExpanded]
  );
  return showMonthAndYearPickers ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    import_button.Button,
    {
      ...headerProps,
      "aria-label": "switch to year and month view",
      disableAnimation,
      endContent: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(ChevronDownIcon, { className: "chevron-icon" }),
      onKeyDown: handleKeyDown,
      ...buttonPickerProps,
      children: headerTitle
    }
  ) : /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("header", { ...headerProps, children: headerTitle });
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CalendarHeader
});
