import * as _react_types_shared from '@react-types/shared';
import * as _react_types_calendar from '@react-types/calendar';
import { CalendarPropsBase } from '@react-types/calendar';
import * as react from 'react';
import { RefObject, ReactNode } from 'react';
import * as _internationalized_date from '@internationalized/date';
import { CalendarDate, Calendar } from '@internationalized/date';
import * as tailwind_variants from 'tailwind-variants';
import * as _heroui_system from '@heroui/system';
import { SupportedCalendars, PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { CalendarVariantProps, CalendarReturnType, SlotsToClasses, CalendarSlots } from '@heroui/theme';
import { AriaCalendarGridProps } from '@react-aria/calendar';
import { AriaButtonProps } from '@react-types/button';
import { ButtonProps } from '@heroui/button';
import { CalendarState, RangeCalendarState } from '@react-stately/calendar';
import { ReactRef } from '@heroui/react-utils';

type HeroUIBaseProps = Omit<HTMLHeroUIProps<"div">, keyof CalendarPropsBase | "onChange">;
interface Props extends HeroUIBaseProps {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLDivElement | null>;
    /**
     * Custom content to be included in the top of the calendar.
     */
    topContent?: ReactNode;
    /**
     * Custom content to be included in the bottom of the calendar.
     */
    bottomContent?: ReactNode;
    /**
     * The number of months to display at once. Up to 3 months are supported.
     * Passing a number greater than 1 will disable the `showMonthAndYearPickers` prop.
     *
     * @default 1
     */
    visibleMonths?: number;
    /**
     * The width to be applied to the calendar component. This value is multiplied by the number
     * of visible months to determine the total width of the calendar.
     *
     * @default 256
     */
    calendarWidth?: number | string;
    /**
     * Props for the navigation button, prev button and next button.
     */
    navButtonProps?: ButtonProps;
    /**
     * Props for the previous button.
     */
    prevButtonProps?: ButtonProps;
    /**
     * Props for the next button.
     */
    nextButtonProps?: ButtonProps;
    /**
     * Whether to show the description or error message.
     * @default true
     */
    showHelper?: boolean;
    /**
     * The day that starts the week.
     */
    firstDayOfWeek?: "sun" | "mon" | "tue" | "wed" | "thu" | "fri" | "sat";
    /**
     * Whether the calendar header is expanded. This is only available if the `showMonthAndYearPickers` prop is set to `true`.
     * @default false
     */
    isHeaderExpanded?: boolean;
    /**
     * Whether the calendar header should be expanded by default.This is only available if the `showMonthAndYearPickers` prop is set to `true`.
     * @default false
     */
    isHeaderDefaultExpanded?: boolean;
    /**
     * The event handler for the calendar header expanded state. This is only available if the `showMonthAndYearPickers` prop is set to `true`.
     * @param isExpanded boolean
     * @returns void
     */
    onHeaderExpandedChange?: (isExpanded: boolean) => void;
    /**
     * This function helps to reduce the bundle size by providing a custom calendar system.
     *
     * In the example above, the createCalendar function from the `@internationalized/date` package
     * is passed to the useCalendarState hook. This function receives a calendar identifier string,
     * and provides Calendar instances to React Stately, which are used to implement date manipulation.
     *
     * By default, this includes all calendar systems supported by @internationalized/date. However,
     * if your application supports a more limited set of regions, or you know you will only be picking dates
     * in a certain calendar system, you can reduce your bundle size by providing your own implementation
     * of `createCalendar` that includes a subset of these Calendar implementations.
     *
     * For example, if your application only supports Gregorian dates, you could implement a `createCalendar`
     * function like this:
     *
     * @example
     *
     * import {GregorianCalendar} from '@internationalized/date';
     *
     * function createCalendar(identifier) {
     *  switch (identifier) {
     *    case 'gregory':
     *      return new GregorianCalendar();
     *    default:
     *      throw new Error(`Unsupported calendar ${identifier}`);
     *  }
     * }
     *
     * This way, only GregorianCalendar is imported, and the other calendar implementations can be tree-shaken.
     *
     * You can also use the HeroUIProvider to provide the createCalendar function to all nested components.
     *
     * @default all calendars
     */
    createCalendar?: (calendar: SupportedCalendars) => Calendar | null;
    /**
     * The style of weekday names to display in the calendar grid header,
     * e.g. single letter, abbreviation, or full day name.
     * @default "narrow"
     */
    weekdayStyle?: AriaCalendarGridProps["weekdayStyle"];
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     *
     * Component: Calendar, RangeCalendar
     *
     * <Component classNames={{
     *    base:"base-classes",
     *    nextButton:"next-button-classes",
     *    prevButton:"prev-button-classes",
     *    header:"header-classes",
     *    title:"title-classes",
     *    content:"content-classes",
     *    gridWrapper:"grid-wrapper-classes",
     *    grid:"grid-classes",
     *    gridHeader:"grid-header-classes",
     *    gridHeaderRow:"grid-header-row-classes",
     *    gridHeaderCell:"grid-header-cell-classes",
     *    gridBody:"grid-body-classes",
     *    gridBodyRow:"grid-row-classes",
     *    cell:"grid-cell-classes",
     *    cellButton:"grid-cell-button-classes",
     *    pickerWrapper:"picker-wrapper-classes",
     *    pickerMonthList:"picker-month-list-classes",
     *    pickerYearList:"picker-year-list-classes",
     *    pickerHighlight:"picker-highlight-classes",
     *    pickerItem:"picker-item-classes",
     *    helperWrapper:"helper-wrapper-classes",
     *    errorMessage:"error-message-classes",
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<CalendarSlots>;
}
type UseCalendarBasePropsComplete = Props & CalendarVariantProps & CalendarPropsBase;
type UseCalendarBaseProps = Omit<UseCalendarBasePropsComplete, "isRange"> & {
    /**
     * Props for the button picker, which is used to select the month, year and expand the header.
     */
    buttonPickerProps?: ButtonProps;
};
type ContextType<T extends CalendarState | RangeCalendarState> = {
    state: T;
    visibleMonths: number;
    headerRef?: RefObject<any>;
    slots?: CalendarReturnType;
    weekdayStyle?: AriaCalendarGridProps["weekdayStyle"];
    isHeaderExpanded?: boolean;
    showMonthAndYearPickers?: boolean;
    setIsHeaderExpanded?: (isExpanded: boolean) => void;
    classNames?: SlotsToClasses<CalendarSlots>;
    disableAnimation?: boolean;
};
declare function useCalendarBase(originalProps: UseCalendarBasePropsComplete): {
    Component: _heroui_system.As<any>;
    children: ReactNode;
    domRef: RefObject<HTMLDivElement>;
    slots: {
        base: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        prevButton: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        nextButton: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        headerWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        header: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        title: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        grid: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridHeader: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridHeaderRow: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridHeaderCell: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridBody: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridBodyRow: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        cell: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        cellButton: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerMonthList: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerYearList: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerHighlight: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerItem: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        helperWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        errorMessage: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        prevButton: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        nextButton: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        headerWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        header: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        title: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        grid: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridHeader: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridHeaderRow: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridHeaderCell: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridBody: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        gridBodyRow: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        cell: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        cellButton: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerMonthList: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerYearList: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerHighlight: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        pickerItem: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        helperWrapper: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        errorMessage: (slotProps?: ({
            color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
            showShadow?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            isRTL?: boolean | undefined;
            isRange?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    locale: string;
    minValue: CalendarDate | _internationalized_date.CalendarDateTime | _internationalized_date.ZonedDateTime | null;
    maxValue: CalendarDate | _internationalized_date.CalendarDateTime | _internationalized_date.ZonedDateTime | null;
    baseProps: {
        "data-slot": string;
        "data-has-multiple-months": boolean | "true" | "false";
        style: React.CSSProperties;
    };
    showHelper: boolean;
    firstDayOfWeek: "sun" | "mon" | "tue" | "wed" | "thu" | "fri" | "sat" | undefined;
    weekdayStyle: "narrow" | "short" | "long";
    visibleMonths: number;
    visibleDuration: {
        months: number;
    };
    shouldFilterDOMProps: boolean;
    isHeaderExpanded: boolean | undefined;
    showMonthAndYearPickers: boolean | undefined;
    disableAnimation: boolean;
    createCalendar: ((calendar: SupportedCalendars) => Calendar | null) | null;
    getPrevButtonProps: (props?: {}) => AriaButtonProps;
    getNextButtonProps: (props?: {}) => AriaButtonProps;
    getErrorMessageProps: PropGetter;
    setIsHeaderExpanded: (value: boolean | undefined, ...args: any[]) => void;
    topContent: ReactNode;
    bottomContent: ReactNode;
    errorMessage: ReactNode;
    classNames: SlotsToClasses<"base" | "header" | "title" | "content" | "errorMessage" | "gridWrapper" | "grid" | "gridHeader" | "gridHeaderRow" | "gridHeaderCell" | "gridBody" | "gridBodyRow" | "cell" | "pickerWrapper" | "pickerMonthList" | "pickerYearList" | "pickerHighlight" | "helperWrapper" | "prevButton" | "nextButton" | "headerWrapper" | "cellButton" | "pickerItem"> | undefined;
    otherProps: {
        style?: react.CSSProperties | undefined;
        title?: string | undefined | undefined;
        key?: react.Key | null | undefined;
        suppressContentEditableWarning?: boolean | undefined | undefined;
        suppressHydrationWarning?: boolean | undefined | undefined;
        accessKey?: string | undefined | undefined;
        contentEditable?: (boolean | "true" | "false") | "inherit" | undefined;
        contextMenu?: string | undefined | undefined;
        dir?: string | undefined | undefined;
        draggable?: (boolean | "true" | "false") | undefined;
        hidden?: boolean | undefined | undefined;
        id?: string | undefined | undefined;
        lang?: string | undefined | undefined;
        nonce?: string | undefined | undefined;
        placeholder?: string | undefined | undefined;
        spellCheck?: (boolean | "true" | "false") | undefined;
        tabIndex?: number | undefined | undefined;
        translate?: "yes" | "no" | undefined | undefined;
        radioGroup?: string | undefined | undefined;
        role?: react.AriaRole | undefined;
        about?: string | undefined | undefined;
        content?: string | undefined | undefined;
        datatype?: string | undefined | undefined;
        inlist?: any;
        prefix?: string | undefined | undefined;
        property?: string | undefined | undefined;
        rel?: string | undefined | undefined;
        resource?: string | undefined | undefined;
        rev?: string | undefined | undefined;
        typeof?: string | undefined | undefined;
        vocab?: string | undefined | undefined;
        autoCapitalize?: string | undefined | undefined;
        autoCorrect?: string | undefined | undefined;
        autoSave?: string | undefined | undefined;
        itemProp?: string | undefined | undefined;
        itemScope?: boolean | undefined | undefined;
        itemType?: string | undefined | undefined;
        itemID?: string | undefined | undefined;
        itemRef?: string | undefined | undefined;
        results?: number | undefined | undefined;
        security?: string | undefined | undefined;
        unselectable?: "on" | "off" | undefined | undefined;
        inputMode?: "none" | "text" | "tel" | "url" | "email" | "numeric" | "decimal" | "search" | undefined | undefined;
        is?: string | undefined | undefined;
        'aria-activedescendant'?: string | undefined | undefined;
        'aria-atomic'?: (boolean | "true" | "false") | undefined;
        'aria-autocomplete'?: "none" | "inline" | "list" | "both" | undefined | undefined;
        'aria-busy'?: (boolean | "true" | "false") | undefined;
        'aria-checked'?: boolean | "false" | "mixed" | "true" | undefined | undefined;
        'aria-colcount'?: number | undefined | undefined;
        'aria-colindex'?: number | undefined | undefined;
        'aria-colspan'?: number | undefined | undefined;
        'aria-controls'?: string | undefined | undefined;
        'aria-current'?: boolean | "false" | "true" | "page" | "step" | "location" | "date" | "time" | undefined | undefined;
        'aria-describedby'?: string | undefined | undefined;
        'aria-details'?: string | undefined | undefined;
        'aria-disabled'?: (boolean | "true" | "false") | undefined;
        'aria-dropeffect'?: "none" | "copy" | "execute" | "link" | "move" | "popup" | undefined | undefined;
        'aria-errormessage'?: string | undefined | undefined;
        'aria-expanded'?: (boolean | "true" | "false") | undefined;
        'aria-flowto'?: string | undefined | undefined;
        'aria-grabbed'?: (boolean | "true" | "false") | undefined;
        'aria-haspopup'?: boolean | "false" | "true" | "menu" | "listbox" | "tree" | "grid" | "dialog" | undefined | undefined;
        'aria-hidden'?: (boolean | "true" | "false") | undefined;
        'aria-invalid'?: boolean | "false" | "true" | "grammar" | "spelling" | undefined | undefined;
        'aria-keyshortcuts'?: string | undefined | undefined;
        'aria-label'?: string | undefined | undefined;
        'aria-labelledby'?: string | undefined | undefined;
        'aria-level'?: number | undefined | undefined;
        'aria-live'?: "off" | "assertive" | "polite" | undefined | undefined;
        'aria-modal'?: (boolean | "true" | "false") | undefined;
        'aria-multiline'?: (boolean | "true" | "false") | undefined;
        'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
        'aria-orientation'?: "horizontal" | "vertical" | undefined | undefined;
        'aria-owns'?: string | undefined | undefined;
        'aria-placeholder'?: string | undefined | undefined;
        'aria-posinset'?: number | undefined | undefined;
        'aria-pressed'?: boolean | "false" | "mixed" | "true" | undefined | undefined;
        'aria-readonly'?: (boolean | "true" | "false") | undefined;
        'aria-relevant'?: "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text" | "text additions" | "text removals" | undefined | undefined;
        'aria-required'?: (boolean | "true" | "false") | undefined;
        'aria-roledescription'?: string | undefined | undefined;
        'aria-rowcount'?: number | undefined | undefined;
        'aria-rowindex'?: number | undefined | undefined;
        'aria-rowspan'?: number | undefined | undefined;
        'aria-selected'?: (boolean | "true" | "false") | undefined;
        'aria-setsize'?: number | undefined | undefined;
        'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined | undefined;
        'aria-valuemax'?: number | undefined | undefined;
        'aria-valuemin'?: number | undefined | undefined;
        'aria-valuenow'?: number | undefined | undefined;
        'aria-valuetext'?: string | undefined | undefined;
        dangerouslySetInnerHTML?: {
            __html: string | TrustedHTML;
        } | undefined | undefined;
        onCopy?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCopyCapture?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCut?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCutCapture?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onPaste?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onPasteCapture?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCompositionEnd?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionEndCapture?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionStart?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionStartCapture?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionUpdate?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionUpdateCapture?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onFocus?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onFocusCapture?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onBlur?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onBlurCapture?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onChangeCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onBeforeInput?: react.FormEventHandler<HTMLDivElement> | undefined;
        onBeforeInputCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInput?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInputCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onReset?: react.FormEventHandler<HTMLDivElement> | undefined;
        onResetCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onSubmit?: react.FormEventHandler<HTMLDivElement> | undefined;
        onSubmitCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInvalid?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInvalidCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onLoad?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onError?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onErrorCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onKeyDown?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyDownCapture?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyPress?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyPressCapture?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyUp?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyUpCapture?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onAbort?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onAbortCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlay?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayThrough?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayThroughCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onDurationChange?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onDurationChangeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEmptied?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEmptiedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEncrypted?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEncryptedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEnded?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEndedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedData?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedDataCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedMetadata?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedMetadataCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadStart?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadStartCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPause?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPauseCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlay?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlayCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlaying?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlayingCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onProgress?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onProgressCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onRateChange?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onRateChangeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onResize?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onResizeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeeked?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeekedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeeking?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeekingCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onStalled?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onStalledCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSuspend?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSuspendCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onTimeUpdate?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onTimeUpdateCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onVolumeChange?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onVolumeChangeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onWaiting?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onWaitingCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onAuxClick?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onAuxClickCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onClick?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onClickCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onContextMenu?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onContextMenuCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onDoubleClick?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onDoubleClickCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onDrag?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEnd?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEndCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEnter?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEnterCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragExit?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragExitCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragLeave?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragLeaveCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragOver?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragOverCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragStart?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragStartCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDrop?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDropCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onMouseDown?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseDownCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseEnter?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseLeave?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseMove?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseMoveCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOut?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOutCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOver?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOverCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseUp?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseUpCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onSelect?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSelectCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onTouchCancel?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchCancelCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchEnd?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchEndCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchMove?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchMoveCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchStart?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchStartCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onPointerDown?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerDownCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerMove?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerMoveCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerUp?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerUpCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerCancel?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerCancelCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerEnter?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerEnterCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerLeave?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerLeaveCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOver?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOverCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOut?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOutCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onGotPointerCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onGotPointerCaptureCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onLostPointerCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onLostPointerCaptureCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onScroll?: react.UIEventHandler<HTMLDivElement> | undefined;
        onScrollCapture?: react.UIEventHandler<HTMLDivElement> | undefined;
        onWheel?: react.WheelEventHandler<HTMLDivElement> | undefined;
        onWheelCapture?: react.WheelEventHandler<HTMLDivElement> | undefined;
        onAnimationStart?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationStartCapture?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationEnd?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationEndCapture?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationIteration?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationIterationCapture?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onTransitionEnd?: react.TransitionEventHandler<HTMLDivElement> | undefined;
        onTransitionEndCapture?: react.TransitionEventHandler<HTMLDivElement> | undefined;
        color?: "primary" | "foreground" | "secondary" | "success" | "warning" | "danger" | undefined;
        showShadow?: boolean | undefined;
        hideDisabledDates?: boolean | undefined;
        showMonthAndYearPickers?: boolean | undefined;
        isRTL?: boolean | undefined;
        isRange?: boolean | undefined;
        isHeaderWrapperExpanded?: boolean | undefined;
        disableAnimation?: boolean | undefined;
        isDateUnavailable?: (date: _react_types_calendar.DateValue) => boolean;
        isDisabled?: boolean;
        isReadOnly?: boolean;
        autoFocus?: boolean;
        focusedValue?: _react_types_calendar.DateValue | null;
        defaultFocusedValue?: _react_types_calendar.DateValue | null;
        onFocusChange?: (date: CalendarDate) => void;
        validationState?: _react_types_shared.ValidationState;
        isInvalid?: boolean;
        pageBehavior?: _react_types_calendar.PageBehavior;
    } | {
        style?: react.CSSProperties | undefined;
        title?: string | undefined | undefined;
        key?: react.Key | null | undefined;
        suppressContentEditableWarning?: boolean | undefined | undefined;
        suppressHydrationWarning?: boolean | undefined | undefined;
        accessKey?: string | undefined | undefined;
        autoFocus?: boolean | undefined;
        contentEditable?: (boolean | "true" | "false") | "inherit" | undefined;
        contextMenu?: string | undefined | undefined;
        dir?: string | undefined | undefined;
        draggable?: (boolean | "true" | "false") | undefined;
        hidden?: boolean | undefined | undefined;
        id?: string | undefined | undefined;
        lang?: string | undefined | undefined;
        nonce?: string | undefined | undefined;
        placeholder?: string | undefined | undefined;
        spellCheck?: (boolean | "true" | "false") | undefined;
        tabIndex?: number | undefined | undefined;
        translate?: "yes" | "no" | undefined | undefined;
        radioGroup?: string | undefined | undefined;
        role?: react.AriaRole | undefined;
        about?: string | undefined | undefined;
        content?: string | undefined | undefined;
        datatype?: string | undefined | undefined;
        inlist?: any;
        prefix?: string | undefined | undefined;
        property?: string | undefined | undefined;
        rel?: string | undefined | undefined;
        resource?: string | undefined | undefined;
        rev?: string | undefined | undefined;
        typeof?: string | undefined | undefined;
        vocab?: string | undefined | undefined;
        autoCapitalize?: string | undefined | undefined;
        autoCorrect?: string | undefined | undefined;
        autoSave?: string | undefined | undefined;
        itemProp?: string | undefined | undefined;
        itemScope?: boolean | undefined | undefined;
        itemType?: string | undefined | undefined;
        itemID?: string | undefined | undefined;
        itemRef?: string | undefined | undefined;
        results?: number | undefined | undefined;
        security?: string | undefined | undefined;
        unselectable?: "on" | "off" | undefined | undefined;
        inputMode?: "none" | "text" | "tel" | "url" | "email" | "numeric" | "decimal" | "search" | undefined | undefined;
        is?: string | undefined | undefined;
        'aria-activedescendant'?: string | undefined | undefined;
        'aria-atomic'?: (boolean | "true" | "false") | undefined;
        'aria-autocomplete'?: "none" | "inline" | "list" | "both" | undefined | undefined;
        'aria-busy'?: (boolean | "true" | "false") | undefined;
        'aria-checked'?: boolean | "false" | "mixed" | "true" | undefined | undefined;
        'aria-colcount'?: number | undefined | undefined;
        'aria-colindex'?: number | undefined | undefined;
        'aria-colspan'?: number | undefined | undefined;
        'aria-controls'?: string | undefined | undefined;
        'aria-current'?: boolean | "false" | "true" | "page" | "step" | "location" | "date" | "time" | undefined | undefined;
        'aria-describedby'?: string | undefined | undefined;
        'aria-details'?: string | undefined | undefined;
        'aria-disabled'?: (boolean | "true" | "false") | undefined;
        'aria-dropeffect'?: "none" | "copy" | "execute" | "link" | "move" | "popup" | undefined | undefined;
        'aria-errormessage'?: string | undefined | undefined;
        'aria-expanded'?: (boolean | "true" | "false") | undefined;
        'aria-flowto'?: string | undefined | undefined;
        'aria-grabbed'?: (boolean | "true" | "false") | undefined;
        'aria-haspopup'?: boolean | "false" | "true" | "menu" | "listbox" | "tree" | "grid" | "dialog" | undefined | undefined;
        'aria-hidden'?: (boolean | "true" | "false") | undefined;
        'aria-invalid'?: boolean | "false" | "true" | "grammar" | "spelling" | undefined | undefined;
        'aria-keyshortcuts'?: string | undefined | undefined;
        'aria-label'?: string | undefined | undefined;
        'aria-labelledby'?: string | undefined | undefined;
        'aria-level'?: number | undefined | undefined;
        'aria-live'?: "off" | "assertive" | "polite" | undefined | undefined;
        'aria-modal'?: (boolean | "true" | "false") | undefined;
        'aria-multiline'?: (boolean | "true" | "false") | undefined;
        'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
        'aria-orientation'?: "horizontal" | "vertical" | undefined | undefined;
        'aria-owns'?: string | undefined | undefined;
        'aria-placeholder'?: string | undefined | undefined;
        'aria-posinset'?: number | undefined | undefined;
        'aria-pressed'?: boolean | "false" | "mixed" | "true" | undefined | undefined;
        'aria-readonly'?: (boolean | "true" | "false") | undefined;
        'aria-relevant'?: "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text" | "text additions" | "text removals" | undefined | undefined;
        'aria-required'?: (boolean | "true" | "false") | undefined;
        'aria-roledescription'?: string | undefined | undefined;
        'aria-rowcount'?: number | undefined | undefined;
        'aria-rowindex'?: number | undefined | undefined;
        'aria-rowspan'?: number | undefined | undefined;
        'aria-selected'?: (boolean | "true" | "false") | undefined;
        'aria-setsize'?: number | undefined | undefined;
        'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined | undefined;
        'aria-valuemax'?: number | undefined | undefined;
        'aria-valuemin'?: number | undefined | undefined;
        'aria-valuenow'?: number | undefined | undefined;
        'aria-valuetext'?: string | undefined | undefined;
        dangerouslySetInnerHTML?: {
            __html: string | TrustedHTML;
        } | undefined | undefined;
        onCopy?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCopyCapture?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCut?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCutCapture?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onPaste?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onPasteCapture?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCompositionEnd?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionEndCapture?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionStart?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionStartCapture?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionUpdate?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionUpdateCapture?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onFocus?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onFocusCapture?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onBlur?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onBlurCapture?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onChangeCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onBeforeInput?: react.FormEventHandler<HTMLDivElement> | undefined;
        onBeforeInputCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInput?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInputCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onReset?: react.FormEventHandler<HTMLDivElement> | undefined;
        onResetCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onSubmit?: react.FormEventHandler<HTMLDivElement> | undefined;
        onSubmitCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInvalid?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInvalidCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onLoad?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onError?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onErrorCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onKeyDown?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyDownCapture?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyPress?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyPressCapture?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyUp?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyUpCapture?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onAbort?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onAbortCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlay?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayThrough?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayThroughCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onDurationChange?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onDurationChangeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEmptied?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEmptiedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEncrypted?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEncryptedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEnded?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEndedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedData?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedDataCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedMetadata?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedMetadataCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadStart?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadStartCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPause?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPauseCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlay?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlayCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlaying?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlayingCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onProgress?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onProgressCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onRateChange?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onRateChangeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onResize?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onResizeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeeked?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeekedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeeking?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeekingCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onStalled?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onStalledCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSuspend?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSuspendCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onTimeUpdate?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onTimeUpdateCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onVolumeChange?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onVolumeChangeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onWaiting?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onWaitingCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onAuxClick?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onAuxClickCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onClick?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onClickCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onContextMenu?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onContextMenuCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onDoubleClick?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onDoubleClickCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onDrag?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEnd?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEndCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEnter?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEnterCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragExit?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragExitCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragLeave?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragLeaveCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragOver?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragOverCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragStart?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragStartCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDrop?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDropCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onMouseDown?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseDownCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseEnter?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseLeave?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseMove?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseMoveCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOut?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOutCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOver?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOverCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseUp?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseUpCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onSelect?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSelectCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onTouchCancel?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchCancelCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchEnd?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchEndCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchMove?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchMoveCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchStart?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchStartCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onPointerDown?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerDownCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerMove?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerMoveCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerUp?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerUpCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerCancel?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerCancelCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerEnter?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerEnterCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerLeave?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerLeaveCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOver?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOverCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOut?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOutCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onGotPointerCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onGotPointerCaptureCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onLostPointerCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onLostPointerCaptureCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onScroll?: react.UIEventHandler<HTMLDivElement> | undefined;
        onScrollCapture?: react.UIEventHandler<HTMLDivElement> | undefined;
        onWheel?: react.WheelEventHandler<HTMLDivElement> | undefined;
        onWheelCapture?: react.WheelEventHandler<HTMLDivElement> | undefined;
        onAnimationStart?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationStartCapture?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationEnd?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationEndCapture?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationIteration?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationIterationCapture?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onTransitionEnd?: react.TransitionEventHandler<HTMLDivElement> | undefined;
        onTransitionEndCapture?: react.TransitionEventHandler<HTMLDivElement> | undefined;
        isDisabled?: boolean | undefined;
        onFocusChange?: ((date: CalendarDate) => void) | undefined;
        isInvalid?: boolean | undefined;
        isReadOnly?: boolean | undefined;
        isDateUnavailable?: ((date: _react_types_calendar.DateValue) => boolean) | undefined;
        focusedValue?: (_react_types_calendar.DateValue | null) | undefined;
        defaultFocusedValue?: (_react_types_calendar.DateValue | null) | undefined;
        validationState?: _react_types_shared.ValidationState | undefined;
        pageBehavior?: _react_types_calendar.PageBehavior | undefined;
    };
};
type UseCalendarBaseReturn = ReturnType<typeof useCalendarBase>;

export { type ContextType, type UseCalendarBaseProps, type UseCalendarBasePropsComplete, type UseCalendarBaseReturn, useCalendarBase };
