import * as react from 'react';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { SlotsToClasses, CheckboxGroupSlots } from '@heroui/theme';
import { AriaCheckboxGroupProps } from '@react-types/checkbox';
import { Orientation } from '@react-types/shared';
import { ReactRef } from '@heroui/react-utils';
import { CheckboxGroupState } from '@react-stately/checkbox';
import { CheckboxProps } from './checkbox.mjs';
import './use-checkbox.mjs';

interface Props extends HTMLHeroUIProps<"div"> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLDivElement | null>;
    /**
     * The axis the checkbox group items should align with.
     * @default "vertical"
     */
    orientation?: Orientation;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <CheckboxGroup classNames={{
     *    base:"base-classes",
     *    label: "label-classes",
     *    wrapper: "wrapper-classes", // checkboxes wrapper
     * }} >
     *  // checkboxes
     * </CheckboxGroup>
     * ```
     */
    classNames?: SlotsToClasses<CheckboxGroupSlots>;
    /**
     * React aria onChange event.
     */
    onValueChange?: AriaCheckboxGroupProps["onChange"];
}
type UseCheckboxGroupProps = Omit<Props, "onChange"> & AriaCheckboxGroupProps & Partial<Pick<CheckboxProps, "color" | "size" | "radius" | "lineThrough" | "isDisabled" | "disableAnimation">>;
type ContextType = {
    groupState: CheckboxGroupState;
    color?: CheckboxProps["color"];
    size?: CheckboxProps["size"];
    radius?: CheckboxProps["radius"];
    isInvalid?: UseCheckboxGroupProps["isInvalid"];
    lineThrough?: CheckboxProps["lineThrough"];
    isDisabled?: CheckboxProps["isDisabled"];
    disableAnimation?: CheckboxProps["disableAnimation"];
    validationBehavior?: CheckboxProps["validationBehavior"];
};
declare function useCheckboxGroup(props: UseCheckboxGroupProps): {
    Component: _heroui_system.As<any>;
    children: react.ReactNode;
    label: react.ReactNode;
    context: ContextType;
    description: react.ReactNode;
    isInvalid: boolean;
    errorMessage: react.ReactNode;
    getGroupProps: PropGetter;
    getLabelProps: PropGetter;
    getWrapperProps: PropGetter;
    getDescriptionProps: PropGetter;
    getErrorMessageProps: PropGetter;
};
type UseCheckboxGroupReturn = ReturnType<typeof useCheckboxGroup>;

export { type ContextType, type UseCheckboxGroupProps, type UseCheckboxGroupReturn, useCheckboxGroup };
