import * as tailwind_variants from 'tailwind-variants';
import * as react from 'react';
import * as _react_stately_datepicker from '@react-stately/datepicker';
import { DateInputVariantProps, SlotsToClasses, DateInputSlots } from '@heroui/theme';
import { DateValue, AriaDateFieldProps } from '@react-types/datepicker';
import { PropGetter, SupportedCalendars, HTMLHeroUIProps } from '@heroui/system';
import { Calendar } from '@internationalized/date';
import { ReactRef } from '@heroui/react-utils';
import { DOMAttributes, GroupDOMAttributes } from '@react-types/shared';
import { DateInputGroupProps } from './date-input-group.js';

type HeroUIBaseProps<T extends DateValue> = Omit<HTMLHeroUIProps<"div">, keyof AriaDateFieldProps<T> | "onChange">;
interface Props<T extends DateValue> extends HeroUIBaseProps<T> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLElement | null>;
    /** Props for the grouping element containing the date field and button. */
    groupProps?: GroupDOMAttributes;
    /** Props for the date picker's visible label element, if any. */
    labelProps?: DOMAttributes;
    /** Props for the date field. */
    fieldProps?: DOMAttributes;
    /** Props for the inner wrapper. */
    innerWrapperProps?: DOMAttributes;
    /** Props for the description element, if any. */
    descriptionProps?: DOMAttributes;
    /** Props for the error message element, if any. */
    errorMessageProps?: DOMAttributes;
    /**
     * The value of the hidden input.
     */
    inputRef?: ReactRef<HTMLInputElement | null>;
    /**
     * Element to be rendered in the left side of the input.
     */
    startContent?: React.ReactNode;
    /**
     * Element to be rendered in the right side of the input.
     */
    endContent?: React.ReactNode;
    /**
     * This function helps to reduce the bundle size by providing a custom calendar system.
     *
     * In the example above, the createCalendar function from the `@internationalized/date` package
     * is passed to the useCalendarState hook. This function receives a calendar identifier string,
     * and provides Calendar instances to React Stately, which are used to implement date manipulation.
     *
     * By default, this includes all calendar systems supported by @internationalized/date. However,
     * if your application supports a more limited set of regions, or you know you will only be picking dates
     * in a certain calendar system, you can reduce your bundle size by providing your own implementation
     * of `createCalendar` that includes a subset of these Calendar implementations.
     *
     * For example, if your application only supports Gregorian dates, you could implement a `createCalendar`
     * function like this:
     *
     * @example
     *
     * import {GregorianCalendar} from '@internationalized/date';
     *
     * function createCalendar(identifier) {
     *  switch (identifier) {
     *    case 'gregory':
     *      return new GregorianCalendar();
     *    default:
     *      throw new Error(`Unsupported calendar ${identifier}`);
     *  }
     * }
     *
     * This way, only GregorianCalendar is imported, and the other calendar implementations can be tree-shaken.
     *
     * You can also use the HeroUIProvider to provide the createCalendar function to all nested components.
     *
     * @default all calendars
     */
    createCalendar?: (calendar: SupportedCalendars) => Calendar | null;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <DateInput classNames={{
     *    base:"base-classes",
     *    label: "label-classes",
     *    inputWrapper: "input-wrapper-classes",
     *    input: "input-classes",
     *    segment: "segment-classes",
     *    helperWrapper: "helper-wrapper-classes",
     *    description: "description-classes",
     *    errorMessage: "error-message-classes",
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<DateInputSlots>;
}
type UseDateInputProps<T extends DateValue> = Props<T> & DateInputVariantProps & AriaDateFieldProps<T>;
declare function useDateInput<T extends DateValue>(originalProps: UseDateInputProps<T>): {
    state: _react_stately_datepicker.DateFieldState;
    domRef: react.RefObject<HTMLElement>;
    slots: {
        base: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        label: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        inputWrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        input: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        innerWrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        segment: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        helperWrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        description: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        errorMessage: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        label: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        inputWrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        input: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        innerWrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        segment: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        helperWrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        description: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        errorMessage: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    classNames: SlotsToClasses<"label" | "base" | "input" | "description" | "errorMessage" | "segment" | "helperWrapper" | "inputWrapper" | "innerWrapper"> | undefined;
    labelPlacement: "inside" | "outside" | "outside-left";
    getBaseGroupProps: () => DateInputGroupProps;
    getFieldProps: (props?: DOMAttributes) => GroupDOMAttributes;
    getInputProps: PropGetter;
};
type UseDateInputReturn = ReturnType<typeof useDateInput>;

export { type UseDateInputProps, type UseDateInputReturn, useDateInput };
