import * as tailwind_variants from 'tailwind-variants';
import * as react from 'react';
import * as _react_stately_datepicker from '@react-stately/datepicker';
import { DateInputVariantProps, SlotsToClasses, DateInputSlots } from '@heroui/theme';
import { TimeValue, AriaTimeFieldProps } from '@react-types/datepicker';
import { ReactRef } from '@heroui/react-utils';
import { DOMAttributes, GroupDOMAttributes } from '@react-types/shared';
import { DateInputGroupProps } from './date-input-group.mjs';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';

type HeroUIBaseProps<T extends TimeValue> = Omit<HTMLHeroUIProps<"div">, keyof AriaTimeFieldProps<T> | "onChange">;
interface Props<T extends TimeValue> extends HeroUIBaseProps<T> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLElement | null>;
    /** Props for the grouping element containing the date field and button. */
    groupProps?: GroupDOMAttributes;
    /** Props for the date picker's visible label element, if any. */
    labelProps?: DOMAttributes;
    /** Props for the date field. */
    fieldProps?: DOMAttributes;
    /** Props for the description element, if any. */
    descriptionProps?: DOMAttributes;
    /** Props for the error message element, if any. */
    errorMessageProps?: DOMAttributes;
    /**
     * The value of the hidden input.
     */
    inputRef?: ReactRef<HTMLInputElement | null>;
    /**
     * Element to be rendered in the left side of the input.
     */
    startContent?: React.ReactNode;
    /**
     * Element to be rendered in the right side of the input.
     */
    endContent?: React.ReactNode;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <DateInput classNames={{
     *    base:"base-classes",
     *    label: "label-classes",
     *    inputWrapper: "input-wrapper-classes",
     *    input: "input-classes",
     *    segment: "segment-classes",
     *    helperWrapper: "helper-wrapper-classes",
     *    description: "description-classes",
     *    errorMessage: "error-message-classes",
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<DateInputSlots>;
}
type UseTimeInputProps<T extends TimeValue> = Props<T> & DateInputVariantProps & AriaTimeFieldProps<T>;
declare function useTimeInput<T extends TimeValue>(originalProps: UseTimeInputProps<T>): {
    state: _react_stately_datepicker.TimeFieldState;
    domRef: react.RefObject<HTMLElement>;
    slots: {
        base: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        label: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        inputWrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        input: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        innerWrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        segment: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        helperWrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        description: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        errorMessage: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        label: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        inputWrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        input: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        innerWrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        segment: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        helperWrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        description: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        errorMessage: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            labelPlacement?: "inside" | "outside" | "outside-left" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            fullWidth?: boolean | undefined;
            variant?: "flat" | "bordered" | "faded" | "underlined" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    classNames: SlotsToClasses<"label" | "base" | "input" | "description" | "errorMessage" | "segment" | "helperWrapper" | "inputWrapper" | "innerWrapper"> | undefined;
    labelPlacement: "inside" | "outside" | "outside-left";
    getBaseGroupProps: () => DateInputGroupProps;
    getFieldProps: (props?: DOMAttributes) => GroupDOMAttributes;
    getInputProps: PropGetter;
};
type UseTimeInputReturn = ReturnType<typeof useTimeInput>;

export { type UseTimeInputProps, type UseTimeInputReturn, useTimeInput };
