"use client";
import {
  useDatePickerBase
} from "./chunk-BUD2USZP.mjs";

// src/use-date-picker.ts
import { useProviderContext } from "@heroui/system";
import { useMemo, useRef } from "react";
import { datePicker } from "@heroui/theme";
import { useDatePickerState } from "@react-stately/datepicker";
import { useDatePicker as useAriaDatePicker } from "@react-aria/datepicker";
import { clsx, dataAttr, objectToDeps } from "@heroui/shared-utils";
import { mergeProps } from "@react-aria/utils";
import { FormContext, useSlottedContext } from "@heroui/form";
import { ariaShouldCloseOnInteractOutside } from "@heroui/aria-utils";
function useDatePicker({
  className,
  classNames,
  ...originalProps
}) {
  var _a, _b, _c;
  const globalContext = useProviderContext();
  const { validationBehavior: formValidationBehavior } = useSlottedContext(FormContext) || {};
  const validationBehavior = (_c = (_b = (_a = originalProps.validationBehavior) != null ? _a : formValidationBehavior) != null ? _b : globalContext == null ? void 0 : globalContext.validationBehavior) != null ? _c : "native";
  const {
    domRef,
    startContent,
    endContent,
    selectorIcon,
    createCalendar,
    isCalendarHeaderExpanded,
    disableAnimation,
    CalendarTopContent,
    slotsProps,
    timeMinValue,
    timeMaxValue,
    CalendarBottomContent,
    dateInputProps,
    timeInputProps,
    popoverProps,
    calendarProps,
    variantProps,
    userTimeInputProps,
    selectorButtonProps,
    selectorIconProps,
    onClose
  } = useDatePickerBase({ ...originalProps, validationBehavior });
  let state = useDatePickerState({
    ...originalProps,
    validationBehavior,
    shouldCloseOnSelect: () => !state.hasTime,
    onOpenChange: (isOpen) => {
      if (!isOpen) {
        onClose();
      }
    }
  });
  const popoverTriggerRef = useRef(null);
  const baseStyles = clsx(classNames == null ? void 0 : classNames.base, className);
  const slots = useMemo(
    () => datePicker({
      ...variantProps,
      className
    }),
    [objectToDeps(variantProps), className]
  );
  let {
    groupProps,
    labelProps,
    fieldProps,
    buttonProps,
    dialogProps,
    calendarProps: ariaCalendarProps,
    descriptionProps,
    errorMessageProps
  } = useAriaDatePicker({ ...originalProps, validationBehavior }, state, domRef);
  originalProps.maxValue && "hour" in originalProps.maxValue ? originalProps.maxValue : null;
  const timeGranularity = state.granularity === "hour" || state.granularity === "minute" || state.granularity === "second" ? state.granularity : null;
  const showTimeField = !!timeGranularity;
  const getDateInputProps = () => {
    return {
      ...dateInputProps,
      classNames,
      groupProps,
      labelProps,
      createCalendar,
      errorMessageProps,
      descriptionProps,
      ...mergeProps(variantProps, fieldProps, {
        minValue: originalProps.minValue,
        maxValue: originalProps.maxValue,
        fullWidth: true,
        disableAnimation
      }),
      className: slots.base({ class: baseStyles }),
      innerWrapperProps: {
        ref: popoverTriggerRef
      },
      "data-open": dataAttr(state.isOpen)
    };
  };
  const getTimeInputProps = () => {
    var _a2, _b2;
    if (!showTimeField) return {};
    return {
      ...timeInputProps,
      value: state.timeValue,
      onChange: state.setTimeValue,
      granularity: timeGranularity,
      minValue: timeMinValue != null ? timeMinValue : void 0,
      maxValue: timeMaxValue != null ? timeMaxValue : void 0,
      classNames: {
        base: slots.timeInput({
          class: clsx(classNames == null ? void 0 : classNames.timeInput, (_a2 = userTimeInputProps == null ? void 0 : userTimeInputProps.classNames) == null ? void 0 : _a2.base)
        }),
        label: slots.timeInputLabel({
          class: clsx(classNames == null ? void 0 : classNames.timeInputLabel, (_b2 = userTimeInputProps == null ? void 0 : userTimeInputProps.classNames) == null ? void 0 : _b2.label)
        })
      }
    };
  };
  const getPopoverProps = (props = {}) => {
    var _a2, _b2;
    return {
      state,
      dialogProps,
      ...popoverProps,
      triggerRef: popoverTriggerRef,
      classNames: {
        content: slots.popoverContent({
          class: clsx(
            classNames == null ? void 0 : classNames.popoverContent,
            (_b2 = (_a2 = slotsProps.popoverProps) == null ? void 0 : _a2.classNames) == null ? void 0 : _b2["content"],
            props.className
          )
        })
      },
      shouldCloseOnInteractOutside: (popoverProps == null ? void 0 : popoverProps.shouldCloseOnInteractOutside) ? popoverProps.shouldCloseOnInteractOutside : (element) => ariaShouldCloseOnInteractOutside(element, popoverTriggerRef, state)
    };
  };
  const getCalendarProps = () => {
    var _a2, _b2;
    return {
      ...ariaCalendarProps,
      ...calendarProps,
      classNames: {
        ...calendarProps.classNames,
        base: slots.calendar({ class: clsx(classNames == null ? void 0 : classNames.base, (_a2 = calendarProps.classNames) == null ? void 0 : _a2.base) }),
        content: slots.calendarContent({
          class: clsx(classNames == null ? void 0 : classNames.calendarContent, (_b2 = calendarProps.classNames) == null ? void 0 : _b2.content)
        })
      }
    };
  };
  const getSelectorButtonProps = () => {
    return {
      ...buttonProps,
      ...selectorButtonProps,
      onPress: state.toggle,
      className: slots.selectorButton({ class: classNames == null ? void 0 : classNames.selectorButton })
    };
  };
  const getSelectorIconProps = () => {
    return {
      ...selectorIconProps,
      className: slots.selectorIcon({ class: classNames == null ? void 0 : classNames.selectorIcon })
    };
  };
  return {
    state,
    startContent,
    endContent,
    selectorIcon,
    showTimeField,
    isCalendarHeaderExpanded,
    disableAnimation,
    CalendarTopContent,
    CalendarBottomContent,
    getDateInputProps,
    getPopoverProps,
    getSelectorButtonProps,
    getCalendarProps,
    getTimeInputProps,
    getSelectorIconProps
  };
}

export {
  useDatePicker
};
