import { DateValue } from '@internationalized/date';
import { ReactElement } from 'react';
import { UseDatePickerProps } from './use-date-picker.mjs';
import '@heroui/date-input';
import '@react-stately/datepicker';
import '@heroui/button';
import '@heroui/calendar';
import '@heroui/popover';
import './use-date-picker-base.mjs';
import '@heroui/system';
import '@react-types/datepicker';
import '@react-types/shared';
import '@heroui/theme';
import '@react-aria/datepicker';

interface Props<T extends DateValue> extends UseDatePickerProps<T> {
    /**
     * The placement of the selector button.
     * @default "end"
     */
    selectorButtonPlacement?: "start" | "end";
}
type DatePickerProps<T extends DateValue = DateValue> = Props<T>;
declare const DatePicker: <T extends DateValue>(props: DatePickerProps<T>) => ReactElement;

export { type DatePickerProps, type Props, DatePicker as default };
