import * as _heroui_system_rsc from '@heroui/system-rsc';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system-rsc';
import { DividerVariantProps } from '@heroui/theme';
import { Ref } from 'react';
import { SeparatorProps } from './use-separator.mjs';
import '@react-types/shared';

interface Props extends HTMLHeroUIProps<"hr"> {
    /**
     * Ref to the DOM node.
     */
    ref?: Ref<HTMLElement> | undefined;
}
type UseDividerProps = Props & DividerVariantProps & Omit<SeparatorProps, "elementType">;
declare function useDivider(props: UseDividerProps): {
    Component: _heroui_system_rsc.As<any>;
    getDividerProps: PropGetter;
};
type UseDividerReturn = ReturnType<typeof useDivider>;

export { type UseDividerProps, type UseDividerReturn, useDivider };
