"use client";
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/drawer.tsx
var drawer_exports = {};
__export(drawer_exports, {
  default: () => drawer_default
});
module.exports = __toCommonJS(drawer_exports);
var import_system = require("@heroui/system");
var import_modal = require("@heroui/modal");

// src/use-drawer.ts
var import_theme = require("@heroui/theme");
var import_react_utils = require("@heroui/react-utils");
var import_react = require("react");
var import_framer_utils = require("@heroui/framer-utils");
var import_shared_utils = require("@heroui/shared-utils");
function useDrawer(originalProps) {
  const {
    ref,
    className,
    classNames,
    placement = "right",
    scrollBehavior = "inside",
    size = "md",
    motionProps: drawerMotionProps,
    ...otherProps
  } = originalProps;
  const domRef = (0, import_react_utils.useDOMRef)(ref);
  const motionProps = (0, import_react.useMemo)(() => {
    if (!(0, import_shared_utils.isEmpty)(drawerMotionProps)) return drawerMotionProps;
    const key = placement === "left" || placement === "right" ? "x" : "y";
    return {
      variants: {
        enter: {
          [key]: 0,
          transition: {
            [key]: {
              duration: 0.2,
              ease: import_framer_utils.TRANSITION_EASINGS.easeOut
            }
          }
        },
        exit: {
          [key]: placement === "top" || placement === "left" ? "-100%" : "100%",
          transition: {
            [key]: {
              duration: 0.1,
              ease: import_framer_utils.TRANSITION_EASINGS.easeIn
            }
          }
        }
      }
    };
  }, [placement, drawerMotionProps]);
  const baseStyles = (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.base, className);
  const slots = (0, import_react.useMemo)(
    () => (0, import_theme.drawer)({
      size,
      placement
    }),
    [size, placement]
  );
  const getModalProps = (0, import_react.useCallback)(() => {
    return {
      classNames: {
        ...classNames,
        base: slots.base({ class: baseStyles })
      },
      motionProps,
      scrollBehavior,
      size,
      ...otherProps
    };
  }, [baseStyles, classNames, motionProps, scrollBehavior, size, otherProps]);
  return { domRef, getModalProps };
}

// src/drawer.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var Drawer = (0, import_system.forwardRef)(({ children, ...props }, ref) => {
  const { domRef, getModalProps } = useDrawer({ ...props, ref });
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_modal.Modal, { ref: domRef, ...getModalProps(), children });
});
Drawer.displayName = "HeroUI.Drawer";
var drawer_default = Drawer;
