import * as tailwind_variants from 'tailwind-variants';
import * as react from 'react';
import { ImgHTMLAttributes } from 'react';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { ImageVariantProps, SlotsToClasses, ImageSlots } from '@heroui/theme';
import { ReactRef } from '@heroui/react-utils';

type NativeImageProps = ImgHTMLAttributes<HTMLImageElement>;
interface Props extends HTMLHeroUIProps<"img"> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLImageElement | null>;
    /**
     * Whether to add a blurred effect to the image.
     * @default false
     */
    isBlurred?: boolean;
    /**
     * A fallback image.
     */
    fallbackSrc?: React.ReactNode;
    /**
     * Whether to disable the loading skeleton.
     * @default false
     */
    disableSkeleton?: boolean;
    /**
     * A callback for when the image `src` has been loaded
     */
    onLoad?: NativeImageProps["onLoad"];
    /**
     * A loading strategy to use for the image.
     */
    loading?: NativeImageProps["loading"];
    /**
     * Whether to remove the wrapper element. This will cause the image to be rendered as a direct child of the parent element.
     * If you set this prop as `true` neither the skeleton nor the zoom effect will work.
     * @default false
     */
    removeWrapper?: boolean;
    /**
     * Controlled loading state.
     */
    isLoading?: boolean;
    /**
     * Function called when image failed to load
     */
    onError?: () => void;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <Image classNames={{
     *    base:"base-classes", // image classes
     *    wrapper: "wrapper-classes",
     *    blurredImg: "blurredImg-classes", // this is a cloned version of the img
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<ImageSlots>;
}
type UseImageProps = Props & ImageVariantProps;
declare function useImage(originalProps: UseImageProps): {
    Component: _heroui_system.As<any>;
    domRef: react.RefObject<HTMLImageElement>;
    slots: {
        wrapper: (slotProps?: ({
            radius?: "lg" | "none" | "full" | "sm" | "md" | undefined;
            shadow?: "lg" | "none" | "sm" | "md" | undefined;
            isZoomed?: boolean | undefined;
            showSkeleton?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        zoomedWrapper: (slotProps?: ({
            radius?: "lg" | "none" | "full" | "sm" | "md" | undefined;
            shadow?: "lg" | "none" | "sm" | "md" | undefined;
            isZoomed?: boolean | undefined;
            showSkeleton?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        img: (slotProps?: ({
            radius?: "lg" | "none" | "full" | "sm" | "md" | undefined;
            shadow?: "lg" | "none" | "sm" | "md" | undefined;
            isZoomed?: boolean | undefined;
            showSkeleton?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        blurredImg: (slotProps?: ({
            radius?: "lg" | "none" | "full" | "sm" | "md" | undefined;
            shadow?: "lg" | "none" | "sm" | "md" | undefined;
            isZoomed?: boolean | undefined;
            showSkeleton?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        wrapper: (slotProps?: ({
            radius?: "lg" | "none" | "full" | "sm" | "md" | undefined;
            shadow?: "lg" | "none" | "sm" | "md" | undefined;
            isZoomed?: boolean | undefined;
            showSkeleton?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        zoomedWrapper: (slotProps?: ({
            radius?: "lg" | "none" | "full" | "sm" | "md" | undefined;
            shadow?: "lg" | "none" | "sm" | "md" | undefined;
            isZoomed?: boolean | undefined;
            showSkeleton?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        img: (slotProps?: ({
            radius?: "lg" | "none" | "full" | "sm" | "md" | undefined;
            shadow?: "lg" | "none" | "sm" | "md" | undefined;
            isZoomed?: boolean | undefined;
            showSkeleton?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        blurredImg: (slotProps?: ({
            radius?: "lg" | "none" | "full" | "sm" | "md" | undefined;
            shadow?: "lg" | "none" | "sm" | "md" | undefined;
            isZoomed?: boolean | undefined;
            showSkeleton?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    classNames: SlotsToClasses<"wrapper" | "zoomedWrapper" | "img" | "blurredImg"> | undefined;
    isBlurred: boolean | undefined;
    disableSkeleton: boolean;
    fallbackSrc: react.ReactNode;
    removeWrapper: boolean;
    isZoomed: boolean | undefined;
    isLoading: boolean | undefined;
    getImgProps: PropGetter;
    getWrapperProps: PropGetter;
    getBlurredImgProps: PropGetter;
};
type UseImageReturn = ReturnType<typeof useImage>;

export { type UseImageProps, type UseImageReturn, useImage };
