import * as react from 'react';
import * as tailwind_variants from 'tailwind-variants';
import * as _heroui_system_rsc from '@heroui/system-rsc';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system-rsc';
import { KbdVariantProps, SlotsToClasses, KbdSlots } from '@heroui/theme';
import { ReactRef } from '@heroui/react-utils';
import { KbdKey } from './utils.mjs';

interface Props extends HTMLHeroUIProps<"kbd"> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLElement | null>;
    /**
     * The key or keys to be displayed.
     */
    keys?: KbdKey | KbdKey[];
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <Kbd classNames={{
     *    base:"base-classes",
     *    abbr: "abbr-classes", // the key wrapper
     *    content: "content-classes", // the children wrapper
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<KbdSlots>;
}
type UseKbdProps = Props & KbdVariantProps;
declare function useKbd(originalProps: UseKbdProps): {
    Component: _heroui_system_rsc.As<any>;
    slots: {
        base: (slotProps?: ({} & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        abbr: (slotProps?: ({} & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({} & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({} & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        abbr: (slotProps?: ({} & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({} & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    classNames: SlotsToClasses<"abbr" | "base" | "content"> | undefined;
    title: string | undefined;
    children: react.ReactNode;
    keysToRender: KbdKey[];
    getKbdProps: PropGetter;
};
type UseKbdReturn = ReturnType<typeof useKbd>;

export { type UseKbdProps, type UseKbdReturn, useKbd };
