"use client";
import {
  useListbox
} from "./chunk-MZOWMNSQ.mjs";
import {
  virtualized_listbox_default
} from "./chunk-KFUAPEJM.mjs";
import {
  listbox_section_default
} from "./chunk-HFV4GF3Z.mjs";
import {
  listbox_item_default
} from "./chunk-SDA7RI74.mjs";

// src/listbox.tsx
import { forwardRef } from "@heroui/system";
import { mergeProps } from "@react-aria/utils";
import { jsx, jsxs } from "react/jsx-runtime";
var Listbox = forwardRef(function Listbox2(props, ref) {
  const { isVirtualized, ...restProps } = props;
  const useListboxProps = useListbox({ ...restProps, ref });
  const {
    Component,
    state,
    color,
    variant,
    itemClasses,
    getBaseProps,
    topContent,
    bottomContent,
    hideEmptyContent,
    hideSelectedIcon,
    shouldHighlightOnFocus,
    disableAnimation,
    getEmptyContentProps,
    getListProps
  } = useListboxProps;
  if (isVirtualized) {
    return /* @__PURE__ */ jsx(virtualized_listbox_default, { ...props, ...useListboxProps });
  }
  const content = /* @__PURE__ */ jsxs(Component, { ...getListProps(), children: [
    !state.collection.size && !hideEmptyContent && /* @__PURE__ */ jsx("li", { children: /* @__PURE__ */ jsx("div", { ...getEmptyContentProps() }) }),
    [...state.collection].map((item) => {
      var _a;
      const itemProps = {
        color,
        item,
        state,
        variant,
        disableAnimation,
        hideSelectedIcon,
        ...item.props
      };
      if (item.type === "section") {
        return /* @__PURE__ */ jsx(listbox_section_default, { ...itemProps, itemClasses }, item.key);
      }
      let listboxItem = /* @__PURE__ */ jsx(
        listbox_item_default,
        {
          ...itemProps,
          classNames: mergeProps(itemClasses, (_a = item.props) == null ? void 0 : _a.classNames),
          shouldHighlightOnFocus
        },
        item.key
      );
      if (item.wrapper) {
        listboxItem = item.wrapper(listboxItem);
      }
      return listboxItem;
    })
  ] });
  return /* @__PURE__ */ jsxs("div", { ...getBaseProps(), children: [
    topContent,
    content,
    bottomContent
  ] });
});
var listbox_default = Listbox;

export {
  listbox_default
};
