import * as _heroui_system from '@heroui/system';
import { Node } from '@react-types/shared';
import { ListState } from '@react-stately/list';
import { ListboxItemProps } from './listbox-item.mjs';
import { ListboxSectionBaseProps } from './base/listbox-section-base.mjs';
import 'react/jsx-runtime';
import './use-listbox-item.mjs';
import './base/listbox-item-base.mjs';
import '@heroui/theme';
import '@react-aria/listbox';
import '@heroui/aria-utils';
import 'react';
import 'tailwind-variants';
import '@heroui/divider';

interface ListboxSectionProps<T extends object = object> extends ListboxSectionBaseProps {
    item: Node<T>;
    state: ListState<T>;
    /**
     * The listbox items variant.
     */
    variant?: ListboxItemProps["variant"];
    /**
     * The listbox items color.
     */
    color?: ListboxItemProps["color"];
    /**
     * Whether to disable the items animation.
     * @default false
     */
    disableAnimation?: boolean;
}
/**
 * @internal
 */
declare const ListboxSection: _heroui_system.InternalForwardRefRenderFunction<"li", ListboxSectionProps<object>, never>;

export { type ListboxSectionProps, ListboxSection as default };
