import { MenuItemSelectedIconProps, MenuItemBaseProps } from './base/menu-item-base.js';
import * as _heroui_theme from '@heroui/theme';
import { MenuItemVariantProps } from '@heroui/theme';
import * as tailwind_variants from 'tailwind-variants';
import * as react from 'react';
import * as _heroui_system from '@heroui/system';
import { HTMLHeroUIProps, PropGetter } from '@heroui/system';
import { Node } from '@react-types/shared';
import { TreeState } from '@react-stately/tree';
import '@react-aria/menu';
import '@heroui/aria-utils';

interface Props<T extends object> extends MenuItemBaseProps<T> {
    item: Node<T>;
    state: TreeState<T>;
}
type UseMenuItemProps<T extends object> = Props<T> & Omit<HTMLHeroUIProps<"li">, keyof Props<T>> & MenuItemVariantProps;
declare function useMenuItem<T extends object>(originalProps: UseMenuItemProps<T>): {
    Component: _heroui_system.As<any>;
    domRef: react.RefObject<HTMLLIElement>;
    slots: {
        base: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
            variant?: "flat" | "shadow" | "solid" | "bordered" | "faded" | "light" | undefined;
            showDivider?: boolean | undefined;
            hasTitleTextChild?: boolean | undefined;
            hasDescriptionTextChild?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        wrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
            variant?: "flat" | "shadow" | "solid" | "bordered" | "faded" | "light" | undefined;
            showDivider?: boolean | undefined;
            hasTitleTextChild?: boolean | undefined;
            hasDescriptionTextChild?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        title: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
            variant?: "flat" | "shadow" | "solid" | "bordered" | "faded" | "light" | undefined;
            showDivider?: boolean | undefined;
            hasTitleTextChild?: boolean | undefined;
            hasDescriptionTextChild?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        description: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
            variant?: "flat" | "shadow" | "solid" | "bordered" | "faded" | "light" | undefined;
            showDivider?: boolean | undefined;
            hasTitleTextChild?: boolean | undefined;
            hasDescriptionTextChild?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        selectedIcon: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
            variant?: "flat" | "shadow" | "solid" | "bordered" | "faded" | "light" | undefined;
            showDivider?: boolean | undefined;
            hasTitleTextChild?: boolean | undefined;
            hasDescriptionTextChild?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        shortcut: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
            variant?: "flat" | "shadow" | "solid" | "bordered" | "faded" | "light" | undefined;
            showDivider?: boolean | undefined;
            hasTitleTextChild?: boolean | undefined;
            hasDescriptionTextChild?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
            variant?: "flat" | "shadow" | "solid" | "bordered" | "faded" | "light" | undefined;
            showDivider?: boolean | undefined;
            hasTitleTextChild?: boolean | undefined;
            hasDescriptionTextChild?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        wrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
            variant?: "flat" | "shadow" | "solid" | "bordered" | "faded" | "light" | undefined;
            showDivider?: boolean | undefined;
            hasTitleTextChild?: boolean | undefined;
            hasDescriptionTextChild?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        title: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
            variant?: "flat" | "shadow" | "solid" | "bordered" | "faded" | "light" | undefined;
            showDivider?: boolean | undefined;
            hasTitleTextChild?: boolean | undefined;
            hasDescriptionTextChild?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        description: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
            variant?: "flat" | "shadow" | "solid" | "bordered" | "faded" | "light" | undefined;
            showDivider?: boolean | undefined;
            hasTitleTextChild?: boolean | undefined;
            hasDescriptionTextChild?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        selectedIcon: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
            variant?: "flat" | "shadow" | "solid" | "bordered" | "faded" | "light" | undefined;
            showDivider?: boolean | undefined;
            hasTitleTextChild?: boolean | undefined;
            hasDescriptionTextChild?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        shortcut: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            disableAnimation?: boolean | undefined;
            isDisabled?: boolean | undefined;
            variant?: "flat" | "shadow" | "solid" | "bordered" | "faded" | "light" | undefined;
            showDivider?: boolean | undefined;
            hasTitleTextChild?: boolean | undefined;
            hasDescriptionTextChild?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    classNames: _heroui_theme.SlotsToClasses<"base" | "title" | "description" | "wrapper" | "selectedIcon" | "shortcut"> | undefined;
    isSelectable: boolean;
    isSelected: boolean;
    isDisabled: boolean;
    rendered: react.ReactNode;
    shortcut: react.ReactNode;
    description: react.ReactNode;
    startContent: react.ReactNode;
    endContent: react.ReactNode;
    selectedIcon: react.ReactNode | ((props: MenuItemSelectedIconProps) => react.ReactNode);
    disableAnimation: boolean;
    getItemProps: PropGetter;
    getLabelProps: PropGetter;
    hideSelectedIcon: boolean;
    getDescriptionProps: PropGetter;
    getKeyboardShortcutProps: PropGetter;
    getSelectedIconProps: PropGetter;
};
type UseMenuReturn = ReturnType<typeof useMenuItem>;

export { type UseMenuItemProps, type UseMenuReturn, useMenuItem };
