"use client";
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/modal-content.tsx
var modal_content_exports = {};
__export(modal_content_exports, {
  default: () => modal_content_default
});
module.exports = __toCommonJS(modal_content_exports);
var import_react = require("react");
var import_overlays = require("@react-aria/overlays");
var import_framer_utils2 = require("@heroui/framer-utils");
var import_shared_icons = require("@heroui/shared-icons");
var import_framer_motion = require("framer-motion");
var import_dialog = require("@react-aria/dialog");
var import_utils = require("@react-aria/utils");

// src/modal-context.ts
var import_react_utils = require("@heroui/react-utils");
var [ModalProvider, useModalContext] = (0, import_react_utils.createContext)({
  name: "ModalContext",
  errorMessage: "useModalContext: `context` is undefined. Seems you forgot to wrap all popover components within `<Modal />`"
});

// src/modal-transition.ts
var import_framer_utils = require("@heroui/framer-utils");
var scaleInOut = {
  enter: {
    scale: "var(--scale-enter)",
    y: "var(--slide-enter)",
    opacity: 1,
    willChange: "auto",
    transition: {
      scale: {
        duration: 0.4,
        ease: import_framer_utils.TRANSITION_EASINGS.ease
      },
      opacity: {
        duration: 0.4,
        ease: import_framer_utils.TRANSITION_EASINGS.ease
      },
      y: {
        type: "spring",
        bounce: 0,
        duration: 0.6
      }
    }
  },
  exit: {
    scale: "var(--scale-exit)",
    y: "var(--slide-exit)",
    opacity: 0,
    willChange: "transform",
    transition: {
      duration: 0.3,
      ease: import_framer_utils.TRANSITION_EASINGS.ease
    }
  }
};

// src/modal-content.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var domAnimation = () => import("@heroui/dom-animation").then((res) => res.default);
var ModalContent = (props) => {
  const { as, children, role = "dialog", ...otherProps } = props;
  const {
    Component: DialogComponent,
    domRef,
    slots,
    classNames,
    motionProps,
    backdrop,
    closeButton,
    hideCloseButton,
    disableAnimation,
    getDialogProps,
    getBackdropProps,
    getCloseButtonProps,
    onClose
  } = useModalContext();
  const Component = as || DialogComponent || "div";
  const viewport = (0, import_utils.useViewportSize)();
  const { dialogProps } = (0, import_dialog.useDialog)(
    {
      role
    },
    domRef
  );
  const closeButtonContent = (0, import_react.isValidElement)(closeButton) ? (0, import_react.cloneElement)(closeButton, getCloseButtonProps()) : /* @__PURE__ */ (0, import_jsx_runtime.jsx)("button", { ...getCloseButtonProps(), children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_shared_icons.CloseIcon, {}) });
  const onKeyDown = (0, import_react.useCallback)((e) => {
    if (e.key === "Tab" && e.nativeEvent.isComposing) {
      e.stopPropagation();
      e.preventDefault();
    }
  }, []);
  const contentProps = getDialogProps((0, import_utils.mergeProps)(dialogProps, otherProps));
  const content = /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(Component, { ...contentProps, onKeyDown: (0, import_utils.chain)(contentProps.onKeyDown, onKeyDown), children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_overlays.DismissButton, { onDismiss: onClose }),
    !hideCloseButton && closeButtonContent,
    typeof children === "function" ? children(onClose) : children,
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_overlays.DismissButton, { onDismiss: onClose })
  ] });
  const backdropContent = (0, import_react.useMemo)(() => {
    if (backdrop === "transparent") {
      return null;
    }
    if (disableAnimation) {
      return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { ...getBackdropProps() });
    }
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_framer_motion.LazyMotion, { features: domAnimation, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_framer_motion.m.div,
      {
        animate: "enter",
        exit: "exit",
        initial: "exit",
        variants: import_framer_utils2.TRANSITION_VARIANTS.fade,
        ...getBackdropProps()
      }
    ) });
  }, [backdrop, disableAnimation, getBackdropProps]);
  const viewportStyle = {
    "--visual-viewport-height": viewport.height + "px"
  };
  const contents = disableAnimation ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    "div",
    {
      className: slots.wrapper({ class: classNames == null ? void 0 : classNames.wrapper }),
      "data-slot": "wrapper",
      style: viewportStyle,
      children: content
    }
  ) : /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_framer_motion.LazyMotion, { features: domAnimation, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_framer_motion.m.div,
    {
      animate: "enter",
      className: slots.wrapper({ class: classNames == null ? void 0 : classNames.wrapper }),
      "data-slot": "wrapper",
      exit: "exit",
      initial: "exit",
      variants: scaleInOut,
      ...motionProps,
      style: viewportStyle,
      children: content
    }
  ) });
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { tabIndex: -1, children: [
    backdropContent,
    contents
  ] });
};
ModalContent.displayName = "HeroUI.ModalContent";
var modal_content_default = ModalContent;
