"use client";
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  Navbar: () => navbar_default,
  NavbarBrand: () => navbar_brand_default,
  NavbarContent: () => navbar_content_default,
  NavbarItem: () => navbar_item_default,
  NavbarMenu: () => navbar_menu_default,
  NavbarMenuItem: () => navbar_menu_item_default,
  NavbarMenuToggle: () => navbar_menu_toggle_default,
  NavbarProvider: () => NavbarProvider,
  useNavbar: () => useNavbar,
  useNavbarContext: () => useNavbarContext
});
module.exports = __toCommonJS(index_exports);

// src/use-navbar.ts
var import_system = require("@heroui/system");
var import_theme = require("@heroui/theme");
var import_react_utils = require("@heroui/react-utils");
var import_shared_utils = require("@heroui/shared-utils");
var import_react = require("react");
var import_utils = require("@react-aria/utils");
var import_use_scroll_position = require("@heroui/use-scroll-position");
var import_utils2 = require("@react-stately/utils");
var import_overlays = require("@react-aria/overlays");
function useNavbar(originalProps) {
  var _a, _b;
  const globalContext = (0, import_system.useProviderContext)();
  const [props, variantProps] = (0, import_system.mapPropsVariants)(originalProps, import_theme.navbar.variantKeys);
  const {
    ref,
    as,
    parentRef,
    height = "4rem",
    shouldHideOnScroll = false,
    disableScrollHandler = false,
    shouldBlockScroll = true,
    onScrollPositionChange,
    isMenuOpen: isMenuOpenProp,
    isMenuDefaultOpen,
    onMenuOpenChange = () => {
    },
    motionProps,
    className,
    classNames,
    ...otherProps
  } = props;
  const Component = as || "nav";
  const disableAnimation = (_b = (_a = originalProps.disableAnimation) != null ? _a : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _b : false;
  const domRef = (0, import_react_utils.useDOMRef)(ref);
  const prevWidth = (0, import_react.useRef)(0);
  const navHeight = (0, import_react.useRef)(0);
  const [isHidden, setIsHidden] = (0, import_react.useState)(false);
  const handleMenuOpenChange = (0, import_react.useCallback)(
    (isOpen) => {
      onMenuOpenChange(isOpen || false);
    },
    [onMenuOpenChange]
  );
  const [isMenuOpen, setIsMenuOpen] = (0, import_utils2.useControlledState)(
    isMenuOpenProp,
    isMenuDefaultOpen != null ? isMenuDefaultOpen : false,
    handleMenuOpenChange
  );
  const updateWidth = () => {
    if (domRef.current) {
      const width = domRef.current.offsetWidth;
      if (width !== prevWidth.current) {
        prevWidth.current = width;
      }
    }
  };
  (0, import_overlays.usePreventScroll)({
    isDisabled: !(shouldBlockScroll && isMenuOpen)
  });
  (0, import_utils.useResizeObserver)({
    ref: domRef,
    onResize: () => {
      var _a2;
      const currentWidth = (_a2 = domRef.current) == null ? void 0 : _a2.offsetWidth;
      const scrollWidth = window.innerWidth - document.documentElement.clientWidth;
      if (currentWidth && currentWidth + scrollWidth == prevWidth.current) {
        return;
      }
      if (currentWidth !== prevWidth.current) {
        updateWidth();
        setIsMenuOpen(false);
      }
    }
  });
  (0, import_react.useEffect)(() => {
    var _a2;
    updateWidth();
    navHeight.current = ((_a2 = domRef.current) == null ? void 0 : _a2.offsetHeight) || 0;
  }, []);
  const slots = (0, import_react.useMemo)(
    () => (0, import_theme.navbar)({
      ...variantProps,
      disableAnimation,
      hideOnScroll: shouldHideOnScroll
    }),
    [(0, import_shared_utils.objectToDeps)(variantProps), disableAnimation, shouldHideOnScroll]
  );
  const baseStyles = (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.base, className);
  (0, import_use_scroll_position.useScrollPosition)({
    elementRef: parentRef,
    isEnabled: shouldHideOnScroll || !disableScrollHandler,
    callback: ({ prevPos, currPos }) => {
      onScrollPositionChange == null ? void 0 : onScrollPositionChange(currPos.y);
      if (shouldHideOnScroll) {
        setIsHidden((prev) => {
          const next = currPos.y > prevPos.y && currPos.y > navHeight.current;
          return next !== prev ? next : prev;
        });
      }
    }
  });
  const getBaseProps = (props2 = {}) => ({
    ...(0, import_utils.mergeProps)(otherProps, props2),
    "data-hidden": (0, import_shared_utils.dataAttr)(isHidden),
    "data-menu-open": (0, import_shared_utils.dataAttr)(isMenuOpen),
    ref: domRef,
    className: slots.base({ class: (0, import_shared_utils.clsx)(baseStyles, props2 == null ? void 0 : props2.className) }),
    style: {
      "--navbar-height": typeof height === "number" ? `${height}px` : height,
      ...otherProps == null ? void 0 : otherProps.style,
      ...props2 == null ? void 0 : props2.style
    }
  });
  const getWrapperProps = (props2 = {}) => ({
    ...props2,
    "data-menu-open": (0, import_shared_utils.dataAttr)(isMenuOpen),
    className: slots.wrapper({ class: (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.wrapper, props2 == null ? void 0 : props2.className) })
  });
  return {
    Component,
    slots,
    domRef,
    height,
    isHidden,
    disableAnimation,
    shouldHideOnScroll,
    isMenuOpen,
    classNames,
    setIsMenuOpen,
    motionProps,
    getBaseProps,
    getWrapperProps
  };
}

// src/navbar-context.ts
var import_react_utils2 = require("@heroui/react-utils");
var [NavbarProvider, useNavbarContext] = (0, import_react_utils2.createContext)({
  name: "NavbarContext",
  strict: true,
  errorMessage: "useNavbarContext: `context` is undefined. Seems you forgot to wrap component within <Navbar />"
});

// src/navbar.tsx
var import_system3 = require("@heroui/system");
var import_react_utils4 = require("@heroui/react-utils");
var import_framer_motion2 = require("framer-motion");
var import_utils4 = require("@react-aria/utils");

// src/navbar-transitions.ts
var import_framer_utils = require("@heroui/framer-utils");
var hideOnScrollVariants = {
  visible: {
    y: 0,
    transition: {
      ease: import_framer_utils.TRANSITION_EASINGS.easeOut
    }
  },
  hidden: {
    y: "-100%",
    transition: {
      ease: import_framer_utils.TRANSITION_EASINGS.easeIn
    }
  }
};

// src/navbar-menu.tsx
var import_system2 = require("@heroui/system");
var import_react_utils3 = require("@heroui/react-utils");
var import_shared_utils2 = require("@heroui/shared-utils");
var import_framer_motion = require("framer-motion");
var import_utils3 = require("@react-aria/utils");
var import_overlays2 = require("@react-aria/overlays");

// src/navbar-menu-transitions.ts
var menuVariants = {
  enter: {
    height: "calc(100vh - var(--navbar-height))",
    transition: {
      duration: 0.3,
      easings: "easeOut"
    }
  },
  exit: {
    height: 0,
    transition: {
      duration: 0.25,
      easings: "easeIn"
    }
  }
};

// src/navbar-menu.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var domAnimation = () => import("@heroui/dom-animation").then((res) => res.default);
var NavbarMenu = (0, import_system2.forwardRef)((props, ref) => {
  var _a, _b;
  const { className, children, portalContainer, motionProps, style, ...otherProps } = props;
  const domRef = (0, import_react_utils3.useDOMRef)(ref);
  const { slots, isMenuOpen, height, disableAnimation, classNames } = useNavbarContext();
  const styles = (0, import_shared_utils2.clsx)(classNames == null ? void 0 : classNames.menu, className);
  if (disableAnimation) {
    if (!isMenuOpen) return null;
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_overlays2.Overlay, { portalContainer, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      "ul",
      {
        ref: domRef,
        className: (_a = slots.menu) == null ? void 0 : _a.call(slots, { class: styles }),
        "data-open": (0, import_shared_utils2.dataAttr)(isMenuOpen),
        style: {
          // @ts-expect-error
          "--navbar-height": typeof height === "number" ? `${height}px` : height
        },
        ...otherProps,
        children
      }
    ) });
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_framer_motion.AnimatePresence, { mode: "wait", children: isMenuOpen ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_overlays2.Overlay, { portalContainer, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_framer_motion.LazyMotion, { features: domAnimation, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_framer_motion.m.ul,
    {
      ref: domRef,
      layoutScroll: true,
      animate: "enter",
      className: (_b = slots.menu) == null ? void 0 : _b.call(slots, { class: styles }),
      "data-open": (0, import_shared_utils2.dataAttr)(isMenuOpen),
      exit: "exit",
      initial: "exit",
      style: {
        // @ts-expect-error
        "--navbar-height": typeof height === "number" ? `${height}px` : height,
        ...style
      },
      variants: menuVariants,
      ...(0, import_utils3.mergeProps)(motionProps, otherProps),
      children
    }
  ) }) }) : null });
});
NavbarMenu.displayName = "HeroUI.NavbarMenu";
var navbar_menu_default = NavbarMenu;

// src/navbar.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var domAnimation2 = () => import("@heroui/dom-animation").then((res) => res.default);
var Navbar = (0, import_system3.forwardRef)((props, ref) => {
  const { children, ...otherProps } = props;
  const context = useNavbar({ ...otherProps, ref });
  const Component = context.Component;
  const [childrenWithoutMenu, menu] = (0, import_react_utils4.pickChildren)(children, navbar_menu_default);
  const content = /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_jsx_runtime2.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("header", { ...context.getWrapperProps(), children: childrenWithoutMenu }),
    menu
  ] });
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(NavbarProvider, { value: context, children: context.shouldHideOnScroll ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_framer_motion2.LazyMotion, { features: domAnimation2, children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    import_framer_motion2.m.nav,
    {
      animate: context.isHidden ? "hidden" : "visible",
      initial: false,
      variants: hideOnScrollVariants,
      ...(0, import_utils4.mergeProps)(context.getBaseProps(), context.motionProps),
      children: content
    }
  ) }) : /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(Component, { ...context.getBaseProps(), children: content }) });
});
Navbar.displayName = "HeroUI.Navbar";
var navbar_default = Navbar;

// src/navbar-brand.tsx
var import_system4 = require("@heroui/system");
var import_react_utils5 = require("@heroui/react-utils");
var import_shared_utils3 = require("@heroui/shared-utils");
var import_jsx_runtime3 = require("react/jsx-runtime");
var NavbarBrand = (0, import_system4.forwardRef)((props, ref) => {
  var _a;
  const { as, className, children, ...otherProps } = props;
  const Component = as || "div";
  const domRef = (0, import_react_utils5.useDOMRef)(ref);
  const { slots, classNames } = useNavbarContext();
  const styles = (0, import_shared_utils3.clsx)(classNames == null ? void 0 : classNames.brand, className);
  return /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(Component, { ref: domRef, className: (_a = slots.brand) == null ? void 0 : _a.call(slots, { class: styles }), ...otherProps, children });
});
NavbarBrand.displayName = "HeroUI.NavbarBrand";
var navbar_brand_default = NavbarBrand;

// src/navbar-content.tsx
var import_system5 = require("@heroui/system");
var import_react_utils6 = require("@heroui/react-utils");
var import_shared_utils4 = require("@heroui/shared-utils");
var import_jsx_runtime4 = require("react/jsx-runtime");
var NavbarContent = (0, import_system5.forwardRef)((props, ref) => {
  var _a;
  const { as, className, children, justify = "start", ...otherProps } = props;
  const Component = as || "ul";
  const domRef = (0, import_react_utils6.useDOMRef)(ref);
  const { slots, classNames } = useNavbarContext();
  const styles = (0, import_shared_utils4.clsx)(classNames == null ? void 0 : classNames.content, className);
  return /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
    Component,
    {
      ref: domRef,
      className: (_a = slots.content) == null ? void 0 : _a.call(slots, { class: styles }),
      "data-justify": justify,
      ...otherProps,
      children
    }
  );
});
NavbarContent.displayName = "HeroUI.NavbarContent";
var navbar_content_default = NavbarContent;

// src/navbar-item.tsx
var import_system6 = require("@heroui/system");
var import_react_utils7 = require("@heroui/react-utils");
var import_shared_utils5 = require("@heroui/shared-utils");
var import_jsx_runtime5 = require("react/jsx-runtime");
var NavbarItem = (0, import_system6.forwardRef)((props, ref) => {
  var _a;
  const { as, className, children, isActive, ...otherProps } = props;
  const Component = as || "li";
  const domRef = (0, import_react_utils7.useDOMRef)(ref);
  const { slots, classNames } = useNavbarContext();
  const styles = (0, import_shared_utils5.clsx)(classNames == null ? void 0 : classNames.item, className);
  return /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
    Component,
    {
      ref: domRef,
      className: (_a = slots.item) == null ? void 0 : _a.call(slots, { class: styles }),
      "data-active": (0, import_shared_utils5.dataAttr)(isActive),
      ...otherProps,
      children
    }
  );
});
NavbarItem.displayName = "HeroUI.NavbarItem";
var navbar_item_default = NavbarItem;

// src/navbar-menu-toggle.tsx
var import_button = require("@react-aria/button");
var import_system7 = require("@heroui/system");
var import_react_utils8 = require("@heroui/react-utils");
var import_shared_utils6 = require("@heroui/shared-utils");
var import_toggle = require("@react-stately/toggle");
var import_focus = require("@react-aria/focus");
var import_utils5 = require("@react-aria/utils");
var import_interactions = require("@react-aria/interactions");
var import_react2 = require("react");
var import_jsx_runtime6 = require("react/jsx-runtime");
var NavbarMenuToggle = (0, import_system7.forwardRef)((props, ref) => {
  var _a;
  const {
    as,
    icon,
    className,
    onChange,
    autoFocus,
    srOnlyText: srOnlyTextProp,
    ...otherProps
  } = props;
  const Component = as || "button";
  const domRef = (0, import_react_utils8.useDOMRef)(ref);
  const { slots, classNames, isMenuOpen, setIsMenuOpen } = useNavbarContext();
  const handleChange = (isOpen) => {
    onChange == null ? void 0 : onChange(isOpen);
    setIsMenuOpen(isOpen);
  };
  const state = (0, import_toggle.useToggleState)({ ...otherProps, isSelected: isMenuOpen, onChange: handleChange });
  const { buttonProps, isPressed } = (0, import_button.useToggleButton)(props, state, domRef);
  const { isFocusVisible, focusProps } = (0, import_focus.useFocusRing)({ autoFocus });
  const { isHovered, hoverProps } = (0, import_interactions.useHover)({});
  const toggleStyles = (0, import_shared_utils6.clsx)(classNames == null ? void 0 : classNames.toggle, className);
  const child = (0, import_react2.useMemo)(() => {
    if (typeof icon === "function") {
      return icon(isMenuOpen != null ? isMenuOpen : false);
    }
    return icon || /* @__PURE__ */ (0, import_jsx_runtime6.jsx)("span", { className: slots.toggleIcon({ class: classNames == null ? void 0 : classNames.toggleIcon }) });
  }, [icon, isMenuOpen, slots.toggleIcon, classNames == null ? void 0 : classNames.toggleIcon]);
  const srOnlyText = (0, import_react2.useMemo)(() => {
    if (srOnlyTextProp) {
      return srOnlyTextProp;
    }
    return state.isSelected ? "close navigation menu" : "open navigation menu";
  }, [srOnlyTextProp, isMenuOpen]);
  return /* @__PURE__ */ (0, import_jsx_runtime6.jsxs)(
    Component,
    {
      ref: domRef,
      className: (_a = slots.toggle) == null ? void 0 : _a.call(slots, { class: toggleStyles }),
      "data-focus-visible": (0, import_shared_utils6.dataAttr)(isFocusVisible),
      "data-hover": (0, import_shared_utils6.dataAttr)(isHovered),
      "data-open": (0, import_shared_utils6.dataAttr)(isMenuOpen),
      "data-pressed": (0, import_shared_utils6.dataAttr)(isPressed),
      ...(0, import_utils5.mergeProps)(buttonProps, focusProps, hoverProps, otherProps),
      children: [
        /* @__PURE__ */ (0, import_jsx_runtime6.jsx)("span", { className: slots.srOnly(), children: srOnlyText }),
        child
      ]
    }
  );
});
NavbarMenuToggle.displayName = "HeroUI.NavbarMenuToggle";
var navbar_menu_toggle_default = NavbarMenuToggle;

// src/navbar-menu-item.tsx
var import_system8 = require("@heroui/system");
var import_react_utils9 = require("@heroui/react-utils");
var import_shared_utils7 = require("@heroui/shared-utils");
var import_jsx_runtime7 = require("react/jsx-runtime");
var NavbarMenuItem = (0, import_system8.forwardRef)((props, ref) => {
  var _a;
  const { className, children, isActive, ...otherProps } = props;
  const domRef = (0, import_react_utils9.useDOMRef)(ref);
  const { slots, isMenuOpen, classNames } = useNavbarContext();
  const styles = (0, import_shared_utils7.clsx)(classNames == null ? void 0 : classNames.menuItem, className);
  return /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(
    "li",
    {
      ref: domRef,
      className: (_a = slots.menuItem) == null ? void 0 : _a.call(slots, { class: styles }),
      "data-active": (0, import_shared_utils7.dataAttr)(isActive),
      "data-open": (0, import_shared_utils7.dataAttr)(isMenuOpen),
      ...otherProps,
      children
    }
  );
});
NavbarMenuItem.displayName = "HeroUI.NavbarMenuItem";
var navbar_menu_item_default = NavbarMenuItem;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Navbar,
  NavbarBrand,
  NavbarContent,
  NavbarItem,
  NavbarMenu,
  NavbarMenuItem,
  NavbarMenuToggle,
  NavbarProvider,
  useNavbar,
  useNavbarContext
});
