import * as framer_motion from 'framer-motion';
import * as _heroui_theme from '@heroui/theme';
import * as react from 'react';
import * as tailwind_variants from 'tailwind-variants';
import * as _heroui_system from '@heroui/system';

declare const NavbarProvider: react.Provider<{
    Component: _heroui_system.As<any>;
    slots: {
        base: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        wrapper: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        toggle: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        srOnly: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        toggleIcon: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        brand: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        item: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        menu: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        menuItem: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        wrapper: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        toggle: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        srOnly: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        toggleIcon: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        brand: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        item: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        menu: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        menuItem: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    domRef: react.RefObject<HTMLElement>;
    height: string | number;
    isHidden: boolean;
    disableAnimation: boolean;
    shouldHideOnScroll: boolean;
    isMenuOpen: boolean;
    classNames: _heroui_theme.SlotsToClasses<"base" | "menu" | "content" | "wrapper" | "item" | "toggle" | "srOnly" | "toggleIcon" | "brand" | "menuItem"> | undefined;
    setIsMenuOpen: (value: boolean, ...args: any[]) => void;
    motionProps: framer_motion.HTMLMotionProps<"nav"> | undefined;
    getBaseProps: _heroui_system.PropGetter;
    getWrapperProps: _heroui_system.PropGetter;
}>;
declare const useNavbarContext: () => {
    Component: _heroui_system.As<any>;
    slots: {
        base: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        wrapper: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        toggle: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        srOnly: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        toggleIcon: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        brand: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        item: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        menu: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        menuItem: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        wrapper: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        toggle: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        srOnly: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        toggleIcon: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        brand: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        item: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        menu: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        menuItem: (slotProps?: ({
            disableAnimation?: boolean | undefined;
            maxWidth?: "sm" | "md" | "lg" | "xl" | "2xl" | "full" | undefined;
            position?: "static" | "sticky" | undefined;
            isBordered?: boolean | undefined;
            isBlurred?: boolean | undefined;
            hideOnScroll?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    domRef: react.RefObject<HTMLElement>;
    height: string | number;
    isHidden: boolean;
    disableAnimation: boolean;
    shouldHideOnScroll: boolean;
    isMenuOpen: boolean;
    classNames: _heroui_theme.SlotsToClasses<"base" | "menu" | "content" | "wrapper" | "item" | "toggle" | "srOnly" | "toggleIcon" | "brand" | "menuItem"> | undefined;
    setIsMenuOpen: (value: boolean, ...args: any[]) => void;
    motionProps: framer_motion.HTMLMotionProps<"nav"> | undefined;
    getBaseProps: _heroui_system.PropGetter;
    getWrapperProps: _heroui_system.PropGetter;
};

export { NavbarProvider, useNavbarContext };
