import * as _heroui_system from '@heroui/system';
import { HTMLHeroUIProps } from '@heroui/system';
import { AriaToggleButtonProps } from '@react-aria/button';
import { ReactNode } from 'react';

interface Props extends Omit<HTMLHeroUIProps<"button">, keyof AriaToggleButtonProps> {
    /**
     * The value of the input element, used when submitting an HTML form. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#htmlattrdefvalue).
     */
    value?: string;
    /**
     * Text to display for screen readers.
     * @default open/close navigation menu
     */
    srOnlyText?: string;
    /**
     * The icon to display.
     */
    icon?: ReactNode | ((isOpen: boolean) => ReactNode) | null;
}
type NavbarMenuToggleProps = Props & AriaToggleButtonProps;
declare const NavbarMenuToggle: _heroui_system.InternalForwardRefRenderFunction<"button", NavbarMenuToggleProps, never>;

export { type NavbarMenuToggleProps, type Props, NavbarMenuToggle as default };
