"use client";

// src/use-aria-popover.ts
import { useEffect } from "react";
import {
  useOverlay,
  useOverlayPosition
} from "@react-aria/overlays";
import {
  ariaHideOutside,
  keepVisible,
  toReactAriaPlacement,
  ariaShouldCloseOnInteractOutside
} from "@heroui/aria-utils";
import { mergeProps } from "@react-aria/utils";
import { useSafeLayoutEffect } from "@heroui/use-safe-layout-effect";
function useReactAriaPopover(props, state) {
  const {
    groupRef,
    triggerRef,
    popoverRef,
    showArrow,
    offset = 7,
    crossOffset = 0,
    scrollRef,
    shouldFlip,
    boundaryElement,
    isDismissable = true,
    shouldCloseOnBlur = true,
    shouldCloseOnScroll = true,
    placement: placementProp = "top",
    containerPadding,
    shouldCloseOnInteractOutside,
    isNonModal: isNonModalProp,
    isKeyboardDismissDisabled,
    updatePositionDeps = [],
    ...otherProps
  } = props;
  const isNonModal = isNonModalProp != null ? isNonModalProp : true;
  const isSubmenu = otherProps["trigger"] === "SubmenuTrigger";
  const { overlayProps, underlayProps } = useOverlay(
    {
      isOpen: state.isOpen,
      onClose: state.close,
      shouldCloseOnBlur,
      isDismissable: isDismissable || isSubmenu,
      isKeyboardDismissDisabled,
      shouldCloseOnInteractOutside: shouldCloseOnInteractOutside ? shouldCloseOnInteractOutside : (element) => ariaShouldCloseOnInteractOutside(element, triggerRef, state)
    },
    popoverRef
  );
  const {
    overlayProps: positionProps,
    arrowProps,
    placement,
    updatePosition
  } = useOverlayPosition({
    ...otherProps,
    shouldFlip,
    crossOffset,
    targetRef: triggerRef,
    overlayRef: popoverRef,
    isOpen: state.isOpen,
    scrollRef,
    boundaryElement,
    containerPadding,
    placement: toReactAriaPlacement(placementProp),
    offset: showArrow ? offset + 3 : offset,
    onClose: isNonModal && !isSubmenu && shouldCloseOnScroll ? state.close : () => {
    }
  });
  useSafeLayoutEffect(() => {
    if (!updatePositionDeps.length) return;
    updatePosition();
  }, updatePositionDeps);
  useEffect(() => {
    var _a, _b;
    if (state.isOpen && popoverRef.current) {
      if (isNonModal) {
        return keepVisible((_a = groupRef == null ? void 0 : groupRef.current) != null ? _a : popoverRef.current);
      } else {
        return ariaHideOutside([(_b = groupRef == null ? void 0 : groupRef.current) != null ? _b : popoverRef.current]);
      }
    }
  }, [isNonModal, state.isOpen, popoverRef, groupRef]);
  return {
    popoverProps: mergeProps(overlayProps, positionProps),
    arrowProps,
    underlayProps,
    placement
  };
}

export {
  useReactAriaPopover
};
