import * as _heroui_system from '@heroui/system';
import React__default from 'react';

interface PopoverTriggerProps {
    children?: React__default.ReactNode;
    className?: string;
    [key: string]: any;
}
/**
 * PopoverTrigger opens the popover's content. It must be an interactive element
 * such as `button` or `a`.
 */
declare const PopoverTrigger: {
    (props: PopoverTriggerProps): React__default.DetailedReactHTMLElement<React__default.HTMLAttributes<HTMLSpanElement> & {
        [dataAttr: string]: any;
        'aria-activedescendant'?: string | undefined;
        'aria-atomic'?: (boolean | "true" | "false") | undefined;
        'aria-autocomplete'?: "none" | "inline" | "list" | "both" | undefined;
        'aria-busy'?: (boolean | "true" | "false") | undefined;
        'aria-checked'?: boolean | "false" | "mixed" | "true" | undefined;
        'aria-colcount'?: number | undefined;
        'aria-colindex'?: number | undefined;
        'aria-colspan'?: number | undefined;
        'aria-controls'?: string | undefined;
        'aria-current'?: boolean | "false" | "true" | "page" | "step" | "location" | "date" | "time" | undefined;
        'aria-describedby'?: string | undefined;
        'aria-details'?: string | undefined;
        'aria-disabled'?: (boolean | "true" | "false") | undefined;
        'aria-dropeffect'?: "none" | "copy" | "execute" | "link" | "move" | "popup" | undefined;
        'aria-errormessage'?: string | undefined;
        'aria-expanded'?: (boolean | "true" | "false") | undefined;
        'aria-flowto'?: string | undefined;
        'aria-grabbed'?: (boolean | "true" | "false") | undefined;
        'aria-haspopup'?: boolean | "false" | "true" | "menu" | "listbox" | "tree" | "grid" | "dialog" | undefined;
        'aria-hidden'?: (boolean | "true" | "false") | undefined;
        'aria-invalid'?: boolean | "false" | "true" | "grammar" | "spelling" | undefined;
        'aria-keyshortcuts'?: string | undefined;
        'aria-label'?: string | undefined;
        'aria-labelledby'?: string | undefined;
        'aria-level'?: number | undefined;
        'aria-live'?: "off" | "assertive" | "polite" | undefined;
        'aria-modal'?: (boolean | "true" | "false") | undefined;
        'aria-multiline'?: (boolean | "true" | "false") | undefined;
        'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
        'aria-orientation'?: "horizontal" | "vertical" | undefined;
        'aria-owns'?: string | undefined;
        'aria-placeholder'?: string | undefined;
        'aria-posinset'?: number | undefined;
        'aria-pressed'?: boolean | "false" | "mixed" | "true" | undefined;
        'aria-readonly'?: (boolean | "true" | "false") | undefined;
        'aria-relevant'?: "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text" | "text additions" | "text removals" | undefined;
        'aria-required'?: (boolean | "true" | "false") | undefined;
        'aria-roledescription'?: string | undefined;
        'aria-rowcount'?: number | undefined;
        'aria-rowindex'?: number | undefined;
        'aria-rowspan'?: number | undefined;
        'aria-selected'?: (boolean | "true" | "false") | undefined;
        'aria-setsize'?: number | undefined;
        'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
        'aria-valuemax'?: number | undefined;
        'aria-valuemin'?: number | undefined;
        'aria-valuenow'?: number | undefined;
        'aria-valuetext'?: string | undefined;
        children?: React__default.ReactNode | undefined;
        dangerouslySetInnerHTML?: {
            __html: string | TrustedHTML;
        } | undefined;
        onCopy?: React__default.ClipboardEventHandler<_heroui_system.DOMElement> | undefined;
        onCopyCapture?: React__default.ClipboardEventHandler<_heroui_system.DOMElement> | undefined;
        onCut?: React__default.ClipboardEventHandler<_heroui_system.DOMElement> | undefined;
        onCutCapture?: React__default.ClipboardEventHandler<_heroui_system.DOMElement> | undefined;
        onPaste?: React__default.ClipboardEventHandler<_heroui_system.DOMElement> | undefined;
        onPasteCapture?: React__default.ClipboardEventHandler<_heroui_system.DOMElement> | undefined;
        onCompositionEnd?: React__default.CompositionEventHandler<_heroui_system.DOMElement> | undefined;
        onCompositionEndCapture?: React__default.CompositionEventHandler<_heroui_system.DOMElement> | undefined;
        onCompositionStart?: React__default.CompositionEventHandler<_heroui_system.DOMElement> | undefined;
        onCompositionStartCapture?: React__default.CompositionEventHandler<_heroui_system.DOMElement> | undefined;
        onCompositionUpdate?: React__default.CompositionEventHandler<_heroui_system.DOMElement> | undefined;
        onCompositionUpdateCapture?: React__default.CompositionEventHandler<_heroui_system.DOMElement> | undefined;
        onFocus?: React__default.FocusEventHandler<_heroui_system.DOMElement> | undefined;
        onFocusCapture?: React__default.FocusEventHandler<_heroui_system.DOMElement> | undefined;
        onBlur?: React__default.FocusEventHandler<_heroui_system.DOMElement> | undefined;
        onBlurCapture?: React__default.FocusEventHandler<_heroui_system.DOMElement> | undefined;
        onChange?: React__default.FormEventHandler<_heroui_system.DOMElement> | undefined;
        onChangeCapture?: React__default.FormEventHandler<_heroui_system.DOMElement> | undefined;
        onBeforeInput?: React__default.FormEventHandler<_heroui_system.DOMElement> | undefined;
        onBeforeInputCapture?: React__default.FormEventHandler<_heroui_system.DOMElement> | undefined;
        onInput?: React__default.FormEventHandler<_heroui_system.DOMElement> | undefined;
        onInputCapture?: React__default.FormEventHandler<_heroui_system.DOMElement> | undefined;
        onReset?: React__default.FormEventHandler<_heroui_system.DOMElement> | undefined;
        onResetCapture?: React__default.FormEventHandler<_heroui_system.DOMElement> | undefined;
        onSubmit?: React__default.FormEventHandler<_heroui_system.DOMElement> | undefined;
        onSubmitCapture?: React__default.FormEventHandler<_heroui_system.DOMElement> | undefined;
        onInvalid?: React__default.FormEventHandler<_heroui_system.DOMElement> | undefined;
        onInvalidCapture?: React__default.FormEventHandler<_heroui_system.DOMElement> | undefined;
        onLoad?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onLoadCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onError?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onErrorCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onKeyDown?: React__default.KeyboardEventHandler<_heroui_system.DOMElement> | undefined;
        onKeyDownCapture?: React__default.KeyboardEventHandler<_heroui_system.DOMElement> | undefined;
        onKeyPress?: React__default.KeyboardEventHandler<_heroui_system.DOMElement> | undefined;
        onKeyPressCapture?: React__default.KeyboardEventHandler<_heroui_system.DOMElement> | undefined;
        onKeyUp?: React__default.KeyboardEventHandler<_heroui_system.DOMElement> | undefined;
        onKeyUpCapture?: React__default.KeyboardEventHandler<_heroui_system.DOMElement> | undefined;
        onAbort?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onAbortCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onCanPlay?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onCanPlayCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onCanPlayThrough?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onCanPlayThroughCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onDurationChange?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onDurationChangeCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onEmptied?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onEmptiedCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onEncrypted?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onEncryptedCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onEnded?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onEndedCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onLoadedData?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onLoadedDataCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onLoadedMetadata?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onLoadedMetadataCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onLoadStart?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onLoadStartCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onPause?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onPauseCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onPlay?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onPlayCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onPlaying?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onPlayingCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onProgress?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onProgressCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onRateChange?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onRateChangeCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onResize?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onResizeCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onSeeked?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onSeekedCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onSeeking?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onSeekingCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onStalled?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onStalledCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onSuspend?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onSuspendCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onTimeUpdate?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onTimeUpdateCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onVolumeChange?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onVolumeChangeCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onWaiting?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onWaitingCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onAuxClick?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onAuxClickCapture?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onClick?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onClickCapture?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onContextMenu?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onContextMenuCapture?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onDoubleClick?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onDoubleClickCapture?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onDrag?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onDragCapture?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onDragEnd?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onDragEndCapture?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onDragEnter?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onDragEnterCapture?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onDragExit?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onDragExitCapture?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onDragLeave?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onDragLeaveCapture?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onDragOver?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onDragOverCapture?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onDragStart?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onDragStartCapture?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onDrop?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onDropCapture?: React__default.DragEventHandler<_heroui_system.DOMElement> | undefined;
        onMouseDown?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onMouseDownCapture?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onMouseEnter?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onMouseLeave?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onMouseMove?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onMouseMoveCapture?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onMouseOut?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onMouseOutCapture?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onMouseOver?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onMouseOverCapture?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onMouseUp?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onMouseUpCapture?: React__default.MouseEventHandler<_heroui_system.DOMElement> | undefined;
        onSelect?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onSelectCapture?: React__default.ReactEventHandler<_heroui_system.DOMElement> | undefined;
        onTouchCancel?: React__default.TouchEventHandler<_heroui_system.DOMElement> | undefined;
        onTouchCancelCapture?: React__default.TouchEventHandler<_heroui_system.DOMElement> | undefined;
        onTouchEnd?: React__default.TouchEventHandler<_heroui_system.DOMElement> | undefined;
        onTouchEndCapture?: React__default.TouchEventHandler<_heroui_system.DOMElement> | undefined;
        onTouchMove?: React__default.TouchEventHandler<_heroui_system.DOMElement> | undefined;
        onTouchMoveCapture?: React__default.TouchEventHandler<_heroui_system.DOMElement> | undefined;
        onTouchStart?: React__default.TouchEventHandler<_heroui_system.DOMElement> | undefined;
        onTouchStartCapture?: React__default.TouchEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerDown?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerDownCapture?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerMove?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerMoveCapture?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerUp?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerUpCapture?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerCancel?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerCancelCapture?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerEnter?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerEnterCapture?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerLeave?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerLeaveCapture?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerOver?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerOverCapture?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerOut?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onPointerOutCapture?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onGotPointerCapture?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onGotPointerCaptureCapture?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onLostPointerCapture?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onLostPointerCaptureCapture?: React__default.PointerEventHandler<_heroui_system.DOMElement> | undefined;
        onScroll?: React__default.UIEventHandler<_heroui_system.DOMElement> | undefined;
        onScrollCapture?: React__default.UIEventHandler<_heroui_system.DOMElement> | undefined;
        onWheel?: React__default.WheelEventHandler<_heroui_system.DOMElement> | undefined;
        onWheelCapture?: React__default.WheelEventHandler<_heroui_system.DOMElement> | undefined;
        onAnimationStart?: React__default.AnimationEventHandler<_heroui_system.DOMElement> | undefined;
        onAnimationStartCapture?: React__default.AnimationEventHandler<_heroui_system.DOMElement> | undefined;
        onAnimationEnd?: React__default.AnimationEventHandler<_heroui_system.DOMElement> | undefined;
        onAnimationEndCapture?: React__default.AnimationEventHandler<_heroui_system.DOMElement> | undefined;
        onAnimationIteration?: React__default.AnimationEventHandler<_heroui_system.DOMElement> | undefined;
        onAnimationIterationCapture?: React__default.AnimationEventHandler<_heroui_system.DOMElement> | undefined;
        onTransitionEnd?: React__default.TransitionEventHandler<_heroui_system.DOMElement> | undefined;
        onTransitionEndCapture?: React__default.TransitionEventHandler<_heroui_system.DOMElement> | undefined;
        id?: string;
        role?: React__default.AriaRole;
        tabIndex?: number;
        style?: React__default.CSSProperties;
        ref?: React__default.Ref<any> | undefined;
        key?: React__default.Key | null | undefined;
    } & {
        onPress: any;
        isDisabled: any;
    }, HTMLElement>;
    displayName: string;
};

export { type PopoverTriggerProps, PopoverTrigger as default };
