"use client";
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/popover-trigger.tsx
var popover_trigger_exports = {};
__export(popover_trigger_exports, {
  default: () => popover_trigger_default
});
module.exports = __toCommonJS(popover_trigger_exports);
var import_react = require("react");
var import_react_utils2 = require("@heroui/react-utils");
var import_use_aria_button = require("@heroui/use-aria-button");
var import_button = require("@heroui/button");
var import_utils = require("@react-aria/utils");

// src/popover-context.ts
var import_react_utils = require("@heroui/react-utils");
var [PopoverProvider, usePopoverContext] = (0, import_react_utils.createContext)({
  name: "PopoverContext",
  errorMessage: "usePopoverContext: `context` is undefined. Seems you forgot to wrap all popover components within `<Popover />`"
});

// src/popover-trigger.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var PopoverTrigger = (props) => {
  var _a;
  const { triggerRef, getTriggerProps } = usePopoverContext();
  const { children, ...otherProps } = props;
  const child = (0, import_react.useMemo)(() => {
    if (typeof children === "string") return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("p", { children });
    return import_react.Children.only(children);
  }, [children]);
  const childRef = (_a = child.props.ref) != null ? _a : child.ref;
  const { onPress, isDisabled, ...restProps } = (0, import_react.useMemo)(() => {
    return getTriggerProps((0, import_utils.mergeProps)(otherProps, child.props), childRef);
  }, [getTriggerProps, child.props, otherProps, childRef]);
  const [, triggerChildren] = (0, import_react_utils2.pickChildren)(children, import_button.Button);
  const { buttonProps } = (0, import_use_aria_button.useAriaButton)({ onPress, isDisabled }, triggerRef);
  const hasHeroUIButton = (0, import_react.useMemo)(() => {
    return (triggerChildren == null ? void 0 : triggerChildren[0]) !== void 0;
  }, [triggerChildren]);
  if (!hasHeroUIButton) {
    delete restProps["preventFocusOnPress"];
  }
  return (0, import_react.cloneElement)(
    child,
    (0, import_utils.mergeProps)(restProps, hasHeroUIButton ? { onPress, isDisabled } : buttonProps)
  );
};
PopoverTrigger.displayName = "HeroUI.PopoverTrigger";
var popover_trigger_default = PopoverTrigger;
