import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { AriaRadioProps } from '@react-types/radio';
import { RadioVariantProps, SlotsToClasses, RadioSlots } from '@heroui/theme';
import { ReactNode, Ref } from 'react';

interface Props extends Omit<HTMLHeroUIProps<"input">, keyof RadioVariantProps> {
    /**
     * Ref to the DOM node.
     */
    ref?: Ref<HTMLElement>;
    /**
     * The label of the checkbox.
     */
    children?: ReactNode;
    /**
     * The radio description text.
     */
    description?: string | ReactNode;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <Radio classNames={{
     *    base:"base-classes",
     *    wrapper: "wrapper-classes",
     *    control: "control-classes", // inner circle
     *    labelWrapper: "label-wrapper-classes", // this wraps the label and description
     *    label: "label-classes",
     *    description: "description-classes",
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<RadioSlots>;
}
type UseRadioProps = Omit<Props, "defaultChecked"> & Omit<AriaRadioProps, keyof RadioVariantProps> & RadioVariantProps;
declare function useRadio(props: UseRadioProps): {
    Component: _heroui_system.As<any>;
    children: ReactNode;
    isSelected: boolean;
    isDisabled: boolean;
    isInvalid: boolean | undefined;
    isFocusVisible: boolean;
    description: ReactNode;
    getBaseProps: PropGetter;
    getWrapperProps: PropGetter;
    getInputProps: PropGetter;
    getLabelProps: PropGetter;
    getLabelWrapperProps: PropGetter;
    getControlProps: PropGetter;
    getDescriptionProps: PropGetter;
};
type UseRadioReturn = ReturnType<typeof useRadio>;

export { type UseRadioProps, type UseRadioReturn, useRadio };
