import { RippleType } from './use-ripple.mjs';
import { FC } from 'react';
import { HTMLMotionProps } from 'framer-motion';
import { HTMLHeroUIProps } from '@heroui/system';
import '@react-types/shared';

interface RippleProps extends HTMLHeroUIProps<"span"> {
    ripples: RippleType[];
    color?: string;
    motionProps?: HTMLMotionProps<"span">;
    style?: React.CSSProperties;
    onClear: (key: React.Key) => void;
}
declare const Ripple: FC<RippleProps>;

export { type RippleProps, Ripple as default };
