import * as react from 'react';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { ScrollShadowVariantProps } from '@heroui/theme';
import { ReactRef } from '@heroui/react-utils';
import { UseDataScrollOverflowProps } from '@heroui/use-data-scroll-overflow';

interface Props extends HTMLHeroUIProps<"div">, Omit<UseDataScrollOverflowProps, "domRef"> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLElement | null>;
    /**
     * The shadow size in pixels.
     * @default 40
     */
    size?: number;
}
type UseScrollShadowProps = Props & ScrollShadowVariantProps;
declare function useScrollShadow(originalProps: UseScrollShadowProps): {
    Component: _heroui_system.As<any>;
    styles: string;
    domRef: react.RefObject<HTMLElement>;
    children: react.ReactNode;
    getBaseProps: PropGetter;
};
type UseScrollShadowReturn = ReturnType<typeof useScrollShadow>;

export { type UseScrollShadowProps, type UseScrollShadowReturn, useScrollShadow };
