"use client";
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/hidden-select.tsx
var hidden_select_exports = {};
__export(hidden_select_exports, {
  HiddenSelect: () => HiddenSelect,
  useHiddenSelect: () => useHiddenSelect
});
module.exports = __toCommonJS(hidden_select_exports);
var import_utils2 = require("@react-aria/utils");
var import_visually_hidden = require("@react-aria/visually-hidden");
var import_form2 = require("@react-aria/form");

// src/use-select.ts
var import_system = require("@heroui/system");
var import_theme = require("@heroui/theme");
var import_react_utils = require("@heroui/react-utils");
var import_react = require("react");
var import_use_aria_button = require("@heroui/use-aria-button");
var import_focus = require("@react-aria/focus");
var import_shared_utils = require("@heroui/shared-utils");
var import_utils = require("@react-aria/utils");
var import_interactions = require("@react-aria/interactions");
var import_use_aria_multiselect = require("@heroui/use-aria-multiselect");
var import_use_safe_layout_effect = require("@heroui/use-safe-layout-effect");
var import_aria_utils = require("@heroui/aria-utils");
var import_form = require("@heroui/form");
var import_overlays = require("@react-aria/overlays");
var selectData = /* @__PURE__ */ new WeakMap();

// src/hidden-select.tsx
var import_jsx_runtime = require("react/jsx-runtime");
function useHiddenSelect(props, state, triggerRef) {
  var _a;
  let data = selectData.get(state) || {};
  let {
    autoComplete,
    name = data.name,
    isDisabled = data.isDisabled,
    selectionMode,
    onChange,
    form
  } = props;
  let { validationBehavior, isRequired, isInvalid } = data;
  let { visuallyHiddenProps } = (0, import_visually_hidden.useVisuallyHidden)();
  (0, import_utils2.useFormReset)(props.selectRef, state.selectedKeys, state.setSelectedKeys);
  (0, import_form2.useFormValidation)(
    {
      validationBehavior,
      focus: () => {
        var _a2;
        return (_a2 = triggerRef.current) == null ? void 0 : _a2.focus();
      }
    },
    state,
    props.selectRef
  );
  return {
    containerProps: {
      ...visuallyHiddenProps,
      "aria-hidden": true,
      ["data-a11y-ignore"]: "aria-hidden-focus"
    },
    inputProps: {
      style: { display: "none" }
    },
    selectProps: {
      form,
      autoComplete,
      disabled: isDisabled,
      "aria-invalid": isInvalid || void 0,
      "aria-required": isRequired && validationBehavior === "aria" || void 0,
      required: isRequired && validationBehavior === "native",
      name,
      tabIndex: -1,
      value: selectionMode === "multiple" ? [...state.selectedKeys].map((k) => String(k)) : (_a = [...state.selectedKeys][0]) != null ? _a : "",
      multiple: selectionMode === "multiple",
      onChange: (e) => {
        state.setSelectedKeys(e.target.value);
        onChange == null ? void 0 : onChange(e);
      }
    }
  };
}
function HiddenSelect(props) {
  var _a;
  let { state, triggerRef, selectRef, label, name, isDisabled, form } = props;
  let { containerProps, selectProps } = useHiddenSelect({ ...props, selectRef }, state, triggerRef);
  if (state.collection.size <= 300) {
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { ...containerProps, "data-testid": "hidden-select-container", children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("label", { children: [
      label,
      /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("select", { ...selectProps, ref: selectRef, children: [
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)("option", {}),
        [...state.collection.getKeys()].map((key) => {
          let item = state.collection.getItem(key);
          if ((item == null ? void 0 : item.type) === "item") {
            return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("option", { value: item.key, children: item.textValue }, item.key);
          }
        })
      ] })
    ] }) });
  } else if (name) {
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      "input",
      {
        autoComplete: selectProps.autoComplete,
        disabled: isDisabled,
        form,
        name,
        type: "hidden",
        value: (_a = [...state.selectedKeys].join(",")) != null ? _a : ""
      }
    );
  }
  return null;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  HiddenSelect,
  useHiddenSelect
});
