// src/icons.tsx
import { jsx, jsxs } from "react/jsx-runtime";
var Sun = ({ fill, filled, size, height, width, ...props }) => {
  if (filled) {
    return /* @__PURE__ */ jsx(
      "svg",
      {
        height: size || height || 24,
        viewBox: "0 0 512 512",
        width: size || width || 24,
        ...props,
        children: /* @__PURE__ */ jsx(
          "path",
          {
            d: "M256 118a22 22 0 01-22-22V48a22 22 0 0144 0v48a22 22 0 01-22 22zM256 486a22 22 0 01-22-22v-48a22 22 0 0144 0v48a22 22 0 01-22 22zM369.14 164.86a22 22 0 01-15.56-37.55l33.94-33.94a22 22 0 0131.11 31.11l-33.94 33.94a21.93 21.93 0 01-15.55 6.44zM108.92 425.08a22 22 0 01-15.55-37.56l33.94-33.94a22 22 0 1131.11 31.11l-33.94 33.94a21.94 21.94 0 01-15.56 6.45zM464 278h-48a22 22 0 010-44h48a22 22 0 010 44zM96 278H48a22 22 0 010-44h48a22 22 0 010 44zM403.08 425.08a21.94 21.94 0 01-15.56-6.45l-33.94-33.94a22 22 0 0131.11-31.11l33.94 33.94a22 22 0 01-15.55 37.56zM142.86 164.86a21.89 21.89 0 01-15.55-6.44l-33.94-33.94a22 22 0 0131.11-31.11l33.94 33.94a22 22 0 01-15.56 37.55zM256 358a102 102 0 11102-102 102.12 102.12 0 01-102 102z",
            fill
          }
        )
      }
    );
  }
  return /* @__PURE__ */ jsxs("svg", { height: size || height || 24, viewBox: "0 0 512 512", width: size || width || 24, ...props, children: [
    /* @__PURE__ */ jsx(
      "path",
      {
        d: "M256 48v48M256 416v48M403.08 108.92l-33.94 33.94M142.86 369.14l-33.94 33.94M464 256h-48M96 256H48M403.08 403.08l-33.94-33.94M142.86 142.86l-33.94-33.94",
        fill: "none",
        stroke: fill,
        strokeLinecap: "round",
        strokeMiterlimit: 10,
        strokeWidth: 32
      }
    ),
    /* @__PURE__ */ jsx(
      "circle",
      {
        cx: 256,
        cy: 256,
        fill: "none",
        r: 80,
        stroke: fill,
        strokeLinecap: "round",
        strokeMiterlimit: 10,
        strokeWidth: 32
      }
    )
  ] });
};
var Mail = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsx("svg", { height: size || height || 24, viewBox: "0 0 24 24", width: size || width || 24, ...props, children: /* @__PURE__ */ jsxs("g", { fill: "none", stroke: fill, strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 1.5, children: [
    /* @__PURE__ */ jsx("path", { d: "M12 20.5H7c-3 0-5-1.5-5-5v-7c0-3.5 2-5 5-5h10c3 0 5 1.5 5 5v3" }),
    /* @__PURE__ */ jsx("path", { d: "M17 9l-3.13 2.5a3.166 3.166 0 01-3.75 0L7 9M19.21 14.77l-3.539 3.54a1.232 1.232 0 00-.3.59l-.19 1.35a.635.635 0 00.76.76l1.35-.19a1.189 1.189 0 00.59-.3l3.54-3.54a1.365 1.365 0 000-2.22 1.361 1.361 0 00-2.211.01zM18.7 15.28a3.185 3.185 0 002.22 2.22" })
  ] }) });
};
var Moon = ({ fill, filled, size, height, width, ...props }) => {
  if (filled) {
    return /* @__PURE__ */ jsx(
      "svg",
      {
        height: size || height || 24,
        viewBox: "0 0 512 512",
        width: size || width || 24,
        ...props,
        children: /* @__PURE__ */ jsx(
          "path",
          {
            d: "M152.62 126.77c0-33 4.85-66.35 17.23-94.77C87.54 67.83 32 151.89 32 247.38 32 375.85 136.15 480 264.62 480c95.49 0 179.55-55.54 215.38-137.85-28.42 12.38-61.8 17.23-94.77 17.23-128.47 0-232.61-104.14-232.61-232.61z",
            fill
          }
        )
      }
    );
  }
  return /* @__PURE__ */ jsx("svg", { height: size || height || 24, viewBox: "0 0 512 512", width: size || width || 24, ...props, children: /* @__PURE__ */ jsx(
    "path",
    {
      d: "M160 136c0-30.62 4.51-61.61 16-88C99.57 81.27 48 159.32 48 248c0 119.29 96.71 216 216 216 88.68 0 166.73-51.57 200-128-26.39 11.49-57.38 16-88 16-119.29 0-216-96.71-216-216z",
      fill: "none",
      stroke: fill,
      strokeLinecap: "round",
      strokeLinejoin: "round",
      strokeWidth: 32
    }
  ) });
};
var Lock = ({ fill, size, height, width, ...props }) => {
  const color = fill;
  return /* @__PURE__ */ jsx(
    "svg",
    {
      "data-name": "Iconly/Curved/Lock",
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: /* @__PURE__ */ jsxs("g", { transform: "translate(3.5 2)", children: [
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M9.121,6.653V4.5A4.561,4.561,0,0,0,0,4.484V6.653",
            fill: "none",
            stroke: color,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: "10",
            strokeWidth: 1.5,
            transform: "translate(3.85 0.75)"
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M.5,0V2.221",
            fill: "none",
            stroke: color,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: "10",
            strokeWidth: 1.5,
            transform: "translate(7.91 12.156)"
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M7.66,0C1.915,0,0,1.568,0,6.271s1.915,6.272,7.66,6.272,7.661-1.568,7.661-6.272S13.4,0,7.66,0Z",
            fill: "none",
            stroke: color,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: "10",
            strokeWidth: 1.5,
            transform: "translate(0.75 6.824)"
          }
        )
      ] })
    }
  );
};
var Unlock = ({ fill, size, height, width, ...props }) => {
  const color = fill;
  return /* @__PURE__ */ jsx(
    "svg",
    {
      "data-name": "Iconly/Curved/Lock",
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: /* @__PURE__ */ jsxs("g", { transform: "translate(3.5 2)", children: [
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M8.927,3.237A4.562,4.562,0,0,0,0,4.484V6.653",
            fill: "none",
            stroke: color,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: "10",
            strokeWidth: 1.5,
            transform: "translate(3.849 0.75)"
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M.5,0V2.221",
            fill: "none",
            stroke: color,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: "10",
            strokeWidth: 1.5,
            transform: "translate(7.91 12.156)"
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M7.66,0C1.915,0,0,1.568,0,6.271s1.915,6.272,7.66,6.272,7.661-1.568,7.661-6.272S13.406,0,7.66,0Z",
            fill: "none",
            stroke: color,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: "10",
            strokeWidth: 1.5,
            transform: "translate(0.75 6.824)"
          }
        )
      ] })
    }
  );
};
var Password = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsx("svg", { height: size || height || 24, viewBox: "0 0 24 24", width: size || width || 24, ...props, children: /* @__PURE__ */ jsxs("g", { fill, children: [
    /* @__PURE__ */ jsx("path", { d: "M18.75 8v2.1a12.984 12.984 0 00-1.5-.1V8c0-3.15-.89-5.25-5.25-5.25S6.75 4.85 6.75 8v2a12.984 12.984 0 00-1.5.1V8c0-2.9.7-6.75 6.75-6.75S18.75 5.1 18.75 8z" }),
    /* @__PURE__ */ jsx("path", { d: "M18.75 10.1a12.984 12.984 0 00-1.5-.1H6.75a12.984 12.984 0 00-1.5.1C2.7 10.41 2 11.66 2 15v2c0 4 1 5 5 5h10c4 0 5-1 5-5v-2c0-3.34-.7-4.59-3.25-4.9zM8.71 16.71A1.052 1.052 0 018 17a1 1 0 01-.38-.08 1.032 1.032 0 01-.33-.21A1.052 1.052 0 017 16a1 1 0 01.08-.38 1.155 1.155 0 01.21-.33 1.032 1.032 0 01.33-.21 1 1 0 011.09.21 1.155 1.155 0 01.21.33A1 1 0 019 16a1.052 1.052 0 01-.29.71zm4.21-.33a1.155 1.155 0 01-.21.33A1.052 1.052 0 0112 17a1.033 1.033 0 01-.71-.29 1.155 1.155 0 01-.21-.33A1 1 0 0111 16a1.033 1.033 0 01.29-.71 1.047 1.047 0 011.42 0A1.033 1.033 0 0113 16a1 1 0 01-.08.38zm3.79.33a1.014 1.014 0 01-1.42 0 1.014 1.014 0 010-1.42 1.047 1.047 0 011.42 0c.04.05.08.1.12.16a.556.556 0 01.09.17.636.636 0 01.06.18 1.5 1.5 0 01.02.2 1.052 1.052 0 01-.29.71z" })
  ] }) });
};
var Notification = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsx(
    "svg",
    {
      fill: "none",
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: /* @__PURE__ */ jsx(
        "path",
        {
          clipRule: "evenodd",
          d: "M18.707 8.796c0 1.256.332 1.997 1.063 2.85.553.628.73 1.435.73 2.31 0 .874-.287 1.704-.863 2.378a4.537 4.537 0 01-2.9 1.413c-1.571.134-3.143.247-4.736.247-1.595 0-3.166-.068-4.737-.247a4.532 4.532 0 01-2.9-1.413 3.616 3.616 0 01-.864-2.378c0-.875.178-1.682.73-2.31.754-.854 1.064-1.594 1.064-2.85V8.37c0-1.682.42-2.781 1.283-3.858C7.861 2.942 9.919 2 11.956 2h.09c2.08 0 4.204.987 5.466 2.625.82 1.054 1.195 2.108 1.195 3.745v.426zM9.074 20.061c0-.504.462-.734.89-.833.5-.106 3.545-.106 4.045 0 .428.099.89.33.89.833-.025.48-.306.904-.695 1.174a3.635 3.635 0 01-1.713.731 3.795 3.795 0 01-1.008 0 3.618 3.618 0 01-1.714-.732c-.39-.269-.67-.694-.695-1.173z",
          fill,
          fillRule: "evenodd"
        }
      )
    }
  );
};
var User = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsx(
    "svg",
    {
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: /* @__PURE__ */ jsxs(
        "g",
        {
          fill: "none",
          stroke: fill,
          strokeLinecap: "round",
          strokeLinejoin: "round",
          strokeMiterlimit: 10,
          strokeWidth: 1.5,
          children: [
            /* @__PURE__ */ jsx(
              "path",
              {
                d: "M11.845 21.662C8.153 21.662 5 21.088 5 18.787s3.133-4.425 6.845-4.425c3.692 0 6.845 2.1 6.845 4.4s-3.134 2.9-6.845 2.9z",
                "data-name": "Stroke 1"
              }
            ),
            /* @__PURE__ */ jsx("path", { d: "M11.837 11.174a4.372 4.372 0 10-.031 0z", "data-name": "Stroke 3" })
          ]
        }
      )
    }
  );
};
var VolumeUp = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsx(
    "svg",
    {
      fill: "none",
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: /* @__PURE__ */ jsx(
        "path",
        {
          clipRule: "evenodd",
          d: "M13.357 6.45c-.05-.486-.103-.99-.232-1.494C12.775 3.752 11.801 3 10.758 3c-.582-.002-1.318.356-1.736.72l-3.46 2.897h-1.81c-1.333 0-2.404 1.027-2.607 2.51-.172 1.424-.214 4.11 0 5.677.186 1.567 1.21 2.579 2.607 2.579h1.81l3.527 2.94c.362.315 1 .676 1.588.676l.105.001c1.063 0 2-.78 2.35-1.98.133-.509.18-.985.224-1.445l.001-.008.047-.459c.18-1.487.18-8.739 0-10.215l-.047-.442zm4.05.045a.907.907 0 00-1.279-.237.957.957 0 00-.228 1.308c.802 1.182 1.243 2.756 1.243 4.434 0 1.677-.441 3.252-1.243 4.434a.956.956 0 00.23 1.308.905.905 0 001.277-.237c1.012-1.492 1.571-3.447 1.571-5.505s-.559-4.013-1.571-5.505zM19.29 3.22a.905.905 0 011.277.236C22.136 5.767 23 8.802 23 12c0 3.2-.864 6.234-2.433 8.544a.902.902 0 01-1.276.236.957.957 0 01-.23-1.308c1.356-1.999 2.104-4.653 2.104-7.472 0-2.818-.748-5.472-2.105-7.471a.958.958 0 01.23-1.308z",
          fill,
          fillRule: "evenodd"
        }
      )
    }
  );
};
var Camera = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsx(
    "svg",
    {
      fill: "none",
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: /* @__PURE__ */ jsx(
        "path",
        {
          clipRule: "evenodd",
          d: "M17.44 6.236c.04.07.11.12.2.12 2.4 0 4.36 1.958 4.36 4.355v5.934A4.368 4.368 0 0117.64 21H6.36A4.361 4.361 0 012 16.645V10.71a4.361 4.361 0 014.36-4.355c.08 0 .16-.04.19-.12l.06-.12.106-.222a97.79 97.79 0 01.714-1.486C7.89 3.51 8.67 3.01 9.64 3h4.71c.97.01 1.76.51 2.22 1.408.157.315.397.822.629 1.31l.141.299.1.22zm-.73 3.836c0 .5.4.9.9.9s.91-.4.91-.9-.41-.909-.91-.909-.9.41-.9.91zm-6.44 1.548c.47-.47 1.08-.719 1.73-.719.65 0 1.26.25 1.72.71.46.459.71 1.068.71 1.717A2.438 2.438 0 0112 15.756c-.65 0-1.26-.25-1.72-.71a2.408 2.408 0 01-.71-1.717v-.01c-.01-.63.24-1.24.7-1.699zm4.5 4.485a3.91 3.91 0 01-2.77 1.15 3.921 3.921 0 01-3.93-3.926 3.865 3.865 0 011.14-2.767A3.921 3.921 0 0112 9.402c1.05 0 2.04.41 2.78 1.15.74.749 1.15 1.738 1.15 2.777a3.958 3.958 0 01-1.16 2.776z",
          fill,
          fillRule: "evenodd"
        }
      )
    }
  );
};
var Activity = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsx(
    "svg",
    {
      "data-name": "Iconly/Curved/Activity",
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: /* @__PURE__ */ jsxs(
        "g",
        {
          fill: "none",
          stroke: fill,
          strokeLinecap: "round",
          strokeLinejoin: "round",
          strokeMiterlimit: 10,
          strokeWidth: 1.5,
          children: [
            /* @__PURE__ */ jsx("path", { d: "M6.918 14.854l2.993-3.889 3.414 2.68 2.929-3.78" }),
            /* @__PURE__ */ jsx("path", { d: "M19.668 2.35a1.922 1.922 0 11-1.922 1.922 1.921 1.921 0 011.922-1.922z" }),
            /* @__PURE__ */ jsx("path", { d: "M20.756 9.269a20.809 20.809 0 01.194 3.034c0 6.938-2.312 9.25-9.25 9.25s-9.25-2.312-9.25-9.25 2.313-9.25 9.25-9.25a20.931 20.931 0 012.983.187" })
          ]
        }
      )
    }
  );
};
var Plus = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsx(
    "svg",
    {
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: /* @__PURE__ */ jsxs("g", { fill: "none", stroke: fill, strokeLinecap: "round", strokeLinejoin: "round", strokeWidth: 1.5, children: [
        /* @__PURE__ */ jsx("path", { d: "M6 12h12" }),
        /* @__PURE__ */ jsx("path", { d: "M12 18V6" })
      ] })
    }
  );
};
var Minus = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsx(
    "svg",
    {
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: /* @__PURE__ */ jsx(
        "path",
        {
          d: "M6 12h12",
          fill: "none",
          stroke: fill,
          strokeLinecap: "round",
          strokeLinejoin: "round",
          strokeWidth: 1.5
        }
      )
    }
  );
};
var Eye = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsxs(
    "svg",
    {
      fill: "none",
      height: size || height || 24,
      viewBox: "0 0 20 20",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: [
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M12.9833 10C12.9833 11.65 11.65 12.9833 10 12.9833C8.35 12.9833 7.01666 11.65 7.01666 10C7.01666 8.35 8.35 7.01666 10 7.01666C11.65 7.01666 12.9833 8.35 12.9833 10Z",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 1.5
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M9.99999 16.8916C12.9417 16.8916 15.6833 15.1583 17.5917 12.1583C18.3417 10.9833 18.3417 9.00831 17.5917 7.83331C15.6833 4.83331 12.9417 3.09998 9.99999 3.09998C7.05833 3.09998 4.31666 4.83331 2.40833 7.83331C1.65833 9.00831 1.65833 10.9833 2.40833 12.1583C4.31666 15.1583 7.05833 16.8916 9.99999 16.8916Z",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 1.5
          }
        )
      ]
    }
  );
};
var Edit = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsxs(
    "svg",
    {
      fill: "none",
      height: size || height || 24,
      viewBox: "0 0 20 20",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: [
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M11.05 3.00002L4.20835 10.2417C3.95002 10.5167 3.70002 11.0584 3.65002 11.4334L3.34169 14.1334C3.23335 15.1084 3.93335 15.775 4.90002 15.6084L7.58335 15.15C7.95835 15.0834 8.48335 14.8084 8.74168 14.525L15.5834 7.28335C16.7667 6.03335 17.3 4.60835 15.4583 2.86668C13.625 1.14168 12.2334 1.75002 11.05 3.00002Z",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: 10,
            strokeWidth: 1.5
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M9.90833 4.20831C10.2667 6.50831 12.1333 8.26665 14.45 8.49998",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: 10,
            strokeWidth: 1.5
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M2.5 18.3333H17.5",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: 10,
            strokeWidth: 1.5
          }
        )
      ]
    }
  );
};
var Delete = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsxs(
    "svg",
    {
      fill: "none",
      height: size || height || 24,
      viewBox: "0 0 20 20",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: [
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M17.5 4.98332C14.725 4.70832 11.9333 4.56665 9.15 4.56665C7.5 4.56665 5.85 4.64998 4.2 4.81665L2.5 4.98332",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 1.5
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M7.08331 4.14169L7.26665 3.05002C7.39998 2.25835 7.49998 1.66669 8.90831 1.66669H11.0916C12.5 1.66669 12.6083 2.29169 12.7333 3.05835L12.9166 4.14169",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 1.5
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M15.7084 7.61664L15.1667 16.0083C15.075 17.3166 15 18.3333 12.675 18.3333H7.32502C5.00002 18.3333 4.92502 17.3166 4.83335 16.0083L4.29169 7.61664",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 1.5
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M8.60834 13.75H11.3833",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 1.5
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M7.91669 10.4167H12.0834",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 1.5
          }
        )
      ]
    }
  );
};
var ChevronDown = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsx(
    "svg",
    {
      fill: "none",
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: /* @__PURE__ */ jsx(
        "path",
        {
          d: "m19.92 8.95-6.52 6.52c-.77.77-2.03.77-2.8 0L4.08 8.95",
          stroke: fill,
          strokeLinecap: "round",
          strokeLinejoin: "round",
          strokeMiterlimit: 10,
          strokeWidth: 1.5
        }
      )
    }
  );
};
var ChevronDownBold = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsx(
    "svg",
    {
      fill: "none",
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: /* @__PURE__ */ jsx(
        "path",
        {
          d: "M17.9188 8.17969H11.6888H6.07877C5.11877 8.17969 4.63877 9.33969 5.31877 10.0197L10.4988 15.1997C11.3288 16.0297 12.6788 16.0297 13.5088 15.1997L15.4788 13.2297L18.6888 10.0197C19.3588 9.33969 18.8788 8.17969 17.9188 8.17969Z",
          fill
        }
      )
    }
  );
};
var NewFile = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsxs(
    "svg",
    {
      fill: "none",
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: [
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M8 2V5",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: 10,
            strokeWidth: 1.5
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M16 2V5",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: 10,
            strokeWidth: 1.5
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M21 8.5V13.63C20.11 12.92 18.98 12.5 17.75 12.5C16.52 12.5 15.37 12.93 14.47 13.66C13.26 14.61 12.5 16.1 12.5 17.75C12.5 18.73 12.78 19.67 13.26 20.45C13.63 21.06 14.11 21.59 14.68 22H8C4.5 22 3 20 3 17V8.5C3 5.5 4.5 3.5 8 3.5H16C19.5 3.5 21 5.5 21 8.5Z",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: 10,
            strokeWidth: 1.5
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M7 11H13",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: 10,
            strokeWidth: 1.5
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M7 16H9.62",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: 10,
            strokeWidth: 1.5
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M23 17.75C23 18.73 22.72 19.67 22.24 20.45C21.96 20.93 21.61 21.35 21.2 21.69C20.28 22.51 19.08 23 17.75 23C16.6 23 15.54 22.63 14.68 22C14.11 21.59 13.63 21.06 13.26 20.45C12.78 19.67 12.5 18.73 12.5 17.75C12.5 16.1 13.26 14.61 14.47 13.66C15.37 12.93 16.52 12.5 17.75 12.5C18.98 12.5 20.11 12.92 21 13.63C22.22 14.59 23 16.08 23 17.75Z",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: 10,
            strokeWidth: 1.5
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M17.75 20.25C17.75 18.87 18.87 17.75 20.25 17.75C18.87 17.75 17.75 16.63 17.75 15.25C17.75 16.63 16.63 17.75 15.25 17.75C16.63 17.75 17.75 18.87 17.75 20.25Z",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 1.5
          }
        )
      ]
    }
  );
};
var AddNoteBulk = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsxs(
    "svg",
    {
      fill: "none",
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: [
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M7.37 22h9.25a4.87 4.87 0 0 0 4.87-4.87V8.37a4.87 4.87 0 0 0-4.87-4.87H7.37A4.87 4.87 0 0 0 2.5 8.37v8.75c0 2.7 2.18 4.88 4.87 4.88Z",
            fill,
            opacity: 0.4
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M8.29 6.29c-.42 0-.75-.34-.75-.75V2.75a.749.749 0 1 1 1.5 0v2.78c0 .42-.33.76-.75.76ZM15.71 6.29c-.42 0-.75-.34-.75-.75V2.75a.749.749 0 1 1 1.5 0v2.78c0 .42-.33.76-.75.76ZM12 14.75h-1.69V13c0-.41-.34-.75-.75-.75s-.75.34-.75.75v1.75H7c-.41 0-.75.34-.75.75s.34.75.75.75h1.81V18c0 .41.34.75.75.75s.75-.34.75-.75v-1.75H12c.41 0 .75-.34.75-.75s-.34-.75-.75-.75Z",
            fill
          }
        )
      ]
    }
  );
};
var CopyDocumentBulk = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsxs(
    "svg",
    {
      fill: "none",
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: [
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M15.5 13.15h-2.17c-1.78 0-3.23-1.44-3.23-3.23V7.75c0-.41-.33-.75-.75-.75H6.18C3.87 7 2 8.5 2 11.18v6.64C2 20.5 3.87 22 6.18 22h5.89c2.31 0 4.18-1.5 4.18-4.18V13.9c0-.42-.34-.75-.75-.75Z",
            fill,
            opacity: 0.4
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M17.82 2H11.93C9.67 2 7.84 3.44 7.76 6.01c.06 0 .11-.01.17-.01h5.89C16.13 6 18 7.5 18 10.18V16.83c0 .06-.01.11-.01.16 2.23-.07 4.01-1.55 4.01-4.16V6.18C22 3.5 20.13 2 17.82 2Z",
            fill
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M11.98 7.15c-.31-.31-.84-.1-.84.33v2.62c0 1.1.93 2 2.07 2 .71.01 1.7.01 2.55.01.43 0 .65-.5.35-.8-1.09-1.09-3.03-3.04-4.13-4.16Z",
            fill
          }
        )
      ]
    }
  );
};
var EditDocumentBulk = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsxs(
    "svg",
    {
      fill: "none",
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: [
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M15.48 3H7.52C4.07 3 2 5.06 2 8.52v7.95C2 19.94 4.07 22 7.52 22h7.95c3.46 0 5.52-2.06 5.52-5.52V8.52C21 5.06 18.93 3 15.48 3Z",
            fill,
            opacity: 0.4
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M21.02 2.98c-1.79-1.8-3.54-1.84-5.38 0L14.51 4.1c-.1.1-.13.24-.09.37.7 2.45 2.66 4.41 5.11 5.11.03.01.08.01.11.01.1 0 .2-.04.27-.11l1.11-1.12c.91-.91 1.36-1.78 1.36-2.67 0-.9-.45-1.79-1.36-2.71ZM17.86 10.42c-.27-.13-.53-.26-.77-.41-.2-.12-.4-.25-.59-.39-.16-.1-.34-.25-.52-.4-.02-.01-.08-.06-.16-.14-.31-.25-.64-.59-.95-.96-.02-.02-.08-.08-.13-.17-.1-.11-.25-.3-.38-.51-.11-.14-.24-.34-.36-.55-.15-.25-.28-.5-.4-.76-.13-.28-.23-.54-.32-.79L7.9 10.72c-.35.35-.69 1.01-.76 1.5l-.43 2.98c-.09.63.08 1.22.47 1.61.33.33.78.5 1.28.5.11 0 .22-.01.33-.02l2.97-.42c.49-.07 1.15-.4 1.5-.76l5.38-5.38c-.25-.08-.5-.19-.78-.31Z",
            fill
          }
        )
      ]
    }
  );
};
var DeleteDocumentBulk = ({ fill, size, height, width, ...props }) => {
  return /* @__PURE__ */ jsxs(
    "svg",
    {
      fill: "none",
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: [
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M21.07 5.23c-1.61-.16-3.22-.28-4.84-.37v-.01l-.22-1.3c-.15-.92-.37-2.3-2.71-2.3h-2.62c-2.33 0-2.55 1.32-2.71 2.29l-.21 1.28c-.93.06-1.86.12-2.79.21l-2.04.2c-.42.04-.72.41-.68.82.04.41.4.71.82.67l2.04-.2c5.24-.52 10.52-.32 15.82.21h.08c.38 0 .71-.29.75-.68a.766.766 0 0 0-.69-.82Z",
            fill
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M19.23 8.14c-.24-.25-.57-.39-.91-.39H5.68c-.34 0-.68.14-.91.39-.23.25-.36.59-.34.94l.62 10.26c.11 1.52.25 3.42 3.74 3.42h6.42c3.49 0 3.63-1.89 3.74-3.42l.62-10.25c.02-.36-.11-.7-.34-.95Z",
            fill,
            opacity: 0.399
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            clipRule: "evenodd",
            d: "M9.58 17a.75.75 0 0 1 .75-.75h3.33a.75.75 0 0 1 0 1.5h-3.33a.75.75 0 0 1-.75-.75ZM8.75 13a.75.75 0 0 1 .75-.75h5a.75.75 0 0 1 0 1.5h-5a.75.75 0 0 1-.75-.75Z",
            fill,
            fillRule: "evenodd"
          }
        )
      ]
    }
  );
};
var CartIcon = ({
  fill = "currentColor",
  size,
  height,
  width,
  ...props
}) => {
  return /* @__PURE__ */ jsxs(
    "svg",
    {
      fill: "none",
      height: size || height || 24,
      viewBox: "0 0 24 24",
      width: size || width || 24,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: [
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M16.25 22.5C17.2165 22.5 18 21.7165 18 20.75C18 19.7835 17.2165 19 16.25 19C15.2835 19 14.5 19.7835 14.5 20.75C14.5 21.7165 15.2835 22.5 16.25 22.5Z",
            fill
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M8.25 22.5C9.2165 22.5 10 21.7165 10 20.75C10 19.7835 9.2165 19 8.25 19C7.2835 19 6.5 19.7835 6.5 20.75C6.5 21.7165 7.2835 22.5 8.25 22.5Z",
            fill
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M4.84 3.94L4.64 6.39C4.6 6.86 4.97 7.25 5.44 7.25H20.75C21.17 7.25 21.52 6.93 21.55 6.51C21.68 4.74 20.33 3.3 18.56 3.3H6.27C6.17 2.86 5.97 2.44 5.66 2.09C5.16 1.56 4.46 1.25 3.74 1.25H2C1.59 1.25 1.25 1.59 1.25 2C1.25 2.41 1.59 2.75 2 2.75H3.74C4.05 2.75 4.34 2.88 4.55 3.1C4.76 3.33 4.86 3.63 4.84 3.94Z",
            fill
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M20.5101 8.75H5.17005C4.75005 8.75 4.41005 9.07 4.37005 9.48L4.01005 13.83C3.87005 15.54 5.21005 17 6.92005 17H18.0401C19.5401 17 20.8601 15.77 20.9701 14.27L21.3001 9.6C21.3401 9.14 20.9801 8.75 20.5101 8.75Z",
            fill
          }
        )
      ]
    }
  );
};
var Flash = ({
  fill = "currentColor",
  size,
  height,
  width,
  ...props
}) => {
  return /* @__PURE__ */ jsx(
    "svg",
    {
      fill: "none",
      height: size || height,
      viewBox: "0 0 24 24",
      width: size || width,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: /* @__PURE__ */ jsx(
        "path",
        {
          d: "M6.09 13.28h3.09v7.2c0 1.68.91 2.02 2.02.76l7.57-8.6c.93-1.05.54-1.92-.87-1.92h-3.09v-7.2c0-1.68-.91-2.02-2.02-.76l-7.57 8.6c-.92 1.06-.53 1.92.87 1.92Z",
          stroke: fill,
          strokeLinecap: "round",
          strokeLinejoin: "round",
          strokeMiterlimit: 10,
          strokeWidth: 1.5
        }
      )
    }
  );
};
var Server = ({
  fill = "currentColor",
  size,
  height,
  width,
  ...props
}) => {
  return /* @__PURE__ */ jsx(
    "svg",
    {
      fill: "none",
      height: size || height,
      viewBox: "0 0 24 24",
      width: size || width,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: /* @__PURE__ */ jsx(
        "path",
        {
          d: "M19.32 10H4.69c-1.48 0-2.68-1.21-2.68-2.68V4.69c0-1.48 1.21-2.68 2.68-2.68h14.63C20.8 2.01 22 3.22 22 4.69v2.63C22 8.79 20.79 10 19.32 10ZM19.32 22H4.69c-1.48 0-2.68-1.21-2.68-2.68v-2.63c0-1.48 1.21-2.68 2.68-2.68h14.63c1.48 0 2.68 1.21 2.68 2.68v2.63c0 1.47-1.21 2.68-2.68 2.68ZM6 5v2M10 5v2M6 17v2M10 17v2M14 6h4M14 18h4",
          stroke: fill,
          strokeLinecap: "round",
          strokeLinejoin: "round",
          strokeWidth: 1.5
        }
      )
    }
  );
};
var TagUser = ({
  fill = "currentColor",
  size,
  height,
  width,
  ...props
}) => {
  return /* @__PURE__ */ jsxs(
    "svg",
    {
      fill: "none",
      height: size || height,
      viewBox: "0 0 24 24",
      width: size || width,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: [
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M18 18.86h-.76c-.8 0-1.56.31-2.12.87l-1.71 1.69c-.78.77-2.05.77-2.83 0l-1.71-1.69c-.56-.56-1.33-.87-2.12-.87H6c-1.66 0-3-1.33-3-2.97V4.98c0-1.64 1.34-2.97 3-2.97h12c1.66 0 3 1.33 3 2.97v10.91c0 1.63-1.34 2.97-3 2.97Z",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeMiterlimit: 10,
            strokeWidth: 1.5
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M12 10a2.33 2.33 0 1 0 0-4.66A2.33 2.33 0 0 0 12 10ZM16 15.66c0-1.8-1.79-3.26-4-3.26s-4 1.46-4 3.26",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 1.5
          }
        )
      ]
    }
  );
};
var Scale = ({
  fill = "currentColor",
  size,
  height,
  width,
  ...props
}) => {
  return /* @__PURE__ */ jsxs(
    "svg",
    {
      fill: "none",
      height: size || height,
      viewBox: "0 0 24 24",
      width: size || width,
      xmlns: "http://www.w3.org/2000/svg",
      ...props,
      children: [
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M9 22h6c5 0 7-2 7-7V9c0-5-2-7-7-7H9C4 2 2 4 2 9v6c0 5 2 7 7 7ZM18 6 6 18",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 1.5
          }
        ),
        /* @__PURE__ */ jsx(
          "path",
          {
            d: "M18 10V6h-4M6 14v4h4",
            stroke: fill,
            strokeLinecap: "round",
            strokeLinejoin: "round",
            strokeWidth: 1.5
          }
        )
      ]
    }
  );
};
var Search = ({ size, fill, width = 24, height = 24, ...props }) => {
  return /* @__PURE__ */ jsx("svg", { fill: "none", height: size || height, viewBox: "0 0 24 24", width: size || width, ...props, children: /* @__PURE__ */ jsx(
    "path",
    {
      d: "M11.5 21a9.5 9.5 0 1 0 0-19 9.5 9.5 0 0 0 0 19ZM22 22l-2-2",
      stroke: fill,
      strokeLinecap: "round",
      strokeLinejoin: "round",
      strokeWidth: 2
    }
  ) });
};

export {
  Sun,
  Mail,
  Moon,
  Lock,
  Unlock,
  Password,
  Notification,
  User,
  VolumeUp,
  Camera,
  Activity,
  Plus,
  Minus,
  Eye,
  Edit,
  Delete,
  ChevronDown,
  ChevronDownBold,
  NewFile,
  AddNoteBulk,
  CopyDocumentBulk,
  EditDocumentBulk,
  DeleteDocumentBulk,
  CartIcon,
  Flash,
  Server,
  TagUser,
  Scale,
  Search
};
