"use client";
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/slider.tsx
var slider_exports = {};
__export(slider_exports, {
  default: () => slider_default
});
module.exports = __toCommonJS(slider_exports);
var import_react_utils4 = require("@heroui/react-utils");
var import_system3 = require("@heroui/system");

// src/slider-thumb.tsx
var import_system = require("@heroui/system");
var import_tooltip = require("@heroui/tooltip");
var import_react_utils2 = require("@heroui/react-utils");
var import_visually_hidden = require("@react-aria/visually-hidden");

// src/use-slider-thumb.ts
var import_slider = require("@react-aria/slider");
var import_react_utils = require("@heroui/react-utils");
var import_react = require("react");
var import_interactions = require("@react-aria/interactions");
var import_focus = require("@react-aria/focus");
var import_utils = require("@react-aria/utils");
var import_shared_utils = require("@heroui/shared-utils");
var import_i18n = require("@react-aria/i18n");
function useSliderThumb(props) {
  const {
    ref,
    as,
    state,
    index,
    name,
    trackRef,
    className,
    tooltipProps,
    isVertical,
    showTooltip,
    formatOptions,
    renderThumb,
    ...otherProps
  } = props;
  const Component = as || "div";
  const domRef = (0, import_react_utils.useDOMRef)(ref);
  const inputRef = (0, import_react.useRef)(null);
  const numberFormatter = (0, import_i18n.useNumberFormatter)(formatOptions);
  const { thumbProps, inputProps, isDragging, isFocused } = (0, import_slider.useSliderThumb)(
    {
      index,
      trackRef,
      inputRef,
      name,
      ...otherProps
    },
    state
  );
  const { hoverProps, isHovered } = (0, import_interactions.useHover)({
    isDisabled: state.isDisabled
  });
  const { focusProps, isFocusVisible } = (0, import_focus.useFocusRing)();
  const { pressProps, isPressed } = (0, import_interactions.usePress)({
    isDisabled: state.isDisabled
  });
  const getThumbProps = (props2 = {}) => {
    return {
      ref: domRef,
      "data-slot": "thumb",
      "data-hover": (0, import_shared_utils.dataAttr)(isHovered),
      "data-pressed": (0, import_shared_utils.dataAttr)(isPressed),
      "data-dragging": (0, import_shared_utils.dataAttr)(isDragging),
      "data-focused": (0, import_shared_utils.dataAttr)(isFocused),
      "data-focus-visible": (0, import_shared_utils.dataAttr)(isFocusVisible),
      ...(0, import_utils.mergeProps)(thumbProps, pressProps, hoverProps, otherProps),
      className,
      ...props2
    };
  };
  const getTooltipProps = () => {
    const value = numberFormatter ? numberFormatter.format(state.values[index != null ? index : 0]) : state.values[index != null ? index : 0];
    return {
      ...tooltipProps,
      placement: (tooltipProps == null ? void 0 : tooltipProps.placement) ? tooltipProps == null ? void 0 : tooltipProps.placement : isVertical ? "right" : "top",
      content: (tooltipProps == null ? void 0 : tooltipProps.content) ? tooltipProps == null ? void 0 : tooltipProps.content : value,
      updatePositionDeps: [isDragging, isHovered, value],
      isOpen: (tooltipProps == null ? void 0 : tooltipProps.isOpen) !== void 0 ? tooltipProps == null ? void 0 : tooltipProps.isOpen : isHovered || isDragging
    };
  };
  const getInputProps = (props2 = {}) => {
    return {
      ref: inputRef,
      ...(0, import_utils.mergeProps)(inputProps, focusProps),
      ...props2
    };
  };
  return {
    Component,
    index,
    showTooltip,
    renderThumb,
    getThumbProps,
    getTooltipProps,
    getInputProps
  };
}

// src/slider-thumb.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var SliderThumb = (0, import_system.forwardRef)((props, ref) => {
  const {
    Component,
    index,
    renderThumb,
    showTooltip,
    getTooltipProps,
    getThumbProps,
    getInputProps
  } = useSliderThumb({
    ...props,
    ref
  });
  const thumbProps = {
    ...getThumbProps(),
    index,
    children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_visually_hidden.VisuallyHidden, { children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)("input", { ...getInputProps() }) })
  };
  const content = (0, import_react_utils2.renderFn)({
    Component,
    props: thumbProps,
    renderCustom: renderThumb
  });
  return showTooltip ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_tooltip.Tooltip, { ...getTooltipProps(), children: content }) : content;
});
SliderThumb.displayName = "HeroUI.SliderThumb";
var slider_thumb_default = SliderThumb;

// src/use-slider.ts
var import_system2 = require("@heroui/system");
var import_theme = require("@heroui/theme");
var import_react_utils3 = require("@heroui/react-utils");
var import_slider2 = require("@react-stately/slider");
var import_react2 = require("react");
var import_i18n2 = require("@react-aria/i18n");
var import_utils2 = require("@react-aria/utils");
var import_slider3 = require("@react-aria/slider");
var import_shared_utils2 = require("@heroui/shared-utils");
var import_interactions2 = require("@react-aria/interactions");
function useSlider(originalProps) {
  var _a, _b, _c, _d;
  const globalContext = (0, import_system2.useProviderContext)();
  const [props, variantProps] = (0, import_system2.mapPropsVariants)(originalProps, import_theme.slider.variantKeys);
  const {
    ref,
    as,
    name,
    label,
    formatOptions,
    value: valueProp,
    maxValue = 100,
    minValue = 0,
    step = 1,
    showSteps = false,
    showTooltip = false,
    orientation = "horizontal",
    marks = [],
    startContent,
    endContent,
    fillOffset,
    className,
    classNames,
    renderThumb,
    renderLabel,
    renderValue,
    onChange,
    onChangeEnd,
    getValue,
    tooltipValueFormatOptions = formatOptions,
    tooltipProps: userTooltipProps = {},
    ...otherProps
  } = props;
  const Component = as || "div";
  const shouldFilterDOMProps = typeof Component === "string";
  const disableAnimation = (_b = (_a = originalProps == null ? void 0 : originalProps.disableAnimation) != null ? _a : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _b : false;
  const domRef = (0, import_react_utils3.useDOMRef)(ref);
  const trackRef = (0, import_react2.useRef)(null);
  const numberFormatter = (0, import_i18n2.useNumberFormatter)(formatOptions);
  const { direction } = (0, import_i18n2.useLocale)();
  const clampValue = (0, import_react2.useCallback)(
    (valueToClamp) => Math.min(Math.max(valueToClamp, minValue), maxValue),
    [minValue, maxValue]
  );
  const validatedValue = (0, import_react2.useMemo)(() => {
    if (valueProp === void 0) return void 0;
    if (Array.isArray(valueProp)) {
      return valueProp.map(clampValue);
    }
    return clampValue(valueProp);
  }, [valueProp, clampValue]);
  const state = (0, import_slider2.useSliderState)({
    ...otherProps,
    value: validatedValue,
    isDisabled: (_c = originalProps == null ? void 0 : originalProps.isDisabled) != null ? _c : false,
    orientation,
    step,
    minValue,
    maxValue,
    numberFormatter,
    onChange,
    onChangeEnd
  });
  const tooltipProps = {
    offset: 5,
    delay: 0,
    size: "sm",
    showArrow: true,
    color: (originalProps == null ? void 0 : originalProps.color) ? originalProps == null ? void 0 : originalProps.color : (_d = import_theme.slider.defaultVariants) == null ? void 0 : _d.color,
    isDisabled: originalProps.isDisabled,
    ...userTooltipProps
  };
  const { groupProps, trackProps, labelProps, outputProps } = (0, import_slider3.useSlider)(
    originalProps,
    state,
    trackRef
  );
  const { isHovered, hoverProps } = (0, import_interactions2.useHover)({ isDisabled: originalProps.isDisabled });
  const baseStyles = (0, import_shared_utils2.clsx)(classNames == null ? void 0 : classNames.base, className);
  const isVertical = orientation === "vertical";
  const hasMarks = (marks == null ? void 0 : marks.length) > 0;
  const hasSingleThumb = fillOffset === void 0 ? state.values.length === 1 : false;
  const slots = (0, import_react2.useMemo)(
    () => (0, import_theme.slider)({
      ...variantProps,
      hasMarks,
      disableAnimation,
      hasSingleThumb,
      isVertical
    }),
    [(0, import_shared_utils2.objectToDeps)(variantProps), isVertical, disableAnimation, hasSingleThumb, hasMarks]
  );
  const [startOffset, endOffset] = [
    state.values.length > 1 ? state.getThumbPercent(0) : fillOffset !== void 0 ? state.getValuePercent(fillOffset) : 0,
    state.getThumbPercent(state.values.length - 1)
  ].sort();
  const value = state.values.length === 1 ? numberFormatter.format(state.values[0]) : numberFormatter.formatRange(state.values[0], state.values[state.values.length - 1]);
  const steps = showSteps ? Math.floor((maxValue - minValue) / step) + 1 : 0;
  const getBaseProps = (props2 = {}) => {
    return {
      ref: domRef,
      "data-orientation": state.orientation,
      "data-slot": "base",
      "data-hover": isHovered,
      className: slots.base({ class: baseStyles }),
      ...(0, import_utils2.mergeProps)(
        groupProps,
        hoverProps,
        (0, import_react_utils3.filterDOMProps)(otherProps, {
          enabled: shouldFilterDOMProps
        }),
        (0, import_react_utils3.filterDOMProps)(props2)
      )
    };
  };
  const getLabelWrapperProps = (props2 = {}) => {
    return {
      className: slots.labelWrapper({ class: classNames == null ? void 0 : classNames.labelWrapper }),
      "data-slot": "labelWrapper",
      ...props2
    };
  };
  const getLabelProps = (props2 = {}) => {
    return {
      "data-slot": "label",
      className: slots.label({ class: classNames == null ? void 0 : classNames.label }),
      children: label,
      ...labelProps,
      ...props2
    };
  };
  const getValueProps = (props2 = {}) => {
    return {
      "data-slot": "value",
      className: slots.value({ class: classNames == null ? void 0 : classNames.value }),
      children: getValue && typeof getValue === "function" ? getValue(state.values) : value,
      ...outputProps,
      ...props2
    };
  };
  const getTrackProps = (props2 = {}) => {
    const fillWidth = (endOffset - startOffset) * 100;
    return {
      ref: trackRef,
      "data-slot": "track",
      "data-thumb-hidden": !!(originalProps == null ? void 0 : originalProps.hideThumb),
      "data-vertical": isVertical,
      ...hasSingleThumb ? {
        "data-fill-start": fillWidth > 0,
        "data-fill-end": fillWidth == 100
      } : {
        "data-fill-start": startOffset == 0,
        "data-fill-end": startOffset * 100 + fillWidth == 100
      },
      className: slots.track({ class: classNames == null ? void 0 : classNames.track }),
      ...trackProps,
      ...props2
    };
  };
  const getTrackWrapperProps = (props2 = {}) => {
    return {
      "data-slot": "track-wrapper",
      className: slots.trackWrapper({ class: classNames == null ? void 0 : classNames.trackWrapper }),
      ...props2
    };
  };
  const getFillerProps = (props2 = {}) => {
    return {
      "data-slot": "filler",
      className: slots.filler({ class: classNames == null ? void 0 : classNames.filler }),
      ...props2,
      style: {
        ...props2.style,
        [isVertical ? "bottom" : direction === "rtl" ? "right" : "left"]: `${startOffset * 100}%`,
        ...isVertical ? {
          height: `${(endOffset - startOffset) * 100}%`
        } : {
          width: `${(endOffset - startOffset) * 100}%`
        }
      }
    };
  };
  const getThumbProps = (index) => {
    return {
      name,
      index,
      state,
      trackRef,
      orientation,
      isVertical,
      tooltipProps,
      showTooltip,
      renderThumb,
      formatOptions: tooltipValueFormatOptions,
      className: slots.thumb({ class: classNames == null ? void 0 : classNames.thumb })
    };
  };
  const getStepProps = (index) => {
    const percent = state.getValuePercent(index * step + minValue);
    return {
      className: slots.step({ class: classNames == null ? void 0 : classNames.step }),
      "data-slot": "step",
      "data-in-range": percent <= endOffset && percent >= startOffset,
      style: {
        [isVertical ? "bottom" : direction === "rtl" ? "right" : "left"]: `${percent * 100}%`
      }
    };
  };
  const getMarkProps = (mark) => {
    const percent = state.getValuePercent(mark.value);
    return {
      className: slots.mark({ class: classNames == null ? void 0 : classNames.mark }),
      "data-slot": "mark",
      "data-in-range": percent <= endOffset && percent >= startOffset,
      style: {
        [isVertical ? "bottom" : direction === "rtl" ? "right" : "left"]: `${percent * 100}%`
      },
      // avoid `onDownTrack` is being called since when you click the mark,
      // `onDownTrack` will calculate the percent based on the position you click
      // the calculated value will be set instead of the actual value defined in `marks`
      onMouseDown: (e) => e.stopPropagation(),
      onPointerDown: (e) => e.stopPropagation(),
      onClick: (e) => {
        e.stopPropagation();
        if (state.values.length === 1) {
          state.setThumbPercent(0, percent);
        } else {
          const leftThumbVal = state.values[0];
          const rightThumbVal = state.values[1];
          if (mark.value < leftThumbVal) {
            state.setThumbPercent(0, percent);
          } else if (mark.value > rightThumbVal) {
            state.setThumbPercent(1, percent);
          } else if (Math.abs(mark.value - leftThumbVal) < Math.abs(mark.value - rightThumbVal)) {
            state.setThumbPercent(0, percent);
          } else {
            state.setThumbPercent(1, percent);
          }
        }
      }
    };
  };
  const getStartContentProps = (props2 = {}) => ({
    "data-slot": "startContent",
    className: slots.startContent({ class: classNames == null ? void 0 : classNames.startContent }),
    ...props2
  });
  const getEndContentProps = (props2 = {}) => ({
    "data-slot": "endContent",
    className: slots.endContent({ class: classNames == null ? void 0 : classNames.endContent }),
    ...props2
  });
  return {
    Component,
    state,
    value,
    domRef,
    label,
    steps,
    marks,
    startContent,
    endContent,
    getStepProps,
    getBaseProps,
    getValue,
    renderLabel,
    renderValue,
    getTrackWrapperProps,
    getLabelWrapperProps,
    getLabelProps,
    getValueProps,
    getTrackProps,
    getFillerProps,
    getThumbProps,
    getMarkProps,
    getStartContentProps,
    getEndContentProps
  };
}

// src/slider.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var Slider = (0, import_system3.forwardRef)((props, ref) => {
  const {
    Component,
    state,
    label,
    steps,
    marks,
    startContent,
    endContent,
    getStepProps,
    getBaseProps,
    renderValue,
    renderLabel,
    getTrackWrapperProps,
    getLabelWrapperProps,
    getLabelProps,
    getValueProps,
    getTrackProps,
    getFillerProps,
    getThumbProps,
    getMarkProps,
    getStartContentProps,
    getEndContentProps
  } = useSlider({ ...props, ref });
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(Component, { ...getBaseProps(), children: [
    label && /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { ...getLabelWrapperProps(), children: [
      (0, import_react_utils4.renderFn)({
        Component: "label",
        props: getLabelProps(),
        renderCustom: renderLabel
      }),
      (0, import_react_utils4.renderFn)({
        Component: "output",
        props: getValueProps(),
        renderCustom: renderValue
      })
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { ...getTrackWrapperProps(), children: [
      startContent && /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { ...getStartContentProps(), children: startContent }),
      /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { ...getTrackProps(), children: [
        /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { ...getFillerProps() }),
        Number.isFinite(steps) && Array.from({ length: steps }, (_, index) => /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { ...getStepProps(index) }, index)),
        state.values.map((_, index) => /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(slider_thumb_default, { ...getThumbProps(index) }, index)),
        (marks == null ? void 0 : marks.length) > 0 && marks.map((mark, index) => /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { ...getMarkProps(mark), children: mark.label }, index))
      ] }),
      endContent && /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { ...getEndContentProps(), children: endContent })
    ] })
  ] });
});
Slider.displayName = "HeroUI.Slider";
var slider_default = Slider;
