import * as _heroui_system_src_types from '@heroui/system/src/types';
import * as tailwind_variants from 'tailwind-variants';
import * as react from 'react';
import { Ref } from 'react';
import { SpinnerVariantProps, SlotsToClasses, SpinnerSlots } from '@heroui/theme';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system-rsc';

interface Props extends HTMLHeroUIProps<"div"> {
    /**
     * Ref to the DOM node.
     */
    ref?: Ref<HTMLElement | null>;
    /**
     * Spinner label, in case you passed it will be used as `aria-label`.
     */
    label?: string;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <Spinner classNames={{
     *    base:"base-classes",
     *    wrapper: "wrapper-classes",
     *    circle1: "circle1-classes",
     *    circle2: "circle2-classes",
     *    label: "label-classes"
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<SpinnerSlots>;
}
type UseSpinnerProps = Props & SpinnerVariantProps;
declare function useSpinner(originalProps: UseSpinnerProps): {
    label: react.ReactNode;
    slots: {
        base: (slotProps?: ({
            color?: "current" | "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "white" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            variant?: "default" | "dots" | "gradient" | "wave" | "simple" | "spinner" | undefined;
            labelColor?: "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        wrapper: (slotProps?: ({
            color?: "current" | "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "white" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            variant?: "default" | "dots" | "gradient" | "wave" | "simple" | "spinner" | undefined;
            labelColor?: "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        label: (slotProps?: ({
            color?: "current" | "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "white" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            variant?: "default" | "dots" | "gradient" | "wave" | "simple" | "spinner" | undefined;
            labelColor?: "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        circle1: (slotProps?: ({
            color?: "current" | "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "white" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            variant?: "default" | "dots" | "gradient" | "wave" | "simple" | "spinner" | undefined;
            labelColor?: "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        circle2: (slotProps?: ({
            color?: "current" | "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "white" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            variant?: "default" | "dots" | "gradient" | "wave" | "simple" | "spinner" | undefined;
            labelColor?: "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        dots: (slotProps?: ({
            color?: "current" | "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "white" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            variant?: "default" | "dots" | "gradient" | "wave" | "simple" | "spinner" | undefined;
            labelColor?: "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        spinnerBars: (slotProps?: ({
            color?: "current" | "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "white" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            variant?: "default" | "dots" | "gradient" | "wave" | "simple" | "spinner" | undefined;
            labelColor?: "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            color?: "current" | "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "white" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            variant?: "default" | "dots" | "gradient" | "wave" | "simple" | "spinner" | undefined;
            labelColor?: "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        wrapper: (slotProps?: ({
            color?: "current" | "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "white" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            variant?: "default" | "dots" | "gradient" | "wave" | "simple" | "spinner" | undefined;
            labelColor?: "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        label: (slotProps?: ({
            color?: "current" | "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "white" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            variant?: "default" | "dots" | "gradient" | "wave" | "simple" | "spinner" | undefined;
            labelColor?: "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        circle1: (slotProps?: ({
            color?: "current" | "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "white" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            variant?: "default" | "dots" | "gradient" | "wave" | "simple" | "spinner" | undefined;
            labelColor?: "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        circle2: (slotProps?: ({
            color?: "current" | "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "white" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            variant?: "default" | "dots" | "gradient" | "wave" | "simple" | "spinner" | undefined;
            labelColor?: "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        dots: (slotProps?: ({
            color?: "current" | "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "white" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            variant?: "default" | "dots" | "gradient" | "wave" | "simple" | "spinner" | undefined;
            labelColor?: "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        spinnerBars: (slotProps?: ({
            color?: "current" | "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "white" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            variant?: "default" | "dots" | "gradient" | "wave" | "simple" | "spinner" | undefined;
            labelColor?: "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    classNames: SlotsToClasses<"base" | "label" | "wrapper" | "circle1" | "circle2" | "dots" | "spinnerBars"> | undefined;
    variant: _heroui_system_src_types.SpinnerVariants;
    getSpinnerProps: PropGetter;
};
type UseSpinnerReturn = ReturnType<typeof useSpinner>;

export { type UseSpinnerProps, type UseSpinnerReturn, useSpinner };
