"use client";
import {
  useToast
} from "./chunk-D2JXYZ2A.mjs";

// src/toast.tsx
import { forwardRef as forwardRef2 } from "@heroui/system";

// ../button/src/button.tsx
import { Spinner } from "@heroui/spinner";

// ../ripple/src/ripple.tsx
import { AnimatePresence, m, LazyMotion } from "framer-motion";
import { clamp } from "@heroui/shared-utils";
import { Fragment, jsx } from "react/jsx-runtime";
var domAnimation = () => import("./src-UW24ZMRV.mjs").then((res) => res.default);
var Ripple = (props) => {
  const { ripples = [], motionProps, color = "currentColor", style, onClear } = props;
  return /* @__PURE__ */ jsx(Fragment, { children: ripples.map((ripple) => {
    const duration = clamp(0.01 * ripple.size, 0.2, ripple.size > 100 ? 0.75 : 0.5);
    return /* @__PURE__ */ jsx(LazyMotion, { features: domAnimation, children: /* @__PURE__ */ jsx(AnimatePresence, { mode: "popLayout", children: /* @__PURE__ */ jsx(
      m.span,
      {
        animate: { transform: "scale(2)", opacity: 0 },
        className: "heroui-ripple",
        exit: { opacity: 0 },
        initial: { transform: "scale(0)", opacity: 0.35 },
        style: {
          position: "absolute",
          backgroundColor: color,
          borderRadius: "100%",
          transformOrigin: "center",
          pointerEvents: "none",
          overflow: "hidden",
          inset: 0,
          zIndex: 0,
          top: ripple.y,
          left: ripple.x,
          width: `${ripple.size}px`,
          height: `${ripple.size}px`,
          ...style
        },
        transition: { duration },
        onAnimationComplete: () => {
          onClear(ripple.key);
        },
        ...motionProps
      }
    ) }) }, ripple.key);
  }) });
};
Ripple.displayName = "HeroUI.Ripple";
var ripple_default = Ripple;

// ../ripple/src/use-ripple.ts
import { getUniqueID } from "@heroui/shared-utils";
import { useCallback, useState } from "react";
function useRipple(props = {}) {
  const [ripples, setRipples] = useState([]);
  const onPress = useCallback((event) => {
    const trigger = event.target;
    const size = Math.max(trigger.clientWidth, trigger.clientHeight);
    setRipples((prevRipples) => [
      ...prevRipples,
      {
        key: getUniqueID(prevRipples.length.toString()),
        size,
        x: event.x - size / 2,
        y: event.y - size / 2
      }
    ]);
  }, []);
  const onClear = useCallback((key) => {
    setRipples((prevState) => prevState.filter((ripple) => ripple.key !== key));
  }, []);
  return { ripples, onClear, onPress, ...props };
}

// ../button/src/button.tsx
import { forwardRef } from "@heroui/system";

// ../button/src/use-button.ts
import { useProviderContext } from "@heroui/system";
import { dataAttr } from "@heroui/shared-utils";
import { useCallback as useCallback2 } from "react";

// ../../../node_modules/.pnpm/@react-aria+focus@3.20.2_react-dom@18.3.0_react@18.3.0__react@18.3.0/node_modules/@react-aria/focus/dist/useFocusRing.mjs
import { isFocusVisible as $isWE5$isFocusVisible, useFocusVisibleListener as $isWE5$useFocusVisibleListener, useFocus as $isWE5$useFocus, useFocusWithin as $isWE5$useFocusWithin } from "@react-aria/interactions";
import { useRef as $isWE5$useRef, useState as $isWE5$useState, useCallback as $isWE5$useCallback } from "react";
function $f7dceffc5ad7768b$export$4e328f61c538687f(props = {}) {
  let { autoFocus = false, isTextInput, within } = props;
  let state = (0, $isWE5$useRef)({
    isFocused: false,
    isFocusVisible: autoFocus || (0, $isWE5$isFocusVisible)()
  });
  let [isFocused, setFocused] = (0, $isWE5$useState)(false);
  let [isFocusVisibleState, setFocusVisible] = (0, $isWE5$useState)(() => state.current.isFocused && state.current.isFocusVisible);
  let updateState = (0, $isWE5$useCallback)(() => setFocusVisible(state.current.isFocused && state.current.isFocusVisible), []);
  let onFocusChange = (0, $isWE5$useCallback)((isFocused2) => {
    state.current.isFocused = isFocused2;
    setFocused(isFocused2);
    updateState();
  }, [
    updateState
  ]);
  (0, $isWE5$useFocusVisibleListener)((isFocusVisible) => {
    state.current.isFocusVisible = isFocusVisible;
    updateState();
  }, [], {
    isTextInput
  });
  let { focusProps } = (0, $isWE5$useFocus)({
    isDisabled: within,
    onFocusChange
  });
  let { focusWithinProps } = (0, $isWE5$useFocusWithin)({
    isDisabled: !within,
    onFocusWithinChange: onFocusChange
  });
  return {
    isFocused,
    isFocusVisible: isFocusVisibleState,
    focusProps: within ? focusWithinProps : focusProps
  };
}

// ../../../node_modules/.pnpm/@react-aria+focus@3.20.2_react-dom@18.3.0_react@18.3.0__react@18.3.0/node_modules/@react-aria/focus/dist/import.mjs
import { isFocusable as $d48f97c9d1a8e323$re_export$isFocusable } from "@react-aria/utils";
import { FocusableProvider as $d48f97c9d1a8e323$re_export$FocusableProvider, Focusable as $d48f97c9d1a8e323$re_export$Focusable, useFocusable as $d48f97c9d1a8e323$re_export$useFocusable, focusSafely as $d48f97c9d1a8e323$re_export$focusSafely } from "@react-aria/interactions";

// ../button/src/use-button.ts
import { chain, mergeProps as mergeProps2 } from "@react-aria/utils";
import { useDOMRef, filterDOMProps as filterDOMProps2 } from "@heroui/react-utils";
import { button } from "@heroui/theme";
import { isValidElement, cloneElement, useMemo } from "react";

// ../../hooks/use-aria-button/src/index.ts
import { filterDOMProps, mergeProps } from "@react-aria/utils";
import { usePress } from "@react-aria/interactions";
function useAriaButton(props, ref) {
  let {
    elementType = "button",
    isDisabled,
    onPress,
    onPressStart,
    onPressEnd,
    onPressChange,
    // @ts-ignore - undocumented
    preventFocusOnPress,
    // @ts-ignore - undocumented
    allowFocusWhenDisabled,
    onClick,
    href,
    target,
    rel,
    type = "button",
    allowTextSelectionOnPress
  } = props;
  let additionalProps;
  if (elementType === "button") {
    additionalProps = {
      type,
      disabled: isDisabled
    };
  } else {
    additionalProps = {
      role: "button",
      href: elementType === "a" && !isDisabled ? href : void 0,
      target: elementType === "a" ? target : void 0,
      type: elementType === "input" ? type : void 0,
      disabled: elementType === "input" ? isDisabled : void 0,
      "aria-disabled": !isDisabled || elementType === "input" ? void 0 : isDisabled,
      rel: elementType === "a" ? rel : void 0
    };
  }
  let { pressProps, isPressed } = usePress({
    onClick,
    onPressStart,
    onPressEnd,
    onPressChange,
    onPress,
    isDisabled,
    preventFocusOnPress,
    allowTextSelectionOnPress,
    ref
  });
  let { focusableProps } = $d48f97c9d1a8e323$re_export$useFocusable(props, ref);
  if (allowFocusWhenDisabled) {
    focusableProps.tabIndex = isDisabled ? -1 : focusableProps.tabIndex;
  }
  let buttonProps = mergeProps(
    focusableProps,
    pressProps,
    filterDOMProps(props, { labelable: true })
  );
  return {
    isPressed,
    // Used to indicate press state for visual
    buttonProps: mergeProps(additionalProps, buttonProps, {
      "aria-haspopup": props["aria-haspopup"],
      "aria-expanded": props["aria-expanded"],
      "aria-controls": props["aria-controls"],
      "aria-pressed": props["aria-pressed"],
      "aria-current": props["aria-current"]
    })
  };
}

// ../button/src/use-button.ts
import { useHover } from "@react-aria/interactions";

// ../button/src/button-group-context.ts
import { createContext } from "@heroui/react-utils";
var [ButtonGroupProvider, useButtonGroupContext] = createContext({
  name: "ButtonGroupContext",
  strict: false
});

// ../button/src/use-button.ts
function useButton(props) {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i;
  const groupContext = useButtonGroupContext();
  const globalContext = useProviderContext();
  const isInGroup = !!groupContext;
  const {
    ref,
    as,
    children,
    startContent: startContentProp,
    endContent: endContentProp,
    autoFocus,
    className,
    spinner,
    isLoading = false,
    disableRipple: disableRippleProp = false,
    fullWidth = (_a = groupContext == null ? void 0 : groupContext.fullWidth) != null ? _a : false,
    radius = groupContext == null ? void 0 : groupContext.radius,
    size = (_b = groupContext == null ? void 0 : groupContext.size) != null ? _b : "md",
    color = (_c = groupContext == null ? void 0 : groupContext.color) != null ? _c : "default",
    variant = (_d = groupContext == null ? void 0 : groupContext.variant) != null ? _d : "solid",
    disableAnimation = (_f = (_e = groupContext == null ? void 0 : groupContext.disableAnimation) != null ? _e : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _f : false,
    isDisabled: isDisabledProp = (_g = groupContext == null ? void 0 : groupContext.isDisabled) != null ? _g : false,
    isIconOnly = (_h = groupContext == null ? void 0 : groupContext.isIconOnly) != null ? _h : false,
    spinnerPlacement = "start",
    onPress,
    onClick,
    ...otherProps
  } = props;
  const Component = as || "button";
  const shouldFilterDOMProps = typeof Component === "string";
  const domRef = useDOMRef(ref);
  const disableRipple = (_i = disableRippleProp || (globalContext == null ? void 0 : globalContext.disableRipple)) != null ? _i : disableAnimation;
  const { isFocusVisible, isFocused, focusProps } = $f7dceffc5ad7768b$export$4e328f61c538687f({
    autoFocus
  });
  const isDisabled = isDisabledProp || isLoading;
  const styles = useMemo(
    () => button({
      size,
      color,
      variant,
      radius,
      fullWidth,
      isDisabled,
      isInGroup,
      disableAnimation,
      isIconOnly,
      className
    }),
    [
      size,
      color,
      variant,
      radius,
      fullWidth,
      isDisabled,
      isInGroup,
      isIconOnly,
      disableAnimation,
      className
    ]
  );
  const { onPress: onRipplePressHandler, onClear: onClearRipple, ripples } = useRipple();
  const handlePress = useCallback2(
    (e) => {
      if (disableRipple || isDisabled || disableAnimation) return;
      domRef.current && onRipplePressHandler(e);
    },
    [disableRipple, isDisabled, disableAnimation, domRef, onRipplePressHandler]
  );
  const { buttonProps: ariaButtonProps, isPressed } = useAriaButton(
    {
      elementType: as,
      isDisabled,
      onPress: chain(onPress, handlePress),
      onClick,
      ...otherProps
    },
    domRef
  );
  const { isHovered, hoverProps } = useHover({ isDisabled });
  const getButtonProps = useCallback2(
    (props2 = {}) => ({
      "data-disabled": dataAttr(isDisabled),
      "data-focus": dataAttr(isFocused),
      "data-pressed": dataAttr(isPressed),
      "data-focus-visible": dataAttr(isFocusVisible),
      "data-hover": dataAttr(isHovered),
      "data-loading": dataAttr(isLoading),
      ...mergeProps2(
        ariaButtonProps,
        focusProps,
        hoverProps,
        filterDOMProps2(otherProps, {
          enabled: shouldFilterDOMProps
        }),
        filterDOMProps2(props2)
      ),
      className: styles
    }),
    [
      isLoading,
      isDisabled,
      isFocused,
      isPressed,
      shouldFilterDOMProps,
      isFocusVisible,
      isHovered,
      ariaButtonProps,
      focusProps,
      hoverProps,
      otherProps,
      styles
    ]
  );
  const getIconClone = (icon) => isValidElement(icon) ? cloneElement(icon, {
    // @ts-ignore
    "aria-hidden": true,
    focusable: false
  }) : null;
  const startContent = getIconClone(startContentProp);
  const endContent = getIconClone(endContentProp);
  const spinnerSize = useMemo(() => {
    const buttonSpinnerSizeMap = {
      sm: "sm",
      md: "sm",
      lg: "md"
    };
    return buttonSpinnerSizeMap[size];
  }, [size]);
  const getRippleProps = useCallback2(
    () => ({ ripples, onClear: onClearRipple }),
    [ripples, onClearRipple]
  );
  return {
    Component,
    children,
    domRef,
    spinner,
    styles,
    startContent,
    endContent,
    isLoading,
    spinnerPlacement,
    spinnerSize,
    disableRipple,
    getButtonProps,
    getRippleProps,
    isIconOnly
  };
}

// ../button/src/button.tsx
import { jsx as jsx2, jsxs } from "react/jsx-runtime";
var Button = forwardRef((props, ref) => {
  const {
    Component,
    domRef,
    children,
    spinnerSize,
    spinner = /* @__PURE__ */ jsx2(Spinner, { color: "current", size: spinnerSize }),
    spinnerPlacement,
    startContent,
    endContent,
    isLoading,
    disableRipple,
    getButtonProps,
    getRippleProps,
    isIconOnly
  } = useButton({ ...props, ref });
  return /* @__PURE__ */ jsxs(Component, { ref: domRef, ...getButtonProps(), children: [
    startContent,
    isLoading && spinnerPlacement === "start" && spinner,
    isLoading && isIconOnly ? null : children,
    isLoading && spinnerPlacement === "end" && spinner,
    endContent,
    !disableRipple && /* @__PURE__ */ jsx2(ripple_default, { ...getRippleProps() })
  ] });
});
Button.displayName = "HeroUI.Button";
var button_default = Button;

// src/toast.tsx
import {
  CloseIcon,
  DangerIcon,
  InfoFilledIcon,
  SuccessIcon,
  WarningIcon
} from "@heroui/shared-icons";
import { m as m2 } from "framer-motion";
import { cloneElement as cloneElement2, isValidElement as isValidElement2 } from "react";
import { Spinner as Spinner2 } from "@heroui/spinner";
import { Fragment as Fragment2, jsx as jsx3, jsxs as jsxs2 } from "react/jsx-runtime";
var iconMap = {
  default: InfoFilledIcon,
  primary: InfoFilledIcon,
  secondary: InfoFilledIcon,
  success: SuccessIcon,
  warning: WarningIcon,
  danger: DangerIcon
};
var Toast = forwardRef2((props, ref) => {
  const {
    severity,
    Component,
    icon,
    loadingIcon,
    domRef,
    endContent,
    color,
    hideIcon,
    closeIcon,
    disableAnimation,
    progressBarRef,
    classNames,
    slots,
    getWrapperProps,
    isProgressBarVisible,
    getToastProps,
    getContentProps,
    getTitleProps,
    getDescriptionProps,
    getCloseButtonProps,
    getIconProps,
    getMotionDivProps,
    getCloseIconProps,
    getLoadingIconProps,
    isLoading
  } = useToast({
    ...props,
    ref
  });
  const customIcon = icon && isValidElement2(icon) ? cloneElement2(icon, getIconProps()) : null;
  const IconComponent = severity ? iconMap[severity] : iconMap[color] || iconMap.default;
  const customLoadingIcon = loadingIcon && isValidElement2(loadingIcon) ? cloneElement2(loadingIcon, getLoadingIconProps()) : null;
  const loadingIconComponent = isLoading ? customLoadingIcon || /* @__PURE__ */ jsx3(
    Spinner2,
    {
      "aria-label": "loadingIcon",
      classNames: { wrapper: getLoadingIconProps().className },
      color: "current"
    }
  ) : null;
  const customCloseIcon = closeIcon && isValidElement2(closeIcon) ? cloneElement2(closeIcon, {}) : null;
  const toastContent = /* @__PURE__ */ jsxs2(Component, { ref: domRef, ...getToastProps(), children: [
    /* @__PURE__ */ jsxs2("div", { ...getContentProps(), children: [
      hideIcon && !isLoading ? null : loadingIconComponent || customIcon || /* @__PURE__ */ jsx3(IconComponent, { ...getIconProps() }),
      /* @__PURE__ */ jsxs2("div", { ...getWrapperProps(), children: [
        /* @__PURE__ */ jsx3("div", { ...getTitleProps(), children: props.toast.content.title }),
        /* @__PURE__ */ jsx3("div", { ...getDescriptionProps(), children: props.toast.content.description })
      ] })
    ] }),
    isProgressBarVisible && /* @__PURE__ */ jsx3("div", { className: slots.progressTrack({ class: classNames == null ? void 0 : classNames.progressTrack }), children: /* @__PURE__ */ jsx3(
      "div",
      {
        ref: progressBarRef,
        className: slots.progressIndicator({ class: classNames == null ? void 0 : classNames.progressIndicator })
      }
    ) }),
    /* @__PURE__ */ jsx3(button_default, { isIconOnly: true, ...getCloseButtonProps(), children: customCloseIcon || /* @__PURE__ */ jsx3(CloseIcon, { ...getCloseIconProps() }) }),
    endContent
  ] });
  return /* @__PURE__ */ jsx3(Fragment2, { children: disableAnimation ? toastContent : /* @__PURE__ */ jsx3(m2.div, { ...getMotionDivProps(), children: /* @__PURE__ */ jsx3(
    m2.div,
    {
      animate: { opacity: 1 },
      exit: { opacity: 0 },
      initial: { opacity: 0 },
      transition: { duration: 0.25, ease: "easeOut", delay: 0.1 },
      children: toastContent
    },
    "inner-div"
  ) }) });
});
Toast.displayName = "HeroUI.Toast";
var toast_default = Toast;

export {
  toast_default
};
