"use client";
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// ../../utilities/dom-animation/src/index.ts
var src_exports = {};
__export(src_exports, {
  default: () => src_default
});
var import_framer_motion, src_default;
var init_src = __esm({
  "../../utilities/dom-animation/src/index.ts"() {
    "use strict";
    import_framer_motion = require("framer-motion");
    src_default = import_framer_motion.domAnimation;
  }
});

// src/toast-provider.tsx
var toast_provider_exports = {};
__export(toast_provider_exports, {
  ToastProvider: () => ToastProvider,
  addToast: () => addToast,
  closeAll: () => closeAll,
  getToastQueue: () => getToastQueue
});
module.exports = __toCommonJS(toast_provider_exports);
var import_toast4 = require("@react-stately/toast");
var import_system5 = require("@heroui/system");
var import_framer_motion4 = require("framer-motion");

// src/toast-region.tsx
var import_react7 = require("react");
var import_toast2 = require("@react-aria/toast");
var import_interactions6 = require("@react-aria/interactions");
var import_utils5 = require("@react-aria/utils");
var import_theme3 = require("@heroui/theme");
var import_shared_utils5 = require("@heroui/shared-utils");

// src/toast.tsx
var import_system4 = require("@heroui/system");

// ../button/src/button.tsx
var import_spinner = require("@heroui/spinner");

// ../ripple/src/ripple.tsx
var import_framer_motion2 = require("framer-motion");
var import_shared_utils = require("@heroui/shared-utils");
var import_jsx_runtime = require("react/jsx-runtime");
var domAnimation2 = () => Promise.resolve().then(() => (init_src(), src_exports)).then((res) => res.default);
var Ripple = (props) => {
  const { ripples = [], motionProps, color = "currentColor", style, onClear } = props;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_jsx_runtime.Fragment, { children: ripples.map((ripple) => {
    const duration = (0, import_shared_utils.clamp)(0.01 * ripple.size, 0.2, ripple.size > 100 ? 0.75 : 0.5);
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_framer_motion2.LazyMotion, { features: domAnimation2, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_framer_motion2.AnimatePresence, { mode: "popLayout", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_framer_motion2.m.span,
      {
        animate: { transform: "scale(2)", opacity: 0 },
        className: "heroui-ripple",
        exit: { opacity: 0 },
        initial: { transform: "scale(0)", opacity: 0.35 },
        style: {
          position: "absolute",
          backgroundColor: color,
          borderRadius: "100%",
          transformOrigin: "center",
          pointerEvents: "none",
          overflow: "hidden",
          inset: 0,
          zIndex: 0,
          top: ripple.y,
          left: ripple.x,
          width: `${ripple.size}px`,
          height: `${ripple.size}px`,
          ...style
        },
        transition: { duration },
        onAnimationComplete: () => {
          onClear(ripple.key);
        },
        ...motionProps
      }
    ) }) }, ripple.key);
  }) });
};
Ripple.displayName = "HeroUI.Ripple";
var ripple_default = Ripple;

// ../ripple/src/use-ripple.ts
var import_shared_utils2 = require("@heroui/shared-utils");
var import_react = require("react");
function useRipple(props = {}) {
  const [ripples, setRipples] = (0, import_react.useState)([]);
  const onPress = (0, import_react.useCallback)((event) => {
    const trigger = event.target;
    const size = Math.max(trigger.clientWidth, trigger.clientHeight);
    setRipples((prevRipples) => [
      ...prevRipples,
      {
        key: (0, import_shared_utils2.getUniqueID)(prevRipples.length.toString()),
        size,
        x: event.x - size / 2,
        y: event.y - size / 2
      }
    ]);
  }, []);
  const onClear = (0, import_react.useCallback)((key) => {
    setRipples((prevState) => prevState.filter((ripple) => ripple.key !== key));
  }, []);
  return { ripples, onClear, onPress, ...props };
}

// ../button/src/button.tsx
var import_system2 = require("@heroui/system");

// ../button/src/use-button.ts
var import_system = require("@heroui/system");
var import_shared_utils3 = require("@heroui/shared-utils");
var import_react3 = require("react");

// ../../../node_modules/.pnpm/@react-aria+focus@3.20.2_react-dom@18.3.0_react@18.3.0__react@18.3.0/node_modules/@react-aria/focus/dist/useFocusRing.mjs
var import_interactions = require("@react-aria/interactions");
var import_react2 = require("react");
function $f7dceffc5ad7768b$export$4e328f61c538687f(props = {}) {
  let { autoFocus = false, isTextInput, within } = props;
  let state = (0, import_react2.useRef)({
    isFocused: false,
    isFocusVisible: autoFocus || (0, import_interactions.isFocusVisible)()
  });
  let [isFocused, setFocused] = (0, import_react2.useState)(false);
  let [isFocusVisibleState, setFocusVisible] = (0, import_react2.useState)(() => state.current.isFocused && state.current.isFocusVisible);
  let updateState = (0, import_react2.useCallback)(() => setFocusVisible(state.current.isFocused && state.current.isFocusVisible), []);
  let onFocusChange = (0, import_react2.useCallback)((isFocused2) => {
    state.current.isFocused = isFocused2;
    setFocused(isFocused2);
    updateState();
  }, [
    updateState
  ]);
  (0, import_interactions.useFocusVisibleListener)((isFocusVisible) => {
    state.current.isFocusVisible = isFocusVisible;
    updateState();
  }, [], {
    isTextInput
  });
  let { focusProps } = (0, import_interactions.useFocus)({
    isDisabled: within,
    onFocusChange
  });
  let { focusWithinProps } = (0, import_interactions.useFocusWithin)({
    isDisabled: !within,
    onFocusWithinChange: onFocusChange
  });
  return {
    isFocused,
    isFocusVisible: isFocusVisibleState,
    focusProps: within ? focusWithinProps : focusProps
  };
}

// ../../../node_modules/.pnpm/@react-aria+focus@3.20.2_react-dom@18.3.0_react@18.3.0__react@18.3.0/node_modules/@react-aria/focus/dist/import.mjs
var import_utils = require("@react-aria/utils");
var import_interactions2 = require("@react-aria/interactions");

// ../button/src/use-button.ts
var import_utils3 = require("@react-aria/utils");
var import_react_utils2 = require("@heroui/react-utils");
var import_theme = require("@heroui/theme");
var import_react4 = require("react");

// ../../hooks/use-aria-button/src/index.ts
var import_utils2 = require("@react-aria/utils");
var import_interactions3 = require("@react-aria/interactions");
function useAriaButton(props, ref) {
  let {
    elementType = "button",
    isDisabled,
    onPress,
    onPressStart,
    onPressEnd,
    onPressChange,
    // @ts-ignore - undocumented
    preventFocusOnPress,
    // @ts-ignore - undocumented
    allowFocusWhenDisabled,
    onClick,
    href,
    target,
    rel,
    type = "button",
    allowTextSelectionOnPress
  } = props;
  let additionalProps;
  if (elementType === "button") {
    additionalProps = {
      type,
      disabled: isDisabled
    };
  } else {
    additionalProps = {
      role: "button",
      href: elementType === "a" && !isDisabled ? href : void 0,
      target: elementType === "a" ? target : void 0,
      type: elementType === "input" ? type : void 0,
      disabled: elementType === "input" ? isDisabled : void 0,
      "aria-disabled": !isDisabled || elementType === "input" ? void 0 : isDisabled,
      rel: elementType === "a" ? rel : void 0
    };
  }
  let { pressProps, isPressed } = (0, import_interactions3.usePress)({
    onClick,
    onPressStart,
    onPressEnd,
    onPressChange,
    onPress,
    isDisabled,
    preventFocusOnPress,
    allowTextSelectionOnPress,
    ref
  });
  let { focusableProps } = (0, import_interactions2.useFocusable)(props, ref);
  if (allowFocusWhenDisabled) {
    focusableProps.tabIndex = isDisabled ? -1 : focusableProps.tabIndex;
  }
  let buttonProps = (0, import_utils2.mergeProps)(
    focusableProps,
    pressProps,
    (0, import_utils2.filterDOMProps)(props, { labelable: true })
  );
  return {
    isPressed,
    // Used to indicate press state for visual
    buttonProps: (0, import_utils2.mergeProps)(additionalProps, buttonProps, {
      "aria-haspopup": props["aria-haspopup"],
      "aria-expanded": props["aria-expanded"],
      "aria-controls": props["aria-controls"],
      "aria-pressed": props["aria-pressed"],
      "aria-current": props["aria-current"]
    })
  };
}

// ../button/src/use-button.ts
var import_interactions4 = require("@react-aria/interactions");

// ../button/src/button-group-context.ts
var import_react_utils = require("@heroui/react-utils");
var [ButtonGroupProvider, useButtonGroupContext] = (0, import_react_utils.createContext)({
  name: "ButtonGroupContext",
  strict: false
});

// ../button/src/use-button.ts
function useButton(props) {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i;
  const groupContext = useButtonGroupContext();
  const globalContext = (0, import_system.useProviderContext)();
  const isInGroup = !!groupContext;
  const {
    ref,
    as,
    children,
    startContent: startContentProp,
    endContent: endContentProp,
    autoFocus,
    className,
    spinner,
    isLoading = false,
    disableRipple: disableRippleProp = false,
    fullWidth = (_a = groupContext == null ? void 0 : groupContext.fullWidth) != null ? _a : false,
    radius = groupContext == null ? void 0 : groupContext.radius,
    size = (_b = groupContext == null ? void 0 : groupContext.size) != null ? _b : "md",
    color = (_c = groupContext == null ? void 0 : groupContext.color) != null ? _c : "default",
    variant = (_d = groupContext == null ? void 0 : groupContext.variant) != null ? _d : "solid",
    disableAnimation = (_f = (_e = groupContext == null ? void 0 : groupContext.disableAnimation) != null ? _e : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _f : false,
    isDisabled: isDisabledProp = (_g = groupContext == null ? void 0 : groupContext.isDisabled) != null ? _g : false,
    isIconOnly = (_h = groupContext == null ? void 0 : groupContext.isIconOnly) != null ? _h : false,
    spinnerPlacement = "start",
    onPress,
    onClick,
    ...otherProps
  } = props;
  const Component = as || "button";
  const shouldFilterDOMProps = typeof Component === "string";
  const domRef = (0, import_react_utils2.useDOMRef)(ref);
  const disableRipple = (_i = disableRippleProp || (globalContext == null ? void 0 : globalContext.disableRipple)) != null ? _i : disableAnimation;
  const { isFocusVisible, isFocused, focusProps } = $f7dceffc5ad7768b$export$4e328f61c538687f({
    autoFocus
  });
  const isDisabled = isDisabledProp || isLoading;
  const styles = (0, import_react4.useMemo)(
    () => (0, import_theme.button)({
      size,
      color,
      variant,
      radius,
      fullWidth,
      isDisabled,
      isInGroup,
      disableAnimation,
      isIconOnly,
      className
    }),
    [
      size,
      color,
      variant,
      radius,
      fullWidth,
      isDisabled,
      isInGroup,
      isIconOnly,
      disableAnimation,
      className
    ]
  );
  const { onPress: onRipplePressHandler, onClear: onClearRipple, ripples } = useRipple();
  const handlePress = (0, import_react3.useCallback)(
    (e) => {
      if (disableRipple || isDisabled || disableAnimation) return;
      domRef.current && onRipplePressHandler(e);
    },
    [disableRipple, isDisabled, disableAnimation, domRef, onRipplePressHandler]
  );
  const { buttonProps: ariaButtonProps, isPressed } = useAriaButton(
    {
      elementType: as,
      isDisabled,
      onPress: (0, import_utils3.chain)(onPress, handlePress),
      onClick,
      ...otherProps
    },
    domRef
  );
  const { isHovered, hoverProps } = (0, import_interactions4.useHover)({ isDisabled });
  const getButtonProps = (0, import_react3.useCallback)(
    (props2 = {}) => ({
      "data-disabled": (0, import_shared_utils3.dataAttr)(isDisabled),
      "data-focus": (0, import_shared_utils3.dataAttr)(isFocused),
      "data-pressed": (0, import_shared_utils3.dataAttr)(isPressed),
      "data-focus-visible": (0, import_shared_utils3.dataAttr)(isFocusVisible),
      "data-hover": (0, import_shared_utils3.dataAttr)(isHovered),
      "data-loading": (0, import_shared_utils3.dataAttr)(isLoading),
      ...(0, import_utils3.mergeProps)(
        ariaButtonProps,
        focusProps,
        hoverProps,
        (0, import_react_utils2.filterDOMProps)(otherProps, {
          enabled: shouldFilterDOMProps
        }),
        (0, import_react_utils2.filterDOMProps)(props2)
      ),
      className: styles
    }),
    [
      isLoading,
      isDisabled,
      isFocused,
      isPressed,
      shouldFilterDOMProps,
      isFocusVisible,
      isHovered,
      ariaButtonProps,
      focusProps,
      hoverProps,
      otherProps,
      styles
    ]
  );
  const getIconClone = (icon) => (0, import_react4.isValidElement)(icon) ? (0, import_react4.cloneElement)(icon, {
    // @ts-ignore
    "aria-hidden": true,
    focusable: false
  }) : null;
  const startContent = getIconClone(startContentProp);
  const endContent = getIconClone(endContentProp);
  const spinnerSize = (0, import_react4.useMemo)(() => {
    const buttonSpinnerSizeMap = {
      sm: "sm",
      md: "sm",
      lg: "md"
    };
    return buttonSpinnerSizeMap[size];
  }, [size]);
  const getRippleProps = (0, import_react3.useCallback)(
    () => ({ ripples, onClear: onClearRipple }),
    [ripples, onClearRipple]
  );
  return {
    Component,
    children,
    domRef,
    spinner,
    styles,
    startContent,
    endContent,
    isLoading,
    spinnerPlacement,
    spinnerSize,
    disableRipple,
    getButtonProps,
    getRippleProps,
    isIconOnly
  };
}

// ../button/src/button.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var Button = (0, import_system2.forwardRef)((props, ref) => {
  const {
    Component,
    domRef,
    children,
    spinnerSize,
    spinner = /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_spinner.Spinner, { color: "current", size: spinnerSize }),
    spinnerPlacement,
    startContent,
    endContent,
    isLoading,
    disableRipple,
    getButtonProps,
    getRippleProps,
    isIconOnly
  } = useButton({ ...props, ref });
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(Component, { ref: domRef, ...getButtonProps(), children: [
    startContent,
    isLoading && spinnerPlacement === "start" && spinner,
    isLoading && isIconOnly ? null : children,
    isLoading && spinnerPlacement === "end" && spinner,
    endContent,
    !disableRipple && /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(ripple_default, { ...getRippleProps() })
  ] });
});
Button.displayName = "HeroUI.Button";
var button_default = Button;

// src/toast.tsx
var import_shared_icons = require("@heroui/shared-icons");
var import_framer_motion3 = require("framer-motion");
var import_react6 = require("react");
var import_spinner2 = require("@heroui/spinner");

// src/use-toast.ts
var import_system3 = require("@heroui/system");
var import_theme2 = require("@heroui/theme");
var import_react_utils3 = require("@heroui/react-utils");
var import_shared_utils4 = require("@heroui/shared-utils");
var import_react5 = require("react");
var import_toast = require("@react-aria/toast");
var import_utils4 = require("@react-aria/utils");
var import_interactions5 = require("@react-aria/interactions");
var import_use_is_mobile = require("@heroui/use-is-mobile");
var SWIPE_THRESHOLD_X = 100;
var SWIPE_THRESHOLD_Y = 20;
var INITIAL_POSITION = 50;
function useToast(originalProps) {
  var _a, _b;
  const [props, variantProps] = (0, import_system3.mapPropsVariants)(originalProps, import_theme2.toast.variantKeys);
  const {
    ref,
    as,
    title,
    description,
    className,
    classNames,
    toast,
    endContent,
    closeIcon,
    hideIcon = false,
    placement: placementProp = "bottom-right",
    isRegionExpanded,
    hideCloseButton = false,
    state,
    total = 1,
    index = 0,
    heights,
    promise: promiseProp,
    setHeights,
    toastOffset = 0,
    motionProps,
    timeout = 6e3,
    shouldShowTimeoutProgress = false,
    icon,
    onClose,
    severity,
    maxVisibleToasts,
    ...otherProps
  } = props;
  const { isHovered: isToastHovered, hoverProps } = (0, import_interactions5.useHover)({
    isDisabled: false
  });
  const globalContext = (0, import_system3.useProviderContext)();
  const disableAnimation = (_b = (_a = originalProps == null ? void 0 : originalProps.disableAnimation) != null ? _a : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _b : false;
  const isMobile = (0, import_use_is_mobile.useIsMobile)();
  let placement = placementProp;
  if (isMobile) {
    if (placementProp.includes("top")) {
      placement = "top-center";
    } else {
      placement = "bottom-center";
    }
  }
  const animationRef = (0, import_react5.useRef)(null);
  const startTime = (0, import_react5.useRef)(null);
  const progressRef = (0, import_react5.useRef)(0);
  const progressBarRef = (0, import_react5.useRef)(null);
  const pausedTime = (0, import_react5.useRef)(0);
  const timeElapsed = (0, import_react5.useRef)(0);
  (0, import_react5.useEffect)(() => {
    if (progressBarRef.current) {
      progressBarRef.current.style.width = "0%";
    }
  }, []);
  const [isLoading, setIsLoading] = (0, import_react5.useState)(!!promiseProp);
  (0, import_react5.useEffect)(() => {
    if (!promiseProp) return;
    promiseProp.finally(() => {
      setIsLoading(false);
    });
  }, [promiseProp]);
  (0, import_react5.useEffect)(() => {
    const updateProgress = (timestamp) => {
      if (!timeout || isLoading) {
        return;
      }
      if (startTime.current === null) {
        startTime.current = timestamp;
      }
      if (isToastHovered || isRegionExpanded || index != total - 1) {
        pausedTime.current += timestamp - startTime.current;
        startTime.current = null;
        animationRef.current = requestAnimationFrame(updateProgress);
        return;
      }
      const elapsed = timestamp - startTime.current + pausedTime.current;
      timeElapsed.current = elapsed;
      if (timeElapsed.current >= timeout) {
        state.close(toast.key);
      }
      progressRef.current = Math.min(elapsed / timeout * 100, 100);
      if (progressBarRef.current) {
        progressBarRef.current.style.width = `${shouldShowTimeoutProgress ? progressRef.current : 0}%`;
      }
      if (progressRef.current < 100) {
        animationRef.current = requestAnimationFrame(updateProgress);
      }
    };
    animationRef.current = requestAnimationFrame(updateProgress);
    return () => {
      if (animationRef.current !== null) {
        cancelAnimationFrame(animationRef.current);
      }
    };
  }, [
    timeout,
    shouldShowTimeoutProgress,
    state,
    isToastHovered,
    index,
    total,
    isRegionExpanded,
    isLoading
  ]);
  const Component = as || "div";
  const loadingIcon = icon;
  const domRef = (0, import_react_utils3.useDOMRef)(ref);
  const baseStyles = (0, import_shared_utils4.clsx)(className, classNames == null ? void 0 : classNames.base);
  const { toastProps, contentProps, titleProps, descriptionProps } = (0, import_toast.useToast)(
    props,
    state,
    domRef
  );
  const [mounted, setMounted] = (0, import_react5.useState)(false);
  (0, import_react5.useEffect)(() => {
    setMounted(true);
  }, []);
  const [initialHeight, setInitialHeight] = (0, import_react5.useState)(0);
  const [isToastExiting, setIsToastExiting] = (0, import_react5.useState)(false);
  (0, import_react5.useLayoutEffect)(() => {
    if (!domRef.current || !mounted || isToastExiting) {
      return;
    }
    const toastNode = domRef.current;
    const originalHeight = toastNode.style.height;
    toastNode.style.height = "auto";
    const computedStyle = getComputedStyle(toastNode);
    const marginTop = parseFloat(computedStyle.marginTop);
    const marginBottom = parseFloat(computedStyle.marginBottom);
    const newHeight = toastNode.getBoundingClientRect().height + marginTop + marginBottom;
    toastNode.style.height = originalHeight;
    setInitialHeight((prevHeight) => prevHeight !== newHeight ? newHeight : prevHeight);
    const updatedHeights = [...heights];
    if (updatedHeights.length > index) {
      updatedHeights[index] = newHeight;
    } else {
      updatedHeights.push(newHeight);
    }
    setHeights(updatedHeights);
  }, [mounted, total, setHeights, index, isToastExiting]);
  let liftHeight = 4;
  for (let idx = index + 1; idx < total; idx++) {
    liftHeight += heights[idx];
  }
  const frontHeight = heights[heights.length - 1];
  const slots = (0, import_react5.useMemo)(
    () => (0, import_theme2.toast)({
      ...variantProps,
      disableAnimation
    }),
    [(0, import_shared_utils4.objectToDeps)(variantProps)]
  );
  const multiplier = placement.includes("top") ? 1 : -1;
  const toastVariants = {
    hidden: { opacity: 0, y: -INITIAL_POSITION * multiplier },
    visible: { opacity: 1, y: 0 },
    exit: { opacity: 0, y: -INITIAL_POSITION * multiplier }
  };
  const [drag, setDrag] = (0, import_react5.useState)(false);
  const [dragValue, setDragValue] = (0, import_react5.useState)(0);
  const shouldCloseToast = (offsetX, offsetY) => {
    const isRight = placement.includes("right");
    const isLeft = placement.includes("left");
    const isCenterTop = placement === "top-center";
    const isCenterBottom = placement === "bottom-center";
    if (isRight && offsetX >= SWIPE_THRESHOLD_X || isLeft && offsetX <= -SWIPE_THRESHOLD_X || isCenterTop && offsetY <= -SWIPE_THRESHOLD_Y || isCenterBottom && offsetY >= SWIPE_THRESHOLD_Y) {
      return true;
    }
  };
  const getDragElasticConstraints = (placement2) => {
    const elasticConstraint = { top: 0, bottom: 0, right: 0, left: 0 };
    if (placement2 === "bottom-center") {
      elasticConstraint.bottom = 1;
      return elasticConstraint;
    }
    if (placement2 === "top-center") {
      elasticConstraint.top = 1;
      return elasticConstraint;
    }
    if (placement2.includes("right")) {
      elasticConstraint.right = 1;
      return elasticConstraint;
    }
    if (placement2.includes("left")) {
      elasticConstraint.left = 1;
      return elasticConstraint;
    }
    elasticConstraint.left = 1;
    elasticConstraint.right = 1;
    return elasticConstraint;
  };
  let opacityValue = void 0;
  if (drag && placement === "bottom-center" || placement === "top-center") {
    opacityValue = Math.max(0, 1 - dragValue / (SWIPE_THRESHOLD_Y + 5));
  } else if (drag) {
    opacityValue = Math.max(0, 1 - dragValue / (SWIPE_THRESHOLD_X + 20));
  }
  const getToastProps = (0, import_react5.useCallback)(
    (props2 = {}) => {
      const aboveToastHeight = index + 1 < total ? heights[index + 1] : 0;
      const belowToastHeight = index - 1 >= 0 ? heights[index - 1] : 0;
      const topExtension = aboveToastHeight ? Math.ceil(aboveToastHeight / 2) + 8 : 16;
      const bottomExtension = belowToastHeight ? Math.ceil(belowToastHeight / 2) + 8 : 16;
      const pseudoElementStyles = {
        "--top-extension": `${topExtension}px`,
        "--bottom-extension": `${bottomExtension}px`
      };
      return {
        ref: domRef,
        className: slots.base({ class: (0, import_shared_utils4.clsx)(baseStyles, classNames == null ? void 0 : classNames.base) }),
        "data-has-title": (0, import_shared_utils4.dataAttr)(!(0, import_shared_utils4.isEmpty)(title)),
        "data-has-description": (0, import_shared_utils4.dataAttr)(!(0, import_shared_utils4.isEmpty)(description)),
        "data-placement": placement,
        "data-drag-value": dragValue,
        "data-toast": true,
        "aria-label": "toast",
        "data-toast-exiting": (0, import_shared_utils4.dataAttr)(isToastExiting),
        onTransitionEnd: () => {
          if (isToastExiting) {
            const updatedHeights = heights;
            updatedHeights.splice(index, 1);
            setHeights([...updatedHeights]);
            state.close(toast.key);
          }
        },
        style: {
          opacity: opacityValue,
          ...pseudoElementStyles
        },
        ...(0, import_utils4.mergeProps)(props2, otherProps, toastProps, hoverProps)
      };
    },
    [
      slots,
      classNames,
      toastProps,
      hoverProps,
      toast,
      toast.key,
      opacityValue,
      isToastExiting,
      state,
      toast.key
    ]
  );
  const getWrapperProps = (0, import_react5.useCallback)(
    (props2 = {}) => ({
      className: slots.wrapper({ class: classNames == null ? void 0 : classNames.wrapper }),
      ...props2
    }),
    []
  );
  const getIconProps = (0, import_react5.useCallback)(
    (props2 = {}) => ({
      "aria-label": "descriptionIcon",
      className: slots.icon({ class: classNames == null ? void 0 : classNames.icon }),
      ...props2
    }),
    []
  );
  const getLoadingIconProps = (0, import_react5.useCallback)(
    (props2 = {}) => ({
      className: slots.loadingIcon({ class: classNames == null ? void 0 : classNames.loadingIcon }),
      ...props2
    }),
    []
  );
  const getContentProps = (0, import_react5.useCallback)(
    (props2 = {}) => ({
      className: slots.content({ class: classNames == null ? void 0 : classNames.content }),
      ...(0, import_utils4.mergeProps)(props2, otherProps, contentProps)
    }),
    [contentProps]
  );
  const getTitleProps = (0, import_react5.useCallback)(
    (props2 = {}) => ({
      className: slots.title({ class: classNames == null ? void 0 : classNames.title }),
      ...(0, import_utils4.mergeProps)(props2, otherProps, titleProps)
    }),
    [titleProps]
  );
  const getDescriptionProps = (0, import_react5.useCallback)(
    (props2 = {}) => ({
      className: slots.description({ class: classNames == null ? void 0 : classNames.description }),
      ...(0, import_utils4.mergeProps)(props2, otherProps, descriptionProps)
    }),
    [descriptionProps]
  );
  const getCloseButtonProps = (0, import_react5.useCallback)(
    (props2 = {}) => ({
      className: slots.closeButton({ class: classNames == null ? void 0 : classNames.closeButton }),
      "aria-label": "closeButton",
      "data-hidden": (0, import_shared_utils4.dataAttr)(hideCloseButton),
      ...(0, import_utils4.mergeProps)(props2, {
        onPress: (0, import_utils4.chain)(() => {
          setIsToastExiting(true);
          setTimeout(() => document.body.focus(), 0);
        }, onClose)
      })
    }),
    [setIsToastExiting, onClose, state, toast]
  );
  const getCloseIconProps = (0, import_react5.useCallback)(
    (props2 = {}) => ({
      className: slots.closeIcon({ class: classNames == null ? void 0 : classNames.closeIcon }),
      "aria-label": "closeIcon",
      ...props2
    }),
    []
  );
  const getMotionDivProps = (0, import_react5.useCallback)(
    (props2 = {}) => {
      const comparingValue = isRegionExpanded ? maxVisibleToasts - 1 : Math.min(2, maxVisibleToasts - 1);
      const isCloseToEnd = total - index - 1 <= comparingValue;
      const dragDirection = placement === "bottom-center" || placement === "top-center" ? "y" : "x";
      const dragConstraints = { left: 0, right: 0, top: 0, bottom: 0 };
      const dragElastic = getDragElasticConstraints(placement);
      const animateProps = (() => {
        if (placement.includes("top")) {
          return {
            top: isRegionExpanded || drag ? liftHeight + toastOffset : (total - 1 - index) * 8 + toastOffset,
            bottom: "auto"
          };
        } else if (placement.includes("bottom")) {
          return {
            bottom: isRegionExpanded || drag ? liftHeight + toastOffset : (total - 1 - index) * 8 + toastOffset,
            top: "auto"
          };
        }
        return {};
      })();
      return {
        animate: {
          opacity: isCloseToEnd ? 1 : 0,
          pointerEvents: isCloseToEnd ? "all" : "none",
          scaleX: isRegionExpanded || drag ? 1 : 1 - (total - 1 - index) * 0.1,
          height: isRegionExpanded || drag ? initialHeight : frontHeight,
          y: 0,
          ...animateProps
        },
        drag: dragDirection,
        dragConstraints,
        exit: { opacity: 0 },
        initial: { opacity: 0, scale: 1, y: -40 * multiplier },
        transition: { duration: 0.3, ease: "easeOut" },
        variants: toastVariants,
        dragElastic,
        onDragEnd: (_, info) => {
          const { x: offsetX, y: offsetY } = info.offset;
          setDrag(false);
          if (shouldCloseToast(offsetX, offsetY)) {
            const updatedHeights = heights;
            updatedHeights.splice(index, 1);
            setHeights([...updatedHeights]);
            state.close(toast.key);
            return;
          }
          setDragValue(0);
        },
        onDrag: (_, info) => {
          let updatedDragValue = 0;
          if (placement === "top-center") {
            updatedDragValue = -info.offset.y;
          } else if (placement === "bottom-center") {
            updatedDragValue = info.offset.y;
          } else if (placement.includes("right")) {
            updatedDragValue = info.offset.x;
          } else if (placement.includes("left")) {
            updatedDragValue = -info.offset.x;
          }
          if (updatedDragValue >= 0) {
            setDragValue(updatedDragValue);
          }
        },
        onDragStart: () => {
          setDrag(true);
        },
        "data-drag": (0, import_shared_utils4.dataAttr)(drag),
        "data-placement": placement,
        "data-drag-value": dragValue,
        className: slots.motionDiv({ class: classNames == null ? void 0 : classNames.motionDiv }),
        ...props2,
        ...motionProps
      };
    },
    [
      total,
      index,
      placement,
      isRegionExpanded,
      isToastExiting,
      liftHeight,
      multiplier,
      initialHeight,
      frontHeight,
      toastVariants,
      classNames,
      drag,
      import_shared_utils4.dataAttr,
      setDrag,
      shouldCloseToast,
      slots,
      toastOffset,
      maxVisibleToasts
    ]
  );
  return {
    Component,
    title,
    description,
    icon,
    loadingIcon,
    domRef,
    severity,
    closeIcon,
    classNames,
    color: variantProps["color"],
    hideIcon,
    placement,
    state,
    toast,
    disableAnimation,
    isProgressBarVisible: !!timeout,
    total,
    index,
    getWrapperProps,
    getToastProps,
    getTitleProps,
    getContentProps,
    getDescriptionProps,
    getCloseButtonProps,
    getIconProps,
    getMotionDivProps,
    getCloseIconProps,
    getLoadingIconProps,
    progressBarRef,
    endContent,
    slots,
    isRegionExpanded,
    liftHeight,
    frontHeight,
    initialHeight,
    isLoading
  };
}

// src/toast.tsx
var import_jsx_runtime3 = require("react/jsx-runtime");
var iconMap = {
  default: import_shared_icons.InfoFilledIcon,
  primary: import_shared_icons.InfoFilledIcon,
  secondary: import_shared_icons.InfoFilledIcon,
  success: import_shared_icons.SuccessIcon,
  warning: import_shared_icons.WarningIcon,
  danger: import_shared_icons.DangerIcon
};
var Toast = (0, import_system4.forwardRef)((props, ref) => {
  const {
    severity,
    Component,
    icon,
    loadingIcon,
    domRef,
    endContent,
    color,
    hideIcon,
    closeIcon,
    disableAnimation,
    progressBarRef,
    classNames,
    slots,
    getWrapperProps,
    isProgressBarVisible,
    getToastProps,
    getContentProps,
    getTitleProps,
    getDescriptionProps,
    getCloseButtonProps,
    getIconProps,
    getMotionDivProps,
    getCloseIconProps,
    getLoadingIconProps,
    isLoading
  } = useToast({
    ...props,
    ref
  });
  const customIcon = icon && (0, import_react6.isValidElement)(icon) ? (0, import_react6.cloneElement)(icon, getIconProps()) : null;
  const IconComponent = severity ? iconMap[severity] : iconMap[color] || iconMap.default;
  const customLoadingIcon = loadingIcon && (0, import_react6.isValidElement)(loadingIcon) ? (0, import_react6.cloneElement)(loadingIcon, getLoadingIconProps()) : null;
  const loadingIconComponent = isLoading ? customLoadingIcon || /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(
    import_spinner2.Spinner,
    {
      "aria-label": "loadingIcon",
      classNames: { wrapper: getLoadingIconProps().className },
      color: "current"
    }
  ) : null;
  const customCloseIcon = closeIcon && (0, import_react6.isValidElement)(closeIcon) ? (0, import_react6.cloneElement)(closeIcon, {}) : null;
  const toastContent = /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)(Component, { ref: domRef, ...getToastProps(), children: [
    /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("div", { ...getContentProps(), children: [
      hideIcon && !isLoading ? null : loadingIconComponent || customIcon || /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(IconComponent, { ...getIconProps() }),
      /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("div", { ...getWrapperProps(), children: [
        /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { ...getTitleProps(), children: props.toast.content.title }),
        /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { ...getDescriptionProps(), children: props.toast.content.description })
      ] })
    ] }),
    isProgressBarVisible && /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { className: slots.progressTrack({ class: classNames == null ? void 0 : classNames.progressTrack }), children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(
      "div",
      {
        ref: progressBarRef,
        className: slots.progressIndicator({ class: classNames == null ? void 0 : classNames.progressIndicator })
      }
    ) }),
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(button_default, { isIconOnly: true, ...getCloseButtonProps(), children: customCloseIcon || /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_shared_icons.CloseIcon, { ...getCloseIconProps() }) }),
    endContent
  ] });
  return /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_jsx_runtime3.Fragment, { children: disableAnimation ? toastContent : /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_framer_motion3.m.div, { ...getMotionDivProps(), children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(
    import_framer_motion3.m.div,
    {
      animate: { opacity: 1 },
      exit: { opacity: 0 },
      initial: { opacity: 0 },
      transition: { duration: 0.25, ease: "easeOut", delay: 0.1 },
      children: toastContent
    },
    "inner-div"
  ) }) });
});
Toast.displayName = "HeroUI.Toast";
var toast_default = Toast;

// src/toast-region.tsx
var import_jsx_runtime4 = require("react/jsx-runtime");
function ToastRegion({
  toastQueue,
  placement,
  disableAnimation,
  maxVisibleToasts,
  toastOffset,
  toastProps = {},
  className,
  classNames,
  ...props
}) {
  var _a, _b;
  const ref = (0, import_react7.useRef)(null);
  const { regionProps } = (0, import_toast2.useToastRegion)(props, toastQueue, ref);
  const { hoverProps, isHovered } = (0, import_interactions6.useHover)({
    isDisabled: false
  });
  const [isTouched, setIsTouched] = (0, import_react7.useState)(false);
  const slots = (0, import_react7.useMemo)(
    () => (0, import_theme3.toastRegion)({
      disableAnimation
    }),
    [disableAnimation]
  );
  const baseStyles = (0, import_shared_utils5.clsx)(classNames == null ? void 0 : classNames.base, className);
  (0, import_react7.useEffect)(() => {
    function handleTouchOutside(event) {
      if (ref.current && !ref.current.contains(event.target)) {
        setIsTouched(false);
      }
    }
    document.addEventListener("touchstart", handleTouchOutside);
    return () => {
      document.removeEventListener("touchstart", handleTouchOutside);
    };
  }, []);
  const [heights, setHeights] = (0, import_react7.useState)([]);
  const total = (_b = (_a = toastQueue.visibleToasts) == null ? void 0 : _a.length) != null ? _b : 0;
  const handleTouchStart = (0, import_react7.useCallback)(() => {
    setIsTouched(true);
  }, []);
  return /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
    "div",
    {
      ...(0, import_utils5.mergeProps)(regionProps, hoverProps),
      ref,
      className: slots.base({ class: baseStyles }),
      "data-placement": placement,
      onTouchStart: handleTouchStart,
      children: [...toastQueue.visibleToasts].reverse().map((toast, index) => {
        if (disableAnimation && total - index > maxVisibleToasts) {
          return null;
        }
        if (disableAnimation || total - index <= 4 || isHovered && total - index <= maxVisibleToasts + 1) {
          return /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
            toast_default,
            {
              state: toastQueue,
              toast,
              ...(0, import_utils5.mergeProps)(toastProps, toast.content),
              disableAnimation,
              heights,
              index,
              isRegionExpanded: isHovered || isTouched,
              maxVisibleToasts,
              placement,
              setHeights,
              toastOffset,
              total
            },
            toast.key
          );
        }
        return null;
      })
    }
  );
}

// src/toast-provider.tsx
var import_jsx_runtime5 = require("react/jsx-runtime");
var loadFeatures = () => import("framer-motion").then((res) => res.domMax);
var globalToastQueue = null;
var getToastQueue = () => {
  if (!globalToastQueue) {
    globalToastQueue = new import_toast4.ToastQueue({
      maxVisibleToasts: Infinity
    });
  }
  return globalToastQueue;
};
var ToastProvider = ({
  placement = "bottom-right",
  disableAnimation: disableAnimationProp = false,
  maxVisibleToasts = 3,
  toastOffset = 0,
  toastProps = {},
  regionProps
}) => {
  var _a;
  const toastQueue = (0, import_toast4.useToastQueue)(getToastQueue());
  const globalContext = (0, import_system5.useProviderContext)();
  const disableAnimation = (_a = disableAnimationProp != null ? disableAnimationProp : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _a : false;
  return /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_framer_motion4.LazyMotion, { features: loadFeatures, children: /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_framer_motion4.AnimatePresence, { children: toastQueue.visibleToasts.length > 0 ? /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
    ToastRegion,
    {
      disableAnimation,
      maxVisibleToasts,
      placement,
      toastOffset,
      toastProps,
      toastQueue,
      ...regionProps
    }
  ) : null }) });
};
var addToast = ({ ...props }) => {
  if (!globalToastQueue) {
    return;
  }
  globalToastQueue.add(props);
};
var closeAll = () => {
  if (!globalToastQueue) {
    return;
  }
  const keys = globalToastQueue.visibleToasts.map((toast) => toast.key);
  keys.map((key) => {
    globalToastQueue == null ? void 0 : globalToastQueue.close(key);
  });
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ToastProvider,
  addToast,
  closeAll,
  getToastQueue
});
