import * as tailwind_variants from 'tailwind-variants';
import * as react from 'react';
import { ReactNode } from 'react';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { ToastVariantProps, SlotsToClasses, ToastSlots } from '@heroui/theme';
import { ReactRef } from '@heroui/react-utils';
import { AriaToastProps } from '@react-aria/toast';
import { ToastState, QueuedToast } from '@react-stately/toast';
import { MotionProps } from 'framer-motion';

type ToastPlacement = "bottom-right" | "bottom-left" | "bottom-center" | "top-right" | "top-left" | "top-center";
interface ToastProps extends ToastVariantProps {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLElement | null>;
    /**
     * title of the toast
     */
    title?: ReactNode;
    /**
     * description of the toast
     */
    description?: ReactNode;
    /**
     * Promise based on which the notification will be styled.
     */
    promise?: Promise<any>;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * addToast({
     *   classNames={{
     *    base:"base-classes",
     *    content: "content-classes"
     *    description: "description-classes"
     *    title: "title-classes"
     *    loadingIcon: "loading-icon-classes",
     *    icon: "icon-classes",
     *    progressTrack: "progress-track-classes",
     *    progressIndicator: "progress-indicator-classes",
     *    closeButton: "closeButton-classes"
     *    closeIcon: "closeIcon-classes"
     *   }}
     * })
     * ```
     */
    classNames?: SlotsToClasses<ToastSlots>;
    /**
     * Content to be displayed in the end side of the toast
     */
    endContent?: ReactNode;
    /**
     * Icon to be displayed in the toast - overrides the default icon
     */
    icon?: ReactNode;
    /**
     * Icon to be displayed in the close button - overrides the default close icon
     */
    closeIcon?: ReactNode | ((props: any) => ReactNode);
    /**
     * Icon to be displayed in the loading toast - overrides the loading icon
     */
    loadingIcon?: ReactNode;
    /**
     * Whether the toast-icon should be hidden.
     * @default false
     */
    hideIcon?: boolean;
    /**
     * Time to auto-close the toast.
     */
    timeout?: number;
    /**
     * hides the close button
     */
    hideCloseButton?: boolean;
    /**
     * function which is called when toast is closed.
     */
    onClose?: () => void;
    /**
     * props that will be passed to the m.div
     */
    motionProps?: MotionProps;
    /**
     * should apply styles to indicate timeout progress
     */
    shouldShowTimeoutProgress?: boolean;
    /**
     * The severity of the toast. This changes the icon without having to change the color.
     * @default "default"
     */
    severity?: "default" | "primary" | "secondary" | "success" | "warning" | "danger";
}
interface Props<T> extends Omit<HTMLHeroUIProps<"div">, "title">, ToastProps {
    toast: QueuedToast<T>;
    index: number;
    total: number;
    state: ToastState<T>;
    heights: number[];
    setHeights: (val: number[]) => void;
    disableAnimation?: boolean;
    isRegionExpanded: boolean;
    placement?: ToastPlacement;
    toastOffset?: number;
    maxVisibleToasts: number;
}
type UseToastProps<T = ToastProps> = Props<T> & ToastVariantProps & Omit<AriaToastProps<T>, "div">;
declare function useToast<T extends ToastProps>(originalProps: UseToastProps<T>): {
    Component: _heroui_system.As<any>;
    title: ReactNode;
    description: ReactNode;
    icon: ReactNode;
    loadingIcon: ReactNode;
    domRef: react.RefObject<HTMLElement>;
    severity: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
    closeIcon: ReactNode | ((props: any) => ReactNode);
    classNames: SlotsToClasses<"base" | "title" | "description" | "content" | "icon" | "wrapper" | "closeButton" | "loadingIcon" | "progressTrack" | "progressIndicator" | "motionDiv" | "closeIcon"> | undefined;
    color: any;
    hideIcon: boolean;
    placement: ToastPlacement;
    state: ToastState<T>;
    toast: QueuedToast<T>;
    disableAnimation: boolean;
    isProgressBarVisible: boolean;
    total: number;
    index: number;
    getWrapperProps: PropGetter;
    getToastProps: PropGetter;
    getTitleProps: PropGetter;
    getContentProps: PropGetter;
    getDescriptionProps: PropGetter;
    getCloseButtonProps: PropGetter;
    getIconProps: PropGetter;
    getMotionDivProps: (props?: {}) => MotionProps & {
        "data-drag": string | boolean;
        "data-placement": string;
        "data-drag-value": number;
        className: string;
    };
    getCloseIconProps: PropGetter;
    getLoadingIconProps: PropGetter;
    progressBarRef: react.RefObject<HTMLDivElement>;
    endContent: ReactNode;
    slots: {
        base: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        wrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        title: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        description: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        icon: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        loadingIcon: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        progressTrack: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        progressIndicator: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        motionDiv: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        closeButton: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        closeIcon: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        wrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        title: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        description: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        icon: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        loadingIcon: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        progressTrack: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        progressIndicator: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        motionDiv: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        closeButton: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        closeIcon: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | "foreground" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            shadow?: "none" | "sm" | "md" | "lg" | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            variant?: "flat" | "solid" | "bordered" | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    isRegionExpanded: boolean;
    liftHeight: number;
    frontHeight: number;
    initialHeight: number;
    isLoading: boolean;
};
type UseToastReturn = ReturnType<typeof useToast>;

export { type ToastPlacement, type ToastProps, type UseToastProps, type UseToastReturn, useToast };
