"use client";
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/use-toast.ts
var use_toast_exports = {};
__export(use_toast_exports, {
  useToast: () => useToast
});
module.exports = __toCommonJS(use_toast_exports);
var import_system = require("@heroui/system");
var import_theme = require("@heroui/theme");
var import_react_utils = require("@heroui/react-utils");
var import_shared_utils = require("@heroui/shared-utils");
var import_react = require("react");
var import_toast = require("@react-aria/toast");
var import_utils = require("@react-aria/utils");
var import_interactions = require("@react-aria/interactions");
var import_use_is_mobile = require("@heroui/use-is-mobile");
var SWIPE_THRESHOLD_X = 100;
var SWIPE_THRESHOLD_Y = 20;
var INITIAL_POSITION = 50;
function useToast(originalProps) {
  var _a, _b;
  const [props, variantProps] = (0, import_system.mapPropsVariants)(originalProps, import_theme.toast.variantKeys);
  const {
    ref,
    as,
    title,
    description,
    className,
    classNames,
    toast,
    endContent,
    closeIcon,
    hideIcon = false,
    placement: placementProp = "bottom-right",
    isRegionExpanded,
    hideCloseButton = false,
    state,
    total = 1,
    index = 0,
    heights,
    promise: promiseProp,
    setHeights,
    toastOffset = 0,
    motionProps,
    timeout = 6e3,
    shouldShowTimeoutProgress = false,
    icon,
    onClose,
    severity,
    maxVisibleToasts,
    ...otherProps
  } = props;
  const { isHovered: isToastHovered, hoverProps } = (0, import_interactions.useHover)({
    isDisabled: false
  });
  const globalContext = (0, import_system.useProviderContext)();
  const disableAnimation = (_b = (_a = originalProps == null ? void 0 : originalProps.disableAnimation) != null ? _a : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _b : false;
  const isMobile = (0, import_use_is_mobile.useIsMobile)();
  let placement = placementProp;
  if (isMobile) {
    if (placementProp.includes("top")) {
      placement = "top-center";
    } else {
      placement = "bottom-center";
    }
  }
  const animationRef = (0, import_react.useRef)(null);
  const startTime = (0, import_react.useRef)(null);
  const progressRef = (0, import_react.useRef)(0);
  const progressBarRef = (0, import_react.useRef)(null);
  const pausedTime = (0, import_react.useRef)(0);
  const timeElapsed = (0, import_react.useRef)(0);
  (0, import_react.useEffect)(() => {
    if (progressBarRef.current) {
      progressBarRef.current.style.width = "0%";
    }
  }, []);
  const [isLoading, setIsLoading] = (0, import_react.useState)(!!promiseProp);
  (0, import_react.useEffect)(() => {
    if (!promiseProp) return;
    promiseProp.finally(() => {
      setIsLoading(false);
    });
  }, [promiseProp]);
  (0, import_react.useEffect)(() => {
    const updateProgress = (timestamp) => {
      if (!timeout || isLoading) {
        return;
      }
      if (startTime.current === null) {
        startTime.current = timestamp;
      }
      if (isToastHovered || isRegionExpanded || index != total - 1) {
        pausedTime.current += timestamp - startTime.current;
        startTime.current = null;
        animationRef.current = requestAnimationFrame(updateProgress);
        return;
      }
      const elapsed = timestamp - startTime.current + pausedTime.current;
      timeElapsed.current = elapsed;
      if (timeElapsed.current >= timeout) {
        state.close(toast.key);
      }
      progressRef.current = Math.min(elapsed / timeout * 100, 100);
      if (progressBarRef.current) {
        progressBarRef.current.style.width = `${shouldShowTimeoutProgress ? progressRef.current : 0}%`;
      }
      if (progressRef.current < 100) {
        animationRef.current = requestAnimationFrame(updateProgress);
      }
    };
    animationRef.current = requestAnimationFrame(updateProgress);
    return () => {
      if (animationRef.current !== null) {
        cancelAnimationFrame(animationRef.current);
      }
    };
  }, [
    timeout,
    shouldShowTimeoutProgress,
    state,
    isToastHovered,
    index,
    total,
    isRegionExpanded,
    isLoading
  ]);
  const Component = as || "div";
  const loadingIcon = icon;
  const domRef = (0, import_react_utils.useDOMRef)(ref);
  const baseStyles = (0, import_shared_utils.clsx)(className, classNames == null ? void 0 : classNames.base);
  const { toastProps, contentProps, titleProps, descriptionProps } = (0, import_toast.useToast)(
    props,
    state,
    domRef
  );
  const [mounted, setMounted] = (0, import_react.useState)(false);
  (0, import_react.useEffect)(() => {
    setMounted(true);
  }, []);
  const [initialHeight, setInitialHeight] = (0, import_react.useState)(0);
  const [isToastExiting, setIsToastExiting] = (0, import_react.useState)(false);
  (0, import_react.useLayoutEffect)(() => {
    if (!domRef.current || !mounted || isToastExiting) {
      return;
    }
    const toastNode = domRef.current;
    const originalHeight = toastNode.style.height;
    toastNode.style.height = "auto";
    const computedStyle = getComputedStyle(toastNode);
    const marginTop = parseFloat(computedStyle.marginTop);
    const marginBottom = parseFloat(computedStyle.marginBottom);
    const newHeight = toastNode.getBoundingClientRect().height + marginTop + marginBottom;
    toastNode.style.height = originalHeight;
    setInitialHeight((prevHeight) => prevHeight !== newHeight ? newHeight : prevHeight);
    const updatedHeights = [...heights];
    if (updatedHeights.length > index) {
      updatedHeights[index] = newHeight;
    } else {
      updatedHeights.push(newHeight);
    }
    setHeights(updatedHeights);
  }, [mounted, total, setHeights, index, isToastExiting]);
  let liftHeight = 4;
  for (let idx = index + 1; idx < total; idx++) {
    liftHeight += heights[idx];
  }
  const frontHeight = heights[heights.length - 1];
  const slots = (0, import_react.useMemo)(
    () => (0, import_theme.toast)({
      ...variantProps,
      disableAnimation
    }),
    [(0, import_shared_utils.objectToDeps)(variantProps)]
  );
  const multiplier = placement.includes("top") ? 1 : -1;
  const toastVariants = {
    hidden: { opacity: 0, y: -INITIAL_POSITION * multiplier },
    visible: { opacity: 1, y: 0 },
    exit: { opacity: 0, y: -INITIAL_POSITION * multiplier }
  };
  const [drag, setDrag] = (0, import_react.useState)(false);
  const [dragValue, setDragValue] = (0, import_react.useState)(0);
  const shouldCloseToast = (offsetX, offsetY) => {
    const isRight = placement.includes("right");
    const isLeft = placement.includes("left");
    const isCenterTop = placement === "top-center";
    const isCenterBottom = placement === "bottom-center";
    if (isRight && offsetX >= SWIPE_THRESHOLD_X || isLeft && offsetX <= -SWIPE_THRESHOLD_X || isCenterTop && offsetY <= -SWIPE_THRESHOLD_Y || isCenterBottom && offsetY >= SWIPE_THRESHOLD_Y) {
      return true;
    }
  };
  const getDragElasticConstraints = (placement2) => {
    const elasticConstraint = { top: 0, bottom: 0, right: 0, left: 0 };
    if (placement2 === "bottom-center") {
      elasticConstraint.bottom = 1;
      return elasticConstraint;
    }
    if (placement2 === "top-center") {
      elasticConstraint.top = 1;
      return elasticConstraint;
    }
    if (placement2.includes("right")) {
      elasticConstraint.right = 1;
      return elasticConstraint;
    }
    if (placement2.includes("left")) {
      elasticConstraint.left = 1;
      return elasticConstraint;
    }
    elasticConstraint.left = 1;
    elasticConstraint.right = 1;
    return elasticConstraint;
  };
  let opacityValue = void 0;
  if (drag && placement === "bottom-center" || placement === "top-center") {
    opacityValue = Math.max(0, 1 - dragValue / (SWIPE_THRESHOLD_Y + 5));
  } else if (drag) {
    opacityValue = Math.max(0, 1 - dragValue / (SWIPE_THRESHOLD_X + 20));
  }
  const getToastProps = (0, import_react.useCallback)(
    (props2 = {}) => {
      const aboveToastHeight = index + 1 < total ? heights[index + 1] : 0;
      const belowToastHeight = index - 1 >= 0 ? heights[index - 1] : 0;
      const topExtension = aboveToastHeight ? Math.ceil(aboveToastHeight / 2) + 8 : 16;
      const bottomExtension = belowToastHeight ? Math.ceil(belowToastHeight / 2) + 8 : 16;
      const pseudoElementStyles = {
        "--top-extension": `${topExtension}px`,
        "--bottom-extension": `${bottomExtension}px`
      };
      return {
        ref: domRef,
        className: slots.base({ class: (0, import_shared_utils.clsx)(baseStyles, classNames == null ? void 0 : classNames.base) }),
        "data-has-title": (0, import_shared_utils.dataAttr)(!(0, import_shared_utils.isEmpty)(title)),
        "data-has-description": (0, import_shared_utils.dataAttr)(!(0, import_shared_utils.isEmpty)(description)),
        "data-placement": placement,
        "data-drag-value": dragValue,
        "data-toast": true,
        "aria-label": "toast",
        "data-toast-exiting": (0, import_shared_utils.dataAttr)(isToastExiting),
        onTransitionEnd: () => {
          if (isToastExiting) {
            const updatedHeights = heights;
            updatedHeights.splice(index, 1);
            setHeights([...updatedHeights]);
            state.close(toast.key);
          }
        },
        style: {
          opacity: opacityValue,
          ...pseudoElementStyles
        },
        ...(0, import_utils.mergeProps)(props2, otherProps, toastProps, hoverProps)
      };
    },
    [
      slots,
      classNames,
      toastProps,
      hoverProps,
      toast,
      toast.key,
      opacityValue,
      isToastExiting,
      state,
      toast.key
    ]
  );
  const getWrapperProps = (0, import_react.useCallback)(
    (props2 = {}) => ({
      className: slots.wrapper({ class: classNames == null ? void 0 : classNames.wrapper }),
      ...props2
    }),
    []
  );
  const getIconProps = (0, import_react.useCallback)(
    (props2 = {}) => ({
      "aria-label": "descriptionIcon",
      className: slots.icon({ class: classNames == null ? void 0 : classNames.icon }),
      ...props2
    }),
    []
  );
  const getLoadingIconProps = (0, import_react.useCallback)(
    (props2 = {}) => ({
      className: slots.loadingIcon({ class: classNames == null ? void 0 : classNames.loadingIcon }),
      ...props2
    }),
    []
  );
  const getContentProps = (0, import_react.useCallback)(
    (props2 = {}) => ({
      className: slots.content({ class: classNames == null ? void 0 : classNames.content }),
      ...(0, import_utils.mergeProps)(props2, otherProps, contentProps)
    }),
    [contentProps]
  );
  const getTitleProps = (0, import_react.useCallback)(
    (props2 = {}) => ({
      className: slots.title({ class: classNames == null ? void 0 : classNames.title }),
      ...(0, import_utils.mergeProps)(props2, otherProps, titleProps)
    }),
    [titleProps]
  );
  const getDescriptionProps = (0, import_react.useCallback)(
    (props2 = {}) => ({
      className: slots.description({ class: classNames == null ? void 0 : classNames.description }),
      ...(0, import_utils.mergeProps)(props2, otherProps, descriptionProps)
    }),
    [descriptionProps]
  );
  const getCloseButtonProps = (0, import_react.useCallback)(
    (props2 = {}) => ({
      className: slots.closeButton({ class: classNames == null ? void 0 : classNames.closeButton }),
      "aria-label": "closeButton",
      "data-hidden": (0, import_shared_utils.dataAttr)(hideCloseButton),
      ...(0, import_utils.mergeProps)(props2, {
        onPress: (0, import_utils.chain)(() => {
          setIsToastExiting(true);
          setTimeout(() => document.body.focus(), 0);
        }, onClose)
      })
    }),
    [setIsToastExiting, onClose, state, toast]
  );
  const getCloseIconProps = (0, import_react.useCallback)(
    (props2 = {}) => ({
      className: slots.closeIcon({ class: classNames == null ? void 0 : classNames.closeIcon }),
      "aria-label": "closeIcon",
      ...props2
    }),
    []
  );
  const getMotionDivProps = (0, import_react.useCallback)(
    (props2 = {}) => {
      const comparingValue = isRegionExpanded ? maxVisibleToasts - 1 : Math.min(2, maxVisibleToasts - 1);
      const isCloseToEnd = total - index - 1 <= comparingValue;
      const dragDirection = placement === "bottom-center" || placement === "top-center" ? "y" : "x";
      const dragConstraints = { left: 0, right: 0, top: 0, bottom: 0 };
      const dragElastic = getDragElasticConstraints(placement);
      const animateProps = (() => {
        if (placement.includes("top")) {
          return {
            top: isRegionExpanded || drag ? liftHeight + toastOffset : (total - 1 - index) * 8 + toastOffset,
            bottom: "auto"
          };
        } else if (placement.includes("bottom")) {
          return {
            bottom: isRegionExpanded || drag ? liftHeight + toastOffset : (total - 1 - index) * 8 + toastOffset,
            top: "auto"
          };
        }
        return {};
      })();
      return {
        animate: {
          opacity: isCloseToEnd ? 1 : 0,
          pointerEvents: isCloseToEnd ? "all" : "none",
          scaleX: isRegionExpanded || drag ? 1 : 1 - (total - 1 - index) * 0.1,
          height: isRegionExpanded || drag ? initialHeight : frontHeight,
          y: 0,
          ...animateProps
        },
        drag: dragDirection,
        dragConstraints,
        exit: { opacity: 0 },
        initial: { opacity: 0, scale: 1, y: -40 * multiplier },
        transition: { duration: 0.3, ease: "easeOut" },
        variants: toastVariants,
        dragElastic,
        onDragEnd: (_, info) => {
          const { x: offsetX, y: offsetY } = info.offset;
          setDrag(false);
          if (shouldCloseToast(offsetX, offsetY)) {
            const updatedHeights = heights;
            updatedHeights.splice(index, 1);
            setHeights([...updatedHeights]);
            state.close(toast.key);
            return;
          }
          setDragValue(0);
        },
        onDrag: (_, info) => {
          let updatedDragValue = 0;
          if (placement === "top-center") {
            updatedDragValue = -info.offset.y;
          } else if (placement === "bottom-center") {
            updatedDragValue = info.offset.y;
          } else if (placement.includes("right")) {
            updatedDragValue = info.offset.x;
          } else if (placement.includes("left")) {
            updatedDragValue = -info.offset.x;
          }
          if (updatedDragValue >= 0) {
            setDragValue(updatedDragValue);
          }
        },
        onDragStart: () => {
          setDrag(true);
        },
        "data-drag": (0, import_shared_utils.dataAttr)(drag),
        "data-placement": placement,
        "data-drag-value": dragValue,
        className: slots.motionDiv({ class: classNames == null ? void 0 : classNames.motionDiv }),
        ...props2,
        ...motionProps
      };
    },
    [
      total,
      index,
      placement,
      isRegionExpanded,
      isToastExiting,
      liftHeight,
      multiplier,
      initialHeight,
      frontHeight,
      toastVariants,
      classNames,
      drag,
      import_shared_utils.dataAttr,
      setDrag,
      shouldCloseToast,
      slots,
      toastOffset,
      maxVisibleToasts
    ]
  );
  return {
    Component,
    title,
    description,
    icon,
    loadingIcon,
    domRef,
    severity,
    closeIcon,
    classNames,
    color: variantProps["color"],
    hideIcon,
    placement,
    state,
    toast,
    disableAnimation,
    isProgressBarVisible: !!timeout,
    total,
    index,
    getWrapperProps,
    getToastProps,
    getTitleProps,
    getContentProps,
    getDescriptionProps,
    getCloseButtonProps,
    getIconProps,
    getMotionDivProps,
    getCloseIconProps,
    getLoadingIconProps,
    progressBarRef,
    endContent,
    slots,
    isRegionExpanded,
    liftHeight,
    frontHeight,
    initialHeight,
    isLoading
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  useToast
});
