"use client";
import {
  useTooltip
} from "./chunk-O2IDE4PL.mjs";

// src/tooltip.tsx
import { forwardRef } from "@heroui/system";
import { OverlayContainer } from "@react-aria/overlays";
import { AnimatePresence, m, LazyMotion } from "framer-motion";
import { TRANSITION_VARIANTS } from "@heroui/framer-utils";
import { warn } from "@heroui/shared-utils";
import { Children, cloneElement, isValidElement } from "react";
import { getTransformOrigins } from "@heroui/aria-utils";
import { mergeProps } from "@react-aria/utils";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var domAnimation = () => import("@heroui/dom-animation").then((res) => res.default);
var Tooltip = forwardRef((props, ref) => {
  var _a;
  const {
    Component,
    children,
    content,
    isOpen,
    portalContainer,
    placement,
    disableAnimation,
    motionProps,
    getTriggerProps,
    getTooltipProps,
    getTooltipContentProps
  } = useTooltip({
    ...props,
    ref
  });
  let trigger;
  try {
    const childrenNum = Children.count(children);
    if (childrenNum !== 1) throw new Error();
    if (!isValidElement(children)) {
      trigger = /* @__PURE__ */ jsx("p", { ...getTriggerProps(), children });
    } else {
      const child = children;
      const childRef = (_a = child.props.ref) != null ? _a : child.ref;
      trigger = cloneElement(child, getTriggerProps(child.props, childRef));
    }
  } catch (error) {
    trigger = /* @__PURE__ */ jsx("span", {});
    warn("Tooltip must have only one child node. Please, check your code.");
  }
  const { ref: tooltipRef, id, style, ...otherTooltipProps } = getTooltipProps();
  const animatedContent = /* @__PURE__ */ jsx("div", { ref: tooltipRef, id, style, children: /* @__PURE__ */ jsx(
    m.div,
    {
      animate: "enter",
      exit: "exit",
      initial: "exit",
      variants: TRANSITION_VARIANTS.scaleSpring,
      ...mergeProps(motionProps, otherTooltipProps),
      style: {
        ...getTransformOrigins(placement)
      },
      children: /* @__PURE__ */ jsx(Component, { ...getTooltipContentProps(), children: content })
    },
    `${id}-tooltip-inner`
  ) }, `${id}-tooltip-content`);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    trigger,
    disableAnimation ? isOpen && /* @__PURE__ */ jsx(OverlayContainer, { portalContainer, children: /* @__PURE__ */ jsx("div", { ref: tooltipRef, id, style, ...otherTooltipProps, children: /* @__PURE__ */ jsx(Component, { ...getTooltipContentProps(), children: content }) }) }) : /* @__PURE__ */ jsx(LazyMotion, { features: domAnimation, children: /* @__PURE__ */ jsx(AnimatePresence, { children: isOpen && /* @__PURE__ */ jsx(OverlayContainer, { portalContainer, children: animatedContent }) }) })
  ] });
});
Tooltip.displayName = "HeroUI.Tooltip";
var tooltip_default = Tooltip;

export {
  tooltip_default
};
