<!DOCTYPE html>

<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dossier Entreprise - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Crimson+Text:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Crimson Text', serif; }
    </style>
</head>
<body class="bg-amber-950 min-h-screen p-8">
    <div class="max-w-2xl mx-auto bg-amber-50 p-12 shadow-2xl">

    <div class="text-center mb-8 pb-6 border-b border-amber-800">
        <h1 class="text-2xl font-semibold text-amber-900 mb-2 tracking-wide">DOSSIER ENTREPRISE</h1>
        <p class="text-amber-700">Écrit à Saint-Denis, le 27/08/1901</p>
    </div>
    
    <div class="mb-8">
        <h2 class="text-lg font-semibold text-amber-900 mb-4 pb-2 border-b border-amber-300">Informations</h2>
        <div class="space-y-3">
            <div class="flex">
                <span class="w-32 font-semibold text-amber-800">Nom de l'entreprise :</span>
                <span class="text-amber-900">The Pinkerton Agency</span>
            </div>
            <div class="flex">
                <span class="w-32 font-semibold text-amber-800">Directeur :</span>
                <span class="text-amber-900">Robert Bob</span>
            </div>
            <div class="flex">
                <span class="w-32 font-semibold text-amber-800">Secteur :</span>
                <span class="text-amber-900">Défenses féderales et protection</span>
            </div>
            <div class="flex">
                <span class="w-32 font-semibold text-amber-800">Création :</span>
                <span class="text-amber-900">1901</span>
            </div>
        </div>
    </div>
    
    <div class="mb-8">
        <h2 class="text-lg font-semibold text-amber-900 mb-4 pb-2 border-b border-amber-300">Présentation</h2>
        <p class="text-amber-900 leading-relaxed mb-4 text-justify">
            La Pinkerton Agency est une agence de detective privée, agissant sur tout le continent américain et ses environs dans le but de protéger la civilisation et de traquer la criminalité de très pres. Leur avantage est d'être agréé à l'utilisation d'arme et d'être permis de prendre des missions de la part des civils également, sous approbation du dossier par le gouvernement.
        </p>
        <h2 class="text-lg font-semibold text-amber-900 mb-4 pb-2 border-b border-amber-300">Hiérarchie</h2>
        <p class="text-amber-900 leading-relaxed text-justify">
          - Directeur : le directeur a le pouvoir absolu sur l'agence, allant de la repartition des unités a l'approbation d'interventions.
        </p>
                <p class="text-amber-900 leading-relaxed text-justify">
        - Lieutenant : les lieutenants sont les bras droit du directeur. Ils communiquent les dires du directeur au reste de l'agence. Également, ils peuvent représenter l'agence lors des déplacements ou lorsque le directeur n'est pas présent
        </p>
        <p class="text-amber-900 leading-relaxed text-justify">
        - Agent de terrain :  l'agent de terrain agis et accomplis les missions données par l'agence. Il a pour ordre d'obéir a ses supérieurs et servir l'agence. Il a le droit d'agir sur le terrain par une aide de renfort ou la nécessité d'intervenir. Il doit avoir l'habiliter de rédiger des dossiers de rapports.
        </p>
         <p class="text-amber-900 leading-relaxed text-justify">
         - Agent : l'agent agis et accomplis les missions données par l'agence. Il a pour ordre d'obéir a ses supérieurs et servir l'agence. Il n'a en aucun cas le droit d'agir, il ne peut que se défendre a l'aide de son arme si il vient a etre attaquer. Il doit avoir l'habiliter de rédiger des dossiers de rapports.
         </p>
    </div>
    
    <div class="mb-8">
        <h2 class="text-lg font-semibold text-amber-900 mb-4 pb-2 border-b border-amber-300">Inventaires</h2>
        <p class="text-amber-900 leading-relaxed text-justify">
         Les agents et agents de terrains ainsi que les lieutenants se verront attribuer du matériel de travail, qui est le suivant :
         </p>
        <div class="text-amber-900 leading-relaxed">
            • Revolver<br>
            • Fusil double canon (Agent de terrain & Lieutenant seulement)<br>
            • Jumelles<br>
            • Sniper (Agent de terrain seulement)<br>
        </div>
         <p class="text-amber-900 leading-relaxed text-justify">
         Le reste des fournitures, comme par exemple alimentaire ou nécessaire (balle d'arme, etc..) seront disponibles dans les stocks. Le directeur a la possession de ses armes personnelles.
         </p>
    </div>
    
      <h2 class="mt-4 text-lg font-semibold text-amber-900 mb-4 pb-2 border-b border-amber-300">Évènements</h2>
        <p class="text-amber-900 leading-relaxed text-justify">
         L'agence organisera toutes les semaines des séances d'entraînement pour les agents et agents de terrains, qui seront réalisés dans la ville de Van Horne qui sera bouclée spécialement pour ces entraînements. Des réunions seront régulièrement organisées a chaque mission pour expliquer a chaque fois la repartition des équipes.
         </p>
         
         <h2 class="mt-4 text-lg font-semibold text-amber-900 mb-4 pb-2 border-b border-amber-300">Localisation de l'agence</h2>
                <p class="text-amber-900 leading-relaxed text-justify">
                Il serait parfait que l'agence soit établik a Saint-Denis, pour son avantage au niveau civil et de transport (Bateau, montgolfières) et son accessibilité au services des FDO (Prison de Sisika, etc..)          
                </p>
                
                 <h2 class="mt-4 text-lg font-semibold text-amber-900 mb-4 pb-2 border-b border-amber-300">Spécifications & clarification</h2>
                  <p class="text-amber-900 leading-relaxed text-justify">
                  L'agence ne garde en aucun cas les criminels capturés ! Ils sont transférés après capture a Sisika en bateau. L'agence n'effectue en aucun cas des patrouilles ou encore des rondes. Nos agents doivent pouvoir aller dans tout le pays librement sous n'importe quelle identité a des fins gouvernemental et de renseignement. Nos agents de terrain sont en autorisation d'agir pour capturer le criminel lorsque des agents sont sur les lieux. Lorsque ils sont sur le terrain, nous prenons et recevons régulièrement des nouvelles d'eux dans un protocole strict, comme par exemple l'obligation d'émettre un appel téléphonique chaque jour. Si l'agent vient à enfreindre une règle ou encore ne plus donner de nouvelle sans communication d'un télégramme a la place, nous laissons les autorités locals agir par une transmission de notre part. Les agents qui sont sur le terrain en enquête ou en quête d'informations sont en tenue de civile, dit camouflage. Cependant les agents de terrain n'ont en aucun cas la permission d'être en civile pendant leur service. Nos agents ne divulgue en aucun cas leur identité sous aucun prétexte, sauf au autorité local du compté ou ils se trouvent si ils le demandent. Pour clarifier, nos agents portent donc uniquement leur tenue sur des scènes de crime, en bureau, et lorsque le directeur l'exige. Les agents de terrain, eux, portent tout le temp leur tenue. L'agence est ouverte à recevoir bien évidemment des dossiers de fugitifs, tranmis par les FDO. 
                  </p>
                  <h2 class="mt-4 text-lg font-semibold text-amber-900 mb-4 pb-2 border-b border-amber-300">Transport</h2>
                   <p class="text-amber-900 leading-relaxed text-justify">
                   - Nos agents de terrain sont emmenés sur les lieux d'intervention par des calèches dirigés par le lieutenants en charge.
                   </p>
                   <p class="text-amber-900 leading-relaxed text-justify">
                   - Nos agents eux peuvent voyager avec leur destrier ou tout simplement en train. Ils doivent se faire le plus discret possible.
                   </p>
                     <h2 class="mt-4 text-lg font-semibold text-amber-900 mb-4 pb-2 border-b border-amber-300">Tenues</h2>
                     <p class="text-amber-900 leading-relaxed text-justify">
                     - Nos agents de terrains sont vêtu d'un gilet noir, une chemise blanche et une veste noir, ainsi qu'un chapeau rouge et un pantalon noir.             
                     </p>
                      <p class="text-amber-900 leading-relaxed text-justify">
                      - Nos agents sont vêtu d'un gilet noir, une chemise blanche et une veste bleu, ainsi qu'un chapeau rouge et un pantalon noir.
                      </p>
                          <p class="text-amber-900 leading-relaxed text-justify">
                          - Nos lieutenants sont vêtu d'un gilet rouge, une chemise blanche et une veste noir, ainsi qu'un chapeau casquette rouge et un pantalon noir.
                          </p>
                             <p class="text-amber-900 leading-relaxed text-justify">
                             - Notre directeur lui, est vêtu d'un gilet blanc, une chemise noir et un pantalon rouge.
                             </p>
                             
                              <h2 class="mt-4 text-lg font-semibold text-amber-900 mb-4 pb-2 border-b border-amber-300">Remerciements</h2>
                               <p class="text-amber-900 leading-relaxed text-justify">
                               L'agence a hâte de pouvoir renaître sur l'état américain et d'établir sont règlements, ainsi que de rencontrer ses premières unités. Je vous remercie infiniment pour la lecture de ce dossier, et hâte de voir votre réponse.
                               </p>
                              
    
    <div class="text-right pt-6 border-t border-amber-300">
        <div class="font-semibold text-amber-900">Mr. Robert Bob</div>
        <div class="text-sm text-amber-700">Directeur</div>
    </div>
    
</div>

</body>
</html>